/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.topology.helpers;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import org.fao.vrmf.core.behaviours.data.Mappable;
import org.fao.vrmf.core.extensions.collections.SerializableList;
import org.fao.vrmf.core.impl.logging.TransientLoggingAwareClient;
import org.fao.vrmf.core.tools.topology.GraphNode;
import org.fao.vrmf.core.tools.topology.WeightedGraph;
import org.fao.vrmf.core.tools.topology.WeightedGraphLink;
import org.fao.vrmf.core.tools.topology.algorithms.cycles.detection.CyclesDetector;
import org.fao.vrmf.core.tools.topology.algorithms.cycles.detection.impl.Tarjan;
import org.fao.vrmf.core.tools.topology.exceptions.CyclesDetectedRuntimeException;
import org.fao.vrmf.core.tools.topology.helpers.MappedDataManager;
import org.fao.vrmf.core.tools.topology.impl.SimpleWeightValue;

public class NonTransitiveMappedDataManager<I extends Serializable, M extends Mappable<I>>
extends TransientLoggingAwareClient
implements MappedDataManager<I, M> {
    private static final long serialVersionUID = 399233469555066922L;
    protected WeightedGraph<I> _graph = new WeightedGraph();
    protected Set<String> _mappingsFound = new TreeSet<String>();
    @Inject
    protected CyclesDetector<I> _detector = new Tarjan<I>();

    public NonTransitiveMappedDataManager() {
    }

    public NonTransitiveMappedDataManager(WeightedGraph<I> graph) {
        this();
        this._graph = graph;
        if (this._graph != null && this._graph.hasCycles(this._detector)) {
            throw new UnsupportedOperationException("Provided graph has cycles");
        }
    }

    @Override
    public void setDetector(CyclesDetector<I> detector) {
        assert (detector != null);
        this._detector = detector;
    }

    public NonTransitiveMappedDataManager(Collection<M> mappedData, boolean checkCyclesOnGraphBuild) {
        this();
        this.safelyAddMappedData(mappedData, checkCyclesOnGraphBuild);
    }

    public NonTransitiveMappedDataManager(Collection<M> mappedData) {
        this();
        this.addMappedData(mappedData);
    }

    @Override
    public void addMappedData(M mappedData) {
        this.safelyAddMappedData(mappedData, false);
    }

    @Override
    public void safelyAddMappedData(M mappedData, boolean checkCycles) {
        assert (mappedData != null) : "Data cannot be null";
        assert (mappedData.getId() != null) : "Data ID cannot be null";
        if (mappedData.getMapsTo() != null) {
            GraphNode source = new GraphNode(mappedData.getId());
            GraphNode target = new GraphNode(mappedData.getMapsTo());
            this._graph.linkIfNotYetLinked(source, target, new SimpleWeightValue(mappedData.getMappingWeight() == null ? 1.0 : mappedData.getMappingWeight()));
        }
        if (checkCycles && this._graph.hasCycles(this._detector)) {
            throw new CyclesDetectedRuntimeException("Adding mapped data " + mappedData + " will introduce a cycle in the underlying graph", this._graph.getCycles(this._detector));
        }
    }

    @Override
    public final void addMappedData(Collection<M> mappedDataCollection) {
        this.safelyAddMappedData(mappedDataCollection, false);
    }

    @Override
    public final void safelyAddMappedData(Collection<M> mappedDataCollection, boolean checkCycles) {
        assert (mappedDataCollection != null) : "Data collection cannot be null";
        for (Mappable entry : mappedDataCollection) {
            this.safelyAddMappedData(entry, checkCycles);
        }
    }

    @Override
    public final void removeMappedData(M mappedData) {
        assert (mappedData != null) : "Data cannot be null";
        assert (mappedData.getId() != null) : "Data ID cannot be null";
        this._graph.unlinkAll(this._graph.getNodeByIndex(mappedData.getId()));
    }

    @Override
    public boolean maps(M source, M target) {
        assert (source != null) : "Source cannot be null";
        if (target == null || target.getId() == null) {
            return false;
        }
        return this.maps((I)source.getId(), (I)target.getId());
    }

    @Override
    public boolean maps(I sourceID, I targetID) {
        assert (sourceID != null) : "Source ID cannot be null";
        assert (targetID != null) : "Target ID cannot be null";
        return this.maps(new GraphNode<I>(sourceID), new GraphNode<I>(targetID), this._graph, new HashSet<GraphNode<I>>());
    }

    protected boolean maps(GraphNode<I> source, GraphNode<I> target, WeightedGraph<I> graph, Set<GraphNode<I>> visitedNodes) {
        boolean maps;
        assert (source != null) : "Source cannot be null";
        assert (target != null) : "Target cannot be null";
        assert (source.getID() != null) : "Source identifier cannot be null";
        assert (target.getID() != null) : "Target identifier cannot be null";
        I sourceID = source.getID();
        I targetID = target.getID();
        StringBuilder key = new StringBuilder();
        key.append(sourceID).append("_").append(targetID);
        boolean bl = maps = sourceID.equals(targetID) || this._mappingsFound.contains(key.toString());
        if (maps) {
            return true;
        }
        if (!graph.getSourceNodeSet().contains(source) || graph.isLeaf(source)) {
            return false;
        }
        SerializableList<WeightedGraphLink<I>> links = graph.getAdjacents(source);
        visitedNodes.add(source);
        for (WeightedGraphLink weightedGraphLink : links) {
            if (!visitedNodes.contains(weightedGraphLink.getTarget())) {
                maps |= this.maps(weightedGraphLink.getTarget(), target, graph, visitedNodes);
            }
            if (maps) break;
        }
        if (maps) {
            this._mappingsFound.add(sourceID + "_" + targetID);
        }
        return maps;
    }

    @Override
    public synchronized Set<I> mappedNodes(I sourceNodeID) {
        TreeSet<I> mapped = new TreeSet<I>();
        GraphNode<I> node = this._graph.getNodeByIndex(sourceNodeID);
        if (node == null) {
            node = this._graph.getReversedGraph().getNodeByIndex(sourceNodeID);
        }
        if (sourceNodeID == null || node == null) {
            return null;
        }
        mapped.add(sourceNodeID);
        mapped.addAll(this.mappedNodes(this._graph.getNodeByIndex(sourceNodeID), mapped, this._graph));
        return mapped;
    }

    protected synchronized Set<I> mappedNodes(GraphNode<I> sourceNode, Set<I> alreadyMapped, WeightedGraph<I> graph) {
        if (sourceNode == null) {
            return alreadyMapped;
        }
        TreeSet mapped = new TreeSet();
        mapped.add(sourceNode.getID());
        if (this._graph.getAdjacents(sourceNode) != null) {
            for (WeightedGraphLink weightedGraphLink : this._graph.getAdjacents(sourceNode)) {
                GraphNode target = weightedGraphLink.getTarget();
                if (alreadyMapped.contains(target.getID())) continue;
                mapped.addAll(this.mappedNodes(target, mapped, this._graph));
            }
        }
        return mapped;
    }

    @Override
    public final WeightedGraph<I> getGraph() {
        return this._graph;
    }

    public final String toString() {
        return this._graph.toString();
    }
}

