/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.matchlets.skeleton;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fao.fi.comet.core.exceptions.MatchletConfigurationException;
import org.fao.fi.comet.core.matchlets.skeleton.behaviours.BasicBehaviour;
import org.fao.fi.comet.core.matchlets.skeleton.behaviours.BehaviourSkeleton;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.engine.MatchingResult;
import org.fao.fi.comet.core.model.engine.MatchingResultData;
import org.fao.fi.comet.core.model.matchlets.Matchlet;
import org.fao.fi.comet.core.model.matchlets.MatchletConfigurationParameter;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletDefaultSerializationExclusionPolicy;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletForcesComparisonByDefault;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletIsCutoffByDefault;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletIsOptionalByDefault;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletMetadata;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletParameter;
import org.fao.fi.comet.core.model.matchlets.annotations.parameters.DoubleRange;
import org.fao.fi.comet.core.model.matchlets.annotations.parameters.DoubleRangeFrom;
import org.fao.fi.comet.core.model.matchlets.support.MatchingSerializationExclusionPolicy;
import org.fao.fi.comet.core.model.matchlets.support.MatchletParameterConverter;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.vrmf.core.extensions.collections.impl.ListSet;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.CollectionsUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

public abstract class MatchletSkeleton<SOURCE, SOURCE_DATA extends Serializable, TARGET, TARGET_DATA extends Serializable>
implements Matchlet<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> {
    private static final long serialVersionUID = -1158509945093513149L;
    private static final Map<Class<?>, Set<String>> MANDATORY_FIELDS_MAP = new HashMap();
    @MatchletMetadata
    protected String _id;
    @MatchletMetadata
    protected String _name;
    @MatchletMetadata
    protected String _type;
    @MatchletParameter(name="weight", description="Sets the matchlet weight that will be used to calculate this' matchlet result relative contribution to the overall matching score for a given input / reference data pair. It is effective IFF more than one matchlet is chained together in the matching process. Its value must be strictly positive.")
    @DoubleRangeFrom(value=0.0, include=false)
    protected double _weight = 1.0;
    @MatchletParameter(name="minimumScore", description="Sets the matchlet minimum score threshold. Results (as yield by this' matchlet) with a score lower than the set threshold will be treated as NO MATCHes. Its value must be in the range [0.0, 1.0].")
    @DoubleRange(from=0.0, to=1.0, includeFrom=false, includeTo=true)
    protected double _minimumScore = 0.0;
    @MatchletParameter(name="isCutoff", description="Tells whether this matchlet is capable of returning authoritative matches (either NO MATCH or FULL MATCH) or not. If set to true, the matchlet will be applied as soon as possible, to ensure that as less comparisons as possible will be performed.")
    protected boolean _isCutoff;
    @MatchletParameter(name="isOptional", description="Tells whether this matchlet is optional or not. Optional matchlets returning a matching score of NON PERFORMED type will not contribute to the overall matching result for a given input / reference data pair.")
    protected boolean _isOptional;
    @MatchletParameter(name="forceComparison", description="Tells whether this matchlet will force data comparison even if one of the data being extracted from the compared entities is currently NULL.")
    protected boolean _forceComparison;
    protected MatchingSerializationExclusionPolicy[] _exclusionCases;
    @MatchletMetadata
    protected BehaviourSkeleton<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> _behaviour;

    public MatchletSkeleton() {
        this(new BasicBehaviour());
    }

    public MatchletSkeleton(BehaviourSkeleton<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> behaviour) {
        MatchingSerializationExclusionPolicy[] exclusionCases;
        AssertionUtils.$nNull(behaviour, "{} behaviour cannot be null", this.getClass().getName());
        this._behaviour = behaviour;
        if (this.getClass().isAnnotationPresent(MatchletDefaultSerializationExclusionPolicy.class) && (exclusionCases = this.getClass().getAnnotation(MatchletDefaultSerializationExclusionPolicy.class).value()) != null && exclusionCases.length > 0) {
            this.setExclusionCases(exclusionCases);
        }
        this.setCutoff(this.getClass().isAnnotationPresent(MatchletIsCutoffByDefault.class));
        this.setOptional(this.getClass().isAnnotationPresent(MatchletIsOptionalByDefault.class));
        this.setForceComparison(this.getClass().isAnnotationPresent(MatchletForcesComparisonByDefault.class));
        this._name = this._type = this.getClass().getSimpleName();
        this._id = this._type;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    public final void setName(String name) {
        this._name = name;
    }

    @Override
    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    @Override
    public final void configure(Collection<MatchletConfigurationParameter> parameters) throws MatchletConfigurationException {
        Class<?> key = this.getClass();
        Set<Object> mandatoryFields = new ListSet();
        ListSet transientFields = new ListSet();
        if (MANDATORY_FIELDS_MAP.containsKey(key)) {
            mandatoryFields = MANDATORY_FIELDS_MAP.get(this.getClass());
        } else {
            for (Field field : ObjectsUtils.getAllAnnotatedFields(this, MatchletParameter.class)) {
                field.setAccessible(true);
                MatchletParameter annotation = field.getAnnotation(MatchletParameter.class);
                String name = annotation.name();
                if (name == null || "".equals(name)) {
                    name = field.getName();
                }
                if ((field.getModifiers() | 0x80) == 128) {
                    transientFields.add(name);
                    continue;
                }
                if (!annotation.mandatory()) continue;
                mandatoryFields.add(name);
            }
            MANDATORY_FIELDS_MAP.put(key, mandatoryFields);
        }
        try {
            mandatoryFields = new HashSet(mandatoryFields);
            if (parameters != null) {
                for (MatchletConfigurationParameter parameter : parameters) {
                    AssertionUtils.$nNull(parameter, "Invalid NULL matchlet configuration parameter for {}", this.getName());
                    mandatoryFields.remove(parameter.getName());
                    this.setParameter(parameter);
                }
            }
            AssertionUtils.$em(mandatoryFields, "{} mandatory parameters ({}) have not been provided as part of {} configuration", mandatoryFields.size(), CollectionsUtils.join(mandatoryFields, ", "), this.getName());
        }
        catch (IllegalArgumentException IAe) {
            throw new MatchletConfigurationException(IAe.getMessage());
        }
    }

    @Override
    public final void validateConfiguration() throws MatchletConfigurationException {
        AssertionUtils.$pos(this._weight, "{} weight must be greater than zero (currently: {})", this.getName(), this._weight);
        AssertionUtils.$gte(this._minimumScore, 0.0, "{} minimum allowed score must be greater than (or equal to) {} (currently: {})", this.getName(), 0.0, this._minimumScore);
        AssertionUtils.$lte(this._minimumScore, 1.0, "{} minimum allowed score must be lower than (or equal to) {} (currently: {})", this.getName(), 1.0, this._minimumScore);
        this.doValidateConfiguration();
    }

    protected abstract void doValidateConfiguration() throws MatchletConfigurationException;

    @Override
    public final Collection<MatchletConfigurationParameter> getConfiguration() throws MatchletConfigurationException {
        ArrayList<MatchletConfigurationParameter> parameters = new ArrayList<MatchletConfigurationParameter>();
        try {
            boolean isTransient = false;
            for (Field field : ObjectsUtils.getAllAnnotatedFields(this, MatchletParameter.class)) {
                field.setAccessible(true);
                MatchletParameter annotation = field.getAnnotation(MatchletParameter.class);
                isTransient = (field.getModifiers() & 0x80) == 128;
                MatchletConfigurationParameter parameter = new MatchletConfigurationParameter();
                parameter.setName(annotation.name());
                parameter.setValue(this.getParameterValue(field));
                parameter.setTransient(isTransient);
                parameters.add(parameter);
            }
        }
        catch (Throwable t) {
            throw new MatchletConfigurationException("Unable to retrieve configuration parameters for " + this.getName() + " [ " + t.getClass().getSimpleName() + ": " + t.getMessage() + " ]");
        }
        return parameters;
    }

    @Override
    public final Matchlet<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> setExclusionCases(MatchingSerializationExclusionPolicy ... exclusionCases) {
        this._exclusionCases = exclusionCases;
        return this;
    }

    @Override
    public final MatchingSerializationExclusionPolicy[] getExclusionCases() {
        return this._exclusionCases;
    }

    @Override
    public final boolean forceComparison() {
        return this._forceComparison;
    }

    @Override
    public final Matchlet<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> setForceComparison(boolean forceComparison) {
        this._forceComparison = forceComparison;
        return this;
    }

    @Override
    public final boolean isOptional() {
        return this._isOptional;
    }

    @Override
    public final Matchlet<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> setOptional(boolean optional) {
        this._isOptional = optional;
        return this;
    }

    @Override
    public final boolean isCutoff() {
        return this._isCutoff;
    }

    @Override
    public final Matchlet<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> setCutoff(boolean cutoff) {
        this._isCutoff = cutoff;
        return this;
    }

    @Override
    public final Matchlet<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> setWeight(double weight) {
        assert (Double.compare(weight, 0.0) > 0) : "The matchlet's weight cannot be lower than or equal to zero";
        this._weight = weight;
        return this;
    }

    @Override
    public final double getWeight() {
        return this._weight;
    }

    @Override
    public final Matchlet<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> setMinimumAllowedScore(double minimumScore) {
        assert (Double.compare(minimumScore, 0.0) >= 0) : "The minimum allowed score cannot be lower than 0.0";
        assert (Double.compare(minimumScore, 1.0) <= 0) : "The minimum allowed score cannot be greater than 1.0";
        this._minimumScore = minimumScore;
        return this;
    }

    @Override
    public final Double getMinimumScore() {
        return this._minimumScore;
    }

    @Override
    public final boolean isScoreAllowed(MatchingScore score) {
        assert (score != null) : "The score cannot be null";
        return score.isAuthoritative() || score.isNonPerformed() || Double.compare(score.getValue(), this._minimumScore) >= 0;
    }

    @Override
    public final MatchingResult<SOURCE_DATA, TARGET_DATA> performMatching(SOURCE sourceEntity, DataIdentifier sourceIdentifier, TARGET targetEntity, DataIdentifier targetIdentifier) {
        AssertionUtils.$nNull(sourceEntity, "Source entity cannot be null", new Object[0]);
        AssertionUtils.$nNull(sourceIdentifier, "Source entity identifier cannot be null", new Object[0]);
        AssertionUtils.$nNull(targetEntity, "Target entity cannot be null", new Object[0]);
        AssertionUtils.$nNull(targetIdentifier, "Target entity identifier cannot be null", new Object[0]);
        MatchingResult<SOURCE_DATA, TARGET_DATA> result = this.compareData(sourceEntity, sourceIdentifier, targetEntity, targetIdentifier);
        if (!this.isScoreAllowed(result.getScore())) {
            result.setScore(MatchingScore.getNonAuthoritativeNoMatchTemplate());
        }
        return result;
    }

    public abstract MatchingResult<SOURCE_DATA, TARGET_DATA> compareData(SOURCE var1, DataIdentifier var2, TARGET var3, DataIdentifier var4);

    protected final MatchingResult<SOURCE_DATA, TARGET_DATA> updateResult(MatchingResult<SOURCE_DATA, TARGET_DATA> result, MatchingScore score, SOURCE_DATA sourceData, DataIdentifier sourceIdentifier, Collection<TARGET_DATA> targetData) {
        ArrayList matchings = new ArrayList();
        matchings.add(new MatchingResultData<SOURCE_DATA, TARGET_DATA>(score, sourceData, sourceIdentifier, targetData));
        result.setScore(score);
        result.setMatchingsResultData(matchings);
        return result;
    }

    protected final MatchingResult<SOURCE_DATA, TARGET_DATA> updateResult(MatchingResult<SOURCE_DATA, TARGET_DATA> result, MatchingScore score, SOURCE_DATA sourceData, DataIdentifier sourceIdentifier, TARGET_DATA targetData) {
        return this.updateResult(result, score, sourceData, sourceIdentifier, (TARGET_DATA)this.convertToCollection((Serializable)targetData));
    }

    @Override
    public final int compareTo(Matchlet<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> other) {
        if (this.isCutoff()) {
            return Integer.MIN_VALUE;
        }
        return Double.compare(other.getWeight(), this._weight);
    }

    protected final <DATA extends Serializable> Collection<DATA> convertToCollection(DATA data) {
        ArrayList<DATA> toReturn = new ArrayList<DATA>();
        toReturn.add(data);
        return toReturn;
    }

    private void setParameter(MatchletConfigurationParameter parameter) throws MatchletConfigurationException {
        AssertionUtils.$nNull(parameter, "Cannot set a NULL configuration parameter on {}", this.getName());
        AssertionUtils.$nNull(StringUtils.rawTrim(parameter.getName()), "Cannot set a no-name configuration parameter on {}", this.getName());
        String parameterName = parameter.getName();
        Field toSet = null;
        for (Field field : ObjectsUtils.getAllAnnotatedFields(this, MatchletParameter.class)) {
            field.setAccessible(true);
            MatchletParameter annotation = field.getAnnotation(MatchletParameter.class);
            if (!parameterName.equals(annotation.name())) continue;
            toSet = field;
            break;
        }
        AssertionUtils.$nNull(toSet, "No configuration parameter named {} found on {}", parameterName, this.getName());
        try {
            this.setParameterValue(toSet, parameter.getValue());
        }
        catch (Throwable t) {
            throw new MatchletConfigurationException("Unable to set configuration parameter " + parameter.getName() + " (valued " + parameter.getValue() + ") on " + this.getName() + " [ " + t.getClass().getSimpleName() + ": " + t.getMessage() + " ]");
        }
    }

    private void setParameterValue(Field field, Object value) throws Throwable {
        if (value == null) {
            field.set(this, null);
        }
        MatchletParameter annotation = field.getAnnotation(MatchletParameter.class);
        MatchletParameterConverter converter = annotation.converter().newInstance();
        if ((field.getModifiers() & 0x80) != 128) {
            if (field.getType().isArray()) {
                field.set(this, converter.convertToArrayFromString(field.getType().getComponentType(), (String)value));
            } else {
                field.set(this, converter.convertFromString(field.getType(), (String)value));
            }
        } else {
            field.set(this, value);
        }
    }

    private String getParameterValue(Field field) throws Throwable {
        Object value = field.get(this);
        if (value == null) {
            return null;
        }
        MatchletParameter annotation = field.getAnnotation(MatchletParameter.class);
        MatchletParameterConverter converter = annotation.converter().newInstance();
        return converter.convertToString(value);
    }

    @Override
    public MatchingResult<SOURCE_DATA, TARGET_DATA> newMatchingResult() {
        MatchingResult result = new MatchingResult();
        result.setOriginatingMatchletId(this._id);
        result.setOriginatingMatchletName(this._name);
        result.setOriginatingMatchletWeight(this._weight);
        result.setOriginatingMatchletExclusionPolicies(this._exclusionCases);
        return result;
    }
}

