/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.io.providers.streaming;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.fao.fi.comet.core.model.common.LinkedTypedComplexName;
import org.fao.fi.comet.core.patterns.data.providers.ProvidedData;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.tools.io.providers.streaming.AbstractSpeciesReferenceDataProvider;
import org.fao.fi.comet.domain.species.tools.io.readers.ReferenceDataFileReader;
import org.fao.fi.comet.domain.species.tools.io.support.ReferenceDataConverter;

public abstract class AbstractSerializedSpeciesReferenceDataProvider
extends AbstractSpeciesReferenceDataProvider {
    protected final ReferenceDataFileReader<ReferenceSpeciesData> _reader = new ReferenceDataFileReader();
    protected ReferenceDataConverter<ReferenceSpeciesData> _converter = this.getDefaultConverter();
    protected InputStream _rawIs = null;
    protected InputStream _actualIs = null;
    protected InputStreamReader _ir = null;
    protected BufferedReader _br = null;

    protected abstract URL getActualURL(String var1) throws IOException;

    public abstract ReferenceDataConverter<ReferenceSpeciesData> getDefaultConverter();

    protected abstract InputStream getActualInputStream(InputStream var1) throws IOException;

    protected final String unwrap(String wrapped) {
        return wrapped == null ? null : wrapped.substring(1, wrapped.length() - 1);
    }

    @Override
    public void setConverter(ReferenceDataConverter<ReferenceSpeciesData> toSet) {
        this._converter = toSet;
    }

    @Override
    public final void testEndpoint(String resourceURI) throws IOException {
        URLConnection connection = null;
        try {
            connection = this.getActualURL(resourceURI).openConnection();
        }
        catch (Throwable t) {
            throw new FileNotFoundException("Unable to access resource at " + resourceURI + ": " + t.getMessage());
        }
        InputStream is = null;
        try {
            is = connection.getInputStream();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    protected final Iterator<String> sourceDataIterator() {
        try {
            this._rawIs = this.getActualURL(this._taxaResourceURI).openStream();
            this._actualIs = this.getActualInputStream(this._rawIs);
            this._ir = new InputStreamReader(this._actualIs, "UTF-8");
            return new StreamLinesIterator(this._ir);
        }
        catch (Throwable t) {
            return new StreamLinesIterator();
        }
    }

    @Override
    public final int getAvailableDataSize() {
        InputStream rawIs = null;
        InputStream actualIs = null;
        InputStreamReader ir = null;
        BufferedReader br = null;
        try {
            rawIs = this.getActualURL(this._taxaResourceURI).openStream();
            actualIs = this.getActualInputStream(rawIs);
            ir = new InputStreamReader(actualIs);
            br = new BufferedReader(ir);
            int lines = 0;
            while (br.readLine() != null) {
                ++lines;
            }
            int n = lines - 1;
            return n;
        }
        catch (Throwable t) {
            this._log.error("Unable to access streaming data provided by {}", (Object)this.getProviderID(), (Object)t);
            return -1;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Throwable t) {
                    this._log.warn("Unable to close reader", t);
                }
            }
            if (actualIs != null) {
                try {
                    actualIs.close();
                }
                catch (Throwable t) {
                    this._log.warn("Unable to close input stream", t);
                }
            }
            if (rawIs != null) {
                try {
                    rawIs.close();
                }
                catch (Throwable t) {
                    this._log.warn("Unable to close input stream", t);
                }
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (Throwable t) {
                    this._log.warn("Unable to close input stream", t);
                }
            }
        }
    }

    @Override
    public Iterable<ProvidedData<ReferenceSpeciesData>> seek(int position) throws NoSuchElementException {
        final Iterator<ProvidedData<ReferenceSpeciesData>> $iterator = this.iterator();
        int p = 0;
        while (p < position) {
            $iterator.next();
            ++p;
        }
        return new Iterable<ProvidedData<ReferenceSpeciesData>>(){

            @Override
            public Iterator<ProvidedData<ReferenceSpeciesData>> iterator() {
                return $iterator;
            }
        };
    }

    @Override
    public void rewind() {
    }

    @Override
    public final Iterator<ProvidedData<ReferenceSpeciesData>> iterator() {
        return new TransformingIterator(this.sourceDataIterator(), this._vernacularNamesMap);
    }

    /*
     * Loose catch block
     */
    @Override
    protected final LinkedTypedComplexName[] getVernacularNames(String vernacularNamesResourceURI) throws IOException {
        LinkedTypedComplexName[] linkedTypedComplexNameArray;
        BufferedReader br;
        InputStreamReader ir;
        InputStream actualIs;
        InputStream rawIs;
        block40: {
            String line;
            if (vernacularNamesResourceURI == null) {
                return null;
            }
            rawIs = null;
            actualIs = null;
            ir = null;
            br = null;
            rawIs = this.getActualURL(vernacularNamesResourceURI).openStream();
            actualIs = this.getActualInputStream(rawIs);
            ir = new InputStreamReader(actualIs, "UTF-8");
            br = new BufferedReader(ir);
            ArrayList<LinkedTypedComplexName> vernacularNames = new ArrayList<LinkedTypedComplexName>();
            while ((line = br.readLine()) != null) {
                LinkedTypedComplexName vernacularName = this._converter.deserializeVernacularCName(this.getProviderID(), line);
                if (vernacularName == null || vernacularName.isEmpty()) continue;
                vernacularNames.add(vernacularName);
            }
            LinkedTypedComplexName[] linkedTypedComplexNameArray2 = linkedTypedComplexNameArray = vernacularNames.isEmpty() ? null : vernacularNames.toArray(new LinkedTypedComplexName[vernacularNames.size()]);
            if (br == null) break block40;
            try {
                br.close();
            }
            catch (Throwable t) {
                this._log.error("Cannot close buffered reader for {}. Unexpected {} caught [ reason: {} ]", new Object[]{vernacularNamesResourceURI, t.getClass(), t.getMessage()});
            }
        }
        if (ir != null) {
            try {
                ir.close();
            }
            catch (Throwable t) {
                this._log.error("Cannot close input stream reader for {}. Unexpected {} caught [ reason: {} ]", new Object[]{vernacularNamesResourceURI, t.getClass(), t.getMessage()});
            }
        }
        if (actualIs != null) {
            try {
                actualIs.close();
            }
            catch (Throwable t) {
                this._log.error("Cannot close input stream for {}. Unexpected {} caught [ reason: {} ]", new Object[]{vernacularNamesResourceURI, t.getClass(), t.getMessage()});
            }
        }
        if (rawIs != null) {
            try {
                rawIs.close();
            }
            catch (Throwable t) {
                this._log.error("Cannot close input stream for {}. Unexpected {} caught [ reason: {} ]", new Object[]{vernacularNamesResourceURI, t.getClass(), t.getMessage()});
            }
        }
        return linkedTypedComplexNameArray;
        catch (Throwable t) {
            block41: {
                try {
                    this._log.error("Unable to read line from {}. Unexpected {} caught [ reason: {} ]", new Object[]{vernacularNamesResourceURI, t.getClass().getSimpleName(), t.getMessage()});
                    if (br == null) break block41;
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable t2) {
                            this._log.error("Cannot close buffered reader for {}. Unexpected {} caught [ reason: {} ]", new Object[]{vernacularNamesResourceURI, t2.getClass(), t2.getMessage()});
                        }
                    }
                    if (ir != null) {
                        try {
                            ir.close();
                        }
                        catch (Throwable t3) {
                            this._log.error("Cannot close input stream reader for {}. Unexpected {} caught [ reason: {} ]", new Object[]{vernacularNamesResourceURI, t3.getClass(), t3.getMessage()});
                        }
                    }
                    if (actualIs != null) {
                        try {
                            actualIs.close();
                        }
                        catch (Throwable t4) {
                            this._log.error("Cannot close input stream for {}. Unexpected {} caught [ reason: {} ]", new Object[]{vernacularNamesResourceURI, t4.getClass(), t4.getMessage()});
                        }
                    }
                    if (rawIs != null) {
                        try {
                            rawIs.close();
                        }
                        catch (Throwable t5) {
                            this._log.error("Cannot close input stream for {}. Unexpected {} caught [ reason: {} ]", new Object[]{vernacularNamesResourceURI, t5.getClass(), t5.getMessage()});
                        }
                    }
                    throw throwable;
                }
                try {
                    br.close();
                }
                catch (Throwable t6) {
                    this._log.error("Cannot close buffered reader for {}. Unexpected {} caught [ reason: {} ]", new Object[]{vernacularNamesResourceURI, t6.getClass(), t6.getMessage()});
                }
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (Throwable t7) {
                    this._log.error("Cannot close input stream reader for {}. Unexpected {} caught [ reason: {} ]", new Object[]{vernacularNamesResourceURI, t7.getClass(), t7.getMessage()});
                }
            }
            if (actualIs != null) {
                try {
                    actualIs.close();
                }
                catch (Throwable t8) {
                    this._log.error("Cannot close input stream for {}. Unexpected {} caught [ reason: {} ]", new Object[]{vernacularNamesResourceURI, t8.getClass(), t8.getMessage()});
                }
            }
            if (rawIs != null) {
                try {
                    rawIs.close();
                }
                catch (Throwable t9) {
                    this._log.error("Cannot close input stream for {}. Unexpected {} caught [ reason: {} ]", new Object[]{vernacularNamesResourceURI, t9.getClass(), t9.getMessage()});
                }
            }
            return null;
        }
    }

    protected final ReferenceSpeciesData convertTaxaData(String line, Map<String, LinkedTypedComplexName[]> vernacularNamesMap) {
        return this._converter.deserialize(this.getProviderID(), line, vernacularNamesMap);
    }

    @Override
    protected final void doReleaseResources() throws Exception {
        if (this._br != null) {
            try {
                this._br.close();
            }
            catch (Throwable t) {
                this._log.warn("Unable to close buffered reader for {}", (Object)this.getProviderID());
            }
        }
        if (this._ir != null) {
            try {
                this._ir.close();
            }
            catch (Throwable t) {
                this._log.warn("Unable to close input reader for {}", (Object)this.getProviderID());
            }
        }
        if (this._actualIs != null) {
            try {
                this._actualIs.close();
            }
            catch (Throwable t) {
                this._log.warn("Unable to close actual input stream for {}", (Object)this.getProviderID());
            }
        }
        if (this._rawIs != null) {
            try {
                this._rawIs.close();
            }
            catch (Throwable t) {
                this._log.warn("Unable to close raw input stream for {}", (Object)this.getProviderID());
            }
        }
    }

    private class StreamLinesIterator
    implements Iterator<String> {
        private String _line;
        private InputStreamReader _is;
        private BufferedReader _br;

        public StreamLinesIterator() {
            this._line = null;
        }

        public StreamLinesIterator(InputStreamReader streamReader) throws IOException {
            this._is = streamReader;
            this._br = new BufferedReader(streamReader);
            this._line = this._br.readLine();
            this._line = this._br.readLine();
            this.handleEOF();
        }

        private void handleEOF() {
            if (this._line == null) {
                try {
                    this._br.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this._is.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this._line != null;
        }

        @Override
        public String next() {
            String current = this._line;
            if (current == null) {
                throw new NoSuchElementException();
            }
            try {
                this._line = this._br.readLine();
            }
            catch (Throwable t) {
                this._line = null;
            }
            this.handleEOF();
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class TransformingIterator
    implements Iterator<ProvidedData<ReferenceSpeciesData>> {
        private final Iterator<String> _dataIterator;
        private final Map<String, LinkedTypedComplexName[]> _vernacularNamesMap;

        public TransformingIterator(Iterator<String> dataIterator, Map<String, LinkedTypedComplexName[]> vernacularNamesMap) {
            this._dataIterator = dataIterator;
            this._vernacularNamesMap = vernacularNamesMap;
        }

        @Override
        public boolean hasNext() {
            return this._dataIterator.hasNext();
        }

        @Override
        public ProvidedData<ReferenceSpeciesData> next() {
            return new ProvidedData<ReferenceSpeciesData>(AbstractSerializedSpeciesReferenceDataProvider.this.getProviderID(), AbstractSerializedSpeciesReferenceDataProvider.this.convertTaxaData(this._dataIterator.next(), this._vernacularNamesMap));
        }

        @Override
        public void remove() {
            this._dataIterator.remove();
        }
    }
}

