/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.impl.data;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.fao.vrmf.core.behaviours.data.composite.ComplexNameAware;
import org.fao.vrmf.core.extensions.collections.impl.ListSet;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.fao.vrmf.core.models.data.GenericData;

@XmlType(name="ComplexNameData")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ComplexNameData
extends GenericData
implements ComplexNameAware,
Comparable<ComplexNameData> {
    private static final long serialVersionUID = -2792225810196322933L;
    @XmlElement(name="name")
    private String _name;
    @XmlElement(name="simplifiedName")
    private String _simplifiedName;
    @XmlTransient
    private String[] _simplifiedNameNGrams;
    @XmlElement(name="simplifiedNameSoundex")
    private String _simplifiedNameSoundex;
    @XmlTransient
    private String[] _simplifiedNameSoundexParts;

    public ComplexNameData() {
    }

    public ComplexNameData(String name, String simplifiedName, String[] simplifiedNameNGrams, String simplifiedNameSoundex) {
        this._name = name;
        this._simplifiedName = simplifiedName;
        this._simplifiedNameSoundex = simplifiedNameSoundex;
        this._simplifiedNameSoundexParts = new String[0];
        this.setSimplifiedNameNGrams(simplifiedNameNGrams);
        if (this._simplifiedNameSoundex != null) {
            ListSet parts = new ListSet();
            String[] stringArray = this._simplifiedNameSoundex.split("\\s");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if ((part = StringUtils.rawTrim(part)) != null) {
                    parts.add(part);
                }
                ++n2;
            }
            if (!parts.isEmpty()) {
                this._simplifiedNameSoundexParts = parts.toArray(new String[parts.size()]);
            }
        }
    }

    @Override
    public int compareTo(ComplexNameData other) {
        if (other == null) {
            return 1;
        }
        if (this.equals(other) || this == other) {
            return 0;
        }
        int result = this._name == null ? (other._name == null ? 0 : -1) : (other._name == null ? 1 : this._name.compareTo(other._name));
        return result;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getSimplifiedName() {
        return this._simplifiedName;
    }

    @Override
    public void setSimplifiedName(String simplifiedName) {
        this._simplifiedName = simplifiedName;
    }

    public String[] getSimplifiedNameNGrams() {
        return this._simplifiedNameNGrams;
    }

    public void setSimplifiedNameNGrams(String[] simplifiedNameNGrams) {
        this._simplifiedNameNGrams = simplifiedNameNGrams;
    }

    @Override
    public String getSimplifiedNameSoundex() {
        return this._simplifiedNameSoundex;
    }

    @Override
    public void setSimplifiedNameSoundex(String simplifiedNameSoundex) {
        this._simplifiedNameSoundex = simplifiedNameSoundex;
    }

    public String[] getSimplifiedNameSoundexParts() {
        return this._simplifiedNameSoundexParts;
    }

    public void setSimplifiedNameSoundexParts(String[] simplifiedNameSoundexParts) {
        this._simplifiedNameSoundexParts = simplifiedNameSoundexParts;
    }

    @Override
    public boolean isEmpty() {
        return !(this._name != null && StringUtils.rawTrim(this._name) != null || this._simplifiedName != null && StringUtils.rawTrim(this._simplifiedName) != null || this._simplifiedNameNGrams != null && this._simplifiedNameNGrams.length != 0 || this._simplifiedNameSoundex != null && StringUtils.rawTrim(this._simplifiedNameSoundex) != null || this._simplifiedNameSoundexParts != null && this._simplifiedNameSoundexParts.length != 0);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + (this._simplifiedName == null ? 0 : this._simplifiedName.hashCode());
        result = 31 * result + Arrays.hashCode(this._simplifiedNameNGrams);
        result = 31 * result + (this._simplifiedNameSoundex == null ? 0 : this._simplifiedNameSoundex.hashCode());
        result = 31 * result + Arrays.hashCode(this._simplifiedNameSoundexParts);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexNameData other = (ComplexNameData)obj;
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        if (this._simplifiedName == null ? other._simplifiedName != null : !this._simplifiedName.equals(other._simplifiedName)) {
            return false;
        }
        if (!Arrays.equals(this._simplifiedNameNGrams, other._simplifiedNameNGrams)) {
            return false;
        }
        if (this._simplifiedNameSoundex == null ? other._simplifiedNameSoundex != null : !this._simplifiedNameSoundex.equals(other._simplifiedNameSoundex)) {
            return false;
        }
        return Arrays.equals(this._simplifiedNameSoundexParts, other._simplifiedNameSoundexParts);
    }
}

