/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.model.matchlets.support;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import org.fao.fi.comet.core.model.matchlets.support.MatchletParameterConverter;
import org.fao.vrmf.core.helpers.singletons.lang.objects.CollectionsUtils;

public class DefaultMatchletParameterConverter
implements MatchletParameterConverter {
    @Override
    public String convertToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return CollectionsUtils.join((Object[])value, "|");
        }
        if (Collections.class.isAssignableFrom(value.getClass())) {
            return CollectionsUtils.join((Collection)value, "([^|]|([^|])");
        }
        return value.toString();
    }

    @Override
    public <C> Object convertToArrayFromString(Class<C> componentClazz, String value) {
        String[] values = value.split("\\|");
        Object[] array = (Object[])Array.newInstance(componentClazz, values.length);
        int counter = 0;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String currentValue = stringArray[n2];
            array[counter++] = this.convertFromString(componentClazz, currentValue);
            ++n2;
        }
        return array;
    }

    @Override
    public Object convertFromString(Class<?> clazz, String value) {
        if (value == null) {
            return null;
        }
        if (clazz.isEnum()) {
            return Enum.valueOf(clazz, value);
        }
        if (String.class.equals(clazz)) {
            return value;
        }
        if (clazz.isPrimitive()) {
            String clazzName = clazz.getName();
            if ("boolean".equals(clazzName)) {
                return Boolean.valueOf(value);
            }
            if ("byte".equals(clazzName)) {
                return Byte.valueOf(value);
            }
            if ("short".equals(clazzName)) {
                return Short.valueOf(value);
            }
            if ("int".equals(clazzName)) {
                return Integer.valueOf(value);
            }
            if ("long".equals(clazzName)) {
                return Long.valueOf(value);
            }
            if ("float".equals(clazzName)) {
                return Float.valueOf(value);
            }
            if ("double".equals(clazzName)) {
                return Double.valueOf(value);
            }
            if ("char".equals(clazzName)) {
                if (value.length() > 1) {
                    throw new IllegalArgumentException("Cannot assign a char value from '" + value + "'");
                }
                if (value.length() == 0) {
                    return null;
                }
                return new Character(value.charAt(0));
            }
        } else {
            if (Character.class.equals(clazz)) {
                if (value.length() > 1) {
                    throw new IllegalArgumentException("Cannot assign a char value from '" + value + "'");
                }
                if (value.length() == 0) {
                    return null;
                }
                return new Character(value.charAt(0));
            }
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getConstructor(String.class);
                constructor.setAccessible(true);
                return constructor.newInstance(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Cannot assign a value to field of type " + clazz + " from string value '" + value + "'");
    }
}

