/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.model.support;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.fao.fi.comet.core.model.support.MatchingType;
import org.fao.fi.comet.core.model.support.UnmodifiableMatchingScore;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.tools.topology.behaviours.WeightValue;

@XmlType(name="MatchingScore")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MatchingScore
implements WeightValue {
    private static final long serialVersionUID = -8215970917574197230L;
    public static final double SCORE_FULL_MATCH = 1.0;
    public static final double SCORE_NO_MATCH = 0.0;
    @XmlAttribute(name="value")
    protected double _value = 0.0;
    @XmlAttribute(name="type")
    protected MatchingType _matchingType = MatchingType.NON_PERFORMED;
    private static final MatchingScore NO_MATCH_NON_AUTHORITATIVE = new UnmodifiableMatchingScore(0.0, MatchingType.NON_AUTHORITATIVE);
    private static final MatchingScore NO_MATCH_AUTHORITATIVE = new UnmodifiableMatchingScore(0.0, MatchingType.AUTHORITATIVE);
    private static final MatchingScore MATCH_NON_AUTHORITATIVE = new UnmodifiableMatchingScore(1.0, MatchingType.NON_AUTHORITATIVE);
    private static final MatchingScore MATCH_AUTHORITATIVE = new UnmodifiableMatchingScore(1.0, MatchingType.AUTHORITATIVE);
    private static final MatchingScore NON_PERFORMED = new MatchingScore();

    public MatchingScore() {
    }

    public MatchingScore(double value, MatchingType matchingType) {
        this.setValue(value);
        this.setMatchingType(matchingType);
    }

    public MatchingScore(MatchingScore another) {
        AssertionUtils.$nNull(another, "Provided score cannot be null", new Object[0]);
        this.setValue(another.getValue());
        this.setMatchingType(another.getMatchingType());
    }

    public final double getValue() {
        return this._value;
    }

    public void setValue(double value) {
        AssertionUtils.$gte(value, 0.0, "Score value {} cannot be lower than the minimum allowed ({})", value, 0.0);
        AssertionUtils.$lte(value, 1.0, "Score value {} cannot be higher than the maximum allowed ({})", value, 1.0);
        this._value = value;
    }

    public void increaseValue(double valueDelta) {
        AssertionUtils.$gte(valueDelta, 0.0, "Score value delta ({}) cannot be lower than the minimum allowed ({})", valueDelta, 0.0);
        AssertionUtils.$lte(valueDelta, 1.0, "Score value delta ({}) cannot be higher than the maximum allowed ({})", valueDelta, 1.0);
        AssertionUtils.$lte(this._value + valueDelta, 1.0, "Score value ({}) cannot be higher than the maximum allowed ({})", this._value + valueDelta, 1.0);
        this._value += valueDelta;
    }

    public final MatchingType getMatchingType() {
        return this._matchingType;
    }

    public void setMatchingType(MatchingType matchingType) {
        AssertionUtils.$nNull(matchingType, "Matching type cannot be null", new Object[0]);
        this._matchingType = matchingType;
    }

    public final boolean isAuthoritative() {
        return this._matchingType.isAuthoritative();
    }

    public final boolean isNonAuthoritative() {
        return this._matchingType.isNonAuthoritative();
    }

    public final boolean isNonPerformed() {
        return this._matchingType.isNonPerformed();
    }

    public final boolean isNoMatch() {
        return !this.isNonPerformed() && Double.compare(this._value, 0.0) == 0;
    }

    public final boolean isFullMatch() {
        return Double.compare(this._value, 1.0) == 0;
    }

    public static MatchingScore getNonPerformedTemplate() {
        return NON_PERFORMED;
    }

    public static MatchingScore getAuthoritativeNoMatchTemplate() {
        return NO_MATCH_AUTHORITATIVE;
    }

    public static MatchingScore getAuthoritativeFullMatchTemplate() {
        return MATCH_AUTHORITATIVE;
    }

    public static MatchingScore getNonAuthoritativeNoMatchTemplate() {
        return NO_MATCH_NON_AUTHORITATIVE;
    }

    public static MatchingScore getNonAuthoritativeFullMatchTemplate() {
        return MATCH_NON_AUTHORITATIVE;
    }

    @Override
    public MatchingScore multiply(WeightValue another) {
        AssertionUtils.$nNull(another, "The other operand cannot be null", new Object[0]);
        boolean currentAuthoritative = this.isAuthoritative();
        boolean anotherAuthoritative = another instanceof MatchingScore && ((MatchingScore)another).isAuthoritative();
        boolean bothAuthoritative = currentAuthoritative && anotherAuthoritative;
        return new MatchingScore(this.toDouble() * another.toDouble(), bothAuthoritative ? MatchingType.AUTHORITATIVE : MatchingType.NON_AUTHORITATIVE);
    }

    @Override
    public final double toDouble() {
        return this._value;
    }

    @Override
    public final int compareTo(WeightValue another) {
        boolean noneAuthoritative;
        AssertionUtils.$nNull(another, "The other operand cannot be null", new Object[0]);
        boolean currentAuthoritative = this.isAuthoritative();
        boolean anotherAuthoritative = another instanceof MatchingScore && ((MatchingScore)another).isAuthoritative();
        boolean bothAuthoritative = currentAuthoritative && anotherAuthoritative;
        boolean bl = noneAuthoritative = !currentAuthoritative && !anotherAuthoritative;
        if (bothAuthoritative || noneAuthoritative) {
            return Double.compare(this.toDouble(), another.toDouble());
        }
        if (currentAuthoritative) {
            return 1;
        }
        return -1;
    }

    public final MatchingScore reverse() {
        if (this.isAuthoritative()) {
            return this.isFullMatch() ? MatchingScore.getAuthoritativeNoMatchTemplate() : MatchingScore.getAuthoritativeFullMatchTemplate();
        }
        if (this.isNonPerformed()) {
            return this;
        }
        MatchingScore reversed = new MatchingScore(this);
        reversed.setValue(1.0 - reversed.getValue());
        return reversed;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this._matchingType == null ? 0 : this._matchingType.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchingScore)) {
            return false;
        }
        MatchingScore other = (MatchingScore)obj;
        if (Double.doubleToLongBits(this._value) != Double.doubleToLongBits(other._value)) {
            return false;
        }
        return this._matchingType == other._matchingType;
    }

    public final String toString() {
        return "[ S: " + this._value + ", MT: " + this._matchingType + " ]";
    }
}

