/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.singletons.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.fao.vrmf.core.extensions.collections.impl.ListSet;
import org.fao.vrmf.core.helpers.singletons.AbstractHelperSingleton;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.text.jni.CLevenshtein;
import org.slf4j.Logger;

public class StringUtils
extends AbstractHelperSingleton {
    protected static final Pattern ANY_SPACES_PATTERN = Pattern.compile("\\s+");
    protected static final Pattern MULTIPLE_SPACES_PATTERN = Pattern.compile("\\s{2,}");
    protected static final Pattern TABULATION_PATTERN = Pattern.compile("\\n|\\r|\\t");
    protected static final Pattern NEWLINE_PATTERN = Pattern.compile(".*[\\t|\\n|\\r]+.*");
    protected static final Pattern CONTAINS_NUMBER_PATTERN = Pattern.compile(".*\\d+.*");
    protected static final Pattern DIGIT_PATTERN = Pattern.compile("\\d");
    protected static final Pattern NON_NUMBERS_PATTERN = Pattern.compile("[^0-9\\s]");
    protected static final Pattern NON_UNICODE_LETTERS_AND_DIGITS_PATTERN = Pattern.compile("[^\\p{L}\\s\\d]");
    protected static final Pattern NON_ASCII_LETTERS_AND_DIGITS_PATTERN = Pattern.compile("[^a-zA-Z\\s\\d]");
    protected static final String EMPTY_REPLACER = "";
    protected static final String SPACE_REPLACER = " ";
    protected static final String TWO_SPACES_REPLACER = "  ";
    public static final boolean SHIFT_NUMBERS_RIGHT = true;
    public static final boolean SHIFT_NUMBERS_LEFT = false;
    public static final boolean WITH_NUMBERS = true;
    public static final boolean WITHOUT_NUMBERS = false;
    public static final boolean PAD_LEFT = true;
    public static final boolean PAD_RIGHT = false;
    private static boolean NATIVE_LEVENSHTEIN_ENABLED = false;

    static {
        Logger logger = StringUtils.getLogger();
        String NATIVE_LEVENSHTEIN = "CLevenshtein";
        try {
            CLevenshtein.lev("foo", "foo".length(), "bar", "bar".length());
            NATIVE_LEVENSHTEIN_ENABLED = true;
            logger.warn("Levenshtein distance native implementation is already loaded");
        }
        catch (UnsatisfiedLinkError ULe) {
            NATIVE_LEVENSHTEIN_ENABLED = false;
            logger.warn("Levenshtein distance native implementation is not yet loaded");
        }
        if (!NATIVE_LEVENSHTEIN_ENABLED) {
            try {
                String libName = System.mapLibraryName(NATIVE_LEVENSHTEIN);
                String libDir = System.getProperty("java.library.path");
                logger.warn("Attempting to load Levenshtein distance native implementation (as {}) from default java library dir ({})", (Object)NATIVE_LEVENSHTEIN, (Object)libDir);
                System.loadLibrary(NATIVE_LEVENSHTEIN);
                NATIVE_LEVENSHTEIN_ENABLED = true;
                logger.warn("Levenshtein distance native implementation is ENABLED (provided by {})", (Object)libName);
            }
            catch (Throwable t) {
                if (t.getMessage() != null && t.getMessage().indexOf("already loaded") >= 0) {
                    logger.warn("Levenshtein distance native implementation is already loaded in another classloader and currently " + (NATIVE_LEVENSHTEIN_ENABLED ? "ENABLED" : "DISABLED"));
                    if (!NATIVE_LEVENSHTEIN_ENABLED) {
                        logger.warn("Enabling Levenshtein distance native implementation...");
                        NATIVE_LEVENSHTEIN_ENABLED = true;
                    }
                }
                logger.warn("Levenshtein distance native implementation is DISABLED (" + t.getClass().getSimpleName() + ": " + t.getMessage() + ")");
            }
        }
    }

    public static final String removeMultipleSpaces(String text) {
        if (StringUtils.isNullOrEmpty(text)) {
            return text;
        }
        String cleaned = text;
        String[] stringArray = TABULATION_PATTERN.pattern().split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tab = stringArray[n2];
            if (text.indexOf(tab) >= 0) {
                cleaned = cleaned.replaceAll(TABULATION_PATTERN.pattern(), SPACE_REPLACER);
                break;
            }
            ++n2;
        }
        if (text.indexOf(TWO_SPACES_REPLACER) >= 0) {
            return cleaned.replaceAll(MULTIPLE_SPACES_PATTERN.pattern(), SPACE_REPLACER).trim();
        }
        return cleaned.trim();
    }

    public static final String removeAllSpaces(String string) {
        if (StringUtils.isNullOrEmpty(string)) {
            return string;
        }
        String cleaned = StringUtils.rawTrim(StringUtils.removeMultipleSpaces(string));
        if (cleaned != null && cleaned.indexOf(SPACE_REPLACER) >= 0) {
            return cleaned.replaceAll(ANY_SPACES_PATTERN.pattern(), EMPTY_REPLACER);
        }
        return cleaned;
    }

    public static final String rawTrim(String toTrim) {
        if (toTrim == null) {
            return null;
        }
        if (StringUtils.isNullOrEmpty(toTrim = toTrim.trim())) {
            return null;
        }
        return toTrim;
    }

    public static final String toRawUppercase(String string) {
        String trimmed = StringUtils.rawTrim(string);
        if (StringUtils.isNullOrEmpty(trimmed)) {
            return null;
        }
        return trimmed.toUpperCase();
    }

    public static final String toRawLowercase(String string) {
        String trimmed = StringUtils.rawTrim(string);
        if (StringUtils.isNullOrEmpty(trimmed)) {
            return null;
        }
        return trimmed.toLowerCase();
    }

    public static final String pad(String what, char padder, int length, boolean left) {
        AssertionUtils.$pos(length, "Padded length must be greater than zero", new Object[0]);
        if (what == null) {
            return null;
        }
        String toPad = what;
        while (toPad.length() < length) {
            toPad = left ? String.valueOf(padder) + toPad : String.valueOf(toPad) + padder;
        }
        return toPad;
    }

    public static final String leftPad(String what, char padder, int length) {
        return StringUtils.pad(what, padder, length, true);
    }

    public static final String rightPad(String what, char padder, int length) {
        return StringUtils.pad(what, padder, length, false);
    }

    public static final String capitalizeFirstLetter(String toCapitalize) {
        if (StringUtils.isNullOrEmpty(toCapitalize)) {
            return toCapitalize;
        }
        return String.valueOf(toCapitalize.substring(0, 1).toUpperCase()) + (toCapitalize.length() > 1 ? toCapitalize.substring(1) : EMPTY_REPLACER);
    }

    public static final boolean isNullOrEmpty(String string) {
        return string == null || EMPTY_REPLACER.equals(string.trim());
    }

    public static final boolean isNotNullAndNonEmpty(String string) {
        return !StringUtils.isNullOrEmpty(string);
    }

    public static final boolean isRTL(String string) {
        if (StringUtils.isNullOrEmpty(string)) {
            return false;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character current = Character.valueOf(cArray[n2]);
            switch (Character.getDirectionality(current.charValue())) {
                case 1: 
                case 2: 
                case 16: 
                case 17: {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static final boolean isLTR(String string) {
        return !StringUtils.isRTL(string);
    }

    public static final String convertFromSpacesToCamelCase(String toConvert) {
        return StringUtils.convertFromCharSeparatedStringToCamelCase(toConvert, ' ');
    }

    public static final String convertFromUnderscoresToCamelCase(String toConvert) {
        return StringUtils.convertFromCharSeparatedStringToCamelCase(toConvert, '_');
    }

    public static final String convertFromCharSeparatedStringToCamelCase(String toConvert, char separator) {
        if (toConvert == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean isSeparator = false;
        boolean capitalizeNext = false;
        char[] cArray = toConvert.toLowerCase().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char current = cArray[n2];
            boolean bl = isSeparator = current == separator;
            if (!isSeparator) {
                result.append(capitalizeNext ? String.valueOf(current).toUpperCase() : String.valueOf(current));
            }
            capitalizeNext = isSeparator;
            ++n2;
        }
        return result.toString();
    }

    public static final String convertFromCamelCaseToSpaced(String toConvert) {
        return StringUtils.convertFromCamelCaseToCharSeparatedString(toConvert, ' ');
    }

    public static final String convertFromCamelCaseToUnderscores(String toConvert) {
        return StringUtils.convertFromCamelCaseToCharSeparatedString(toConvert, '_');
    }

    public static final String convertFromCamelCaseToCharSeparatedString(String toConvert, char separator) {
        CamelCaseToCharSeparatedStateTransition automaton = new CamelCaseToCharSeparatedStateTransition();
        Stack<Character> toReturn = new Stack<Character>();
        boolean isFirst = true;
        boolean currentIsUppercase = false;
        char[] cArray = toConvert.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character current = Character.valueOf(cArray[n2]);
            if (current.equals(Character.valueOf(separator))) {
                automaton.reset();
                isFirst = true;
            } else {
                currentIsUppercase = current.equals(Character.valueOf(Character.toUpperCase(current.charValue())));
                if (!isFirst && currentIsUppercase) {
                    automaton.notify(current);
                    if (!automaton.isInUppercaseSequence()) {
                        toReturn.add(Character.valueOf(separator));
                    }
                } else {
                    if (automaton.isInUppercaseSequence()) {
                        Character previous = (Character)toReturn.pop();
                        toReturn.add(Character.valueOf(separator));
                        toReturn.add(previous);
                    }
                    automaton.notify(current);
                }
                isFirst = false;
            }
            toReturn.add(Character.valueOf(Character.toUpperCase(current.charValue())));
            ++n2;
        }
        Character[] chars = toReturn.toArray(new Character[toReturn.size()]);
        StringBuffer converted = new StringBuffer();
        Character[] characterArray = chars;
        int n3 = chars.length;
        int n4 = 0;
        while (n4 < n3) {
            Character currentChar = characterArray[n4];
            converted.append(currentChar.charValue());
            ++n4;
        }
        return converted.toString();
    }

    public static final String getNameMainPart(String name) {
        if (name == null || EMPTY_REPLACER.equals(name.trim())) {
            return null;
        }
        String mainPart = name;
        int index = -1;
        index = mainPart.indexOf("/");
        if (index >= 0) {
            mainPart = mainPart.substring(0, index);
            mainPart = mainPart.trim();
        }
        if ((index = mainPart.indexOf(",")) >= 0) {
            mainPart = mainPart.substring(0, index);
            mainPart = mainPart.trim();
        }
        if ((index = mainPart.indexOf("=")) >= 0) {
            mainPart = mainPart.substring(0, index);
            mainPart = mainPart.trim();
        }
        return mainPart.replaceAll("\\(.*\\)", EMPTY_REPLACER);
    }

    public static final Collection<String> getAlternateNames(String name) {
        if (name == null || EMPTY_REPLACER.equals(name.trim())) {
            return null;
        }
        ArrayList<String> alternateNames = new ArrayList<String>();
        String mainPart = StringUtils.getNameMainPart(name);
        if (name.equals(mainPart)) {
            return alternateNames;
        }
        return alternateNames;
    }

    public static final Integer[] getNumbersFromString(String string) {
        String numbers = string.replaceAll("[^0-9\\s]", SPACE_REPLACER).replaceAll("\\s{2,}", SPACE_REPLACER);
        ListSet returned = new ListSet();
        String[] stringArray = numbers.split(SPACE_REPLACER);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String number = stringArray[n2];
            if (!number.equals(EMPTY_REPLACER)) {
                returned.add(Integer.valueOf(number));
            }
            ++n2;
        }
        return returned.toArray(new Integer[returned.size()]);
    }

    public static final String shiftNumbers(String string, boolean shiftRight) {
        if (StringUtils.isNullOrEmpty(string) || !CONTAINS_NUMBER_PATTERN.matcher(string).matches()) {
            return string;
        }
        StringBuilder result = new StringBuilder();
        String textOnly = string.replaceAll(DIGIT_PATTERN.pattern(), SPACE_REPLACER);
        if (shiftRight) {
            result.append(textOnly);
            result.append(SPACE_REPLACER);
        }
        Integer[] integerArray = StringUtils.extractNumbers(string);
        int n = integerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer number = integerArray[n2];
            result.append(number).append(SPACE_REPLACER);
            ++n2;
        }
        if (!shiftRight) {
            result.append(textOnly);
            result.append(SPACE_REPLACER);
        }
        return StringUtils.rawTrim(StringUtils.removeMultipleSpaces(result.toString()));
    }

    public static final String shiftNumbersToRight(String string) {
        return StringUtils.shiftNumbers(string, true);
    }

    public static final String shiftNumbersToLeft(String string) {
        return StringUtils.shiftNumbers(string, false);
    }

    public static final Integer[] extractNumbers(String string) {
        if (StringUtils.isNullOrEmpty(string) || !CONTAINS_NUMBER_PATTERN.matcher(string).matches()) {
            return new Integer[0];
        }
        String numbers = string.replaceAll(NON_NUMBERS_PATTERN.pattern(), SPACE_REPLACER).replaceAll(MULTIPLE_SPACES_PATTERN.pattern(), SPACE_REPLACER);
        ListSet returned = new ListSet();
        String[] stringArray = numbers.split(SPACE_REPLACER);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String number = stringArray[n2];
            if (!number.equals(EMPTY_REPLACER)) {
                returned.add(Integer.valueOf(number));
            }
            ++n2;
        }
        return returned.toArray(new Integer[returned.size()]);
    }

    public static final String randomString(int length, boolean includeNumbers) {
        int a = 97;
        int z = 122;
        int delta = z - a;
        double numProb = 10.0 / (double)delta;
        StringBuilder random = new StringBuilder();
        int l = 0;
        while (l < length) {
            if (includeNumbers && Double.compare(Math.random(), numProb) <= 0) {
                random.append(Math.round(Math.random() * 9.0));
            } else {
                random.append(new Character((char)(a + (int)Math.round(Math.random() * (double)delta))));
            }
            ++l;
        }
        return random.toString();
    }

    public static final int computeDistance(String s, String t) {
        return !NATIVE_LEVENSHTEIN_ENABLED ? StringUtils.JLevenshtein(s, t) : (s == null ? (t == null ? 0 : t.length()) : (t == null ? s.length() : CLevenshtein.lev(s, s.length(), t, t.length())));
    }

    public static final int JLevenshtein(String s, String t) {
        int m;
        int n = s == null ? 0 : s.length();
        int n2 = m = t == null ? 0 : t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        int i = 0;
        while (i <= n) {
            d[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= m) {
            d[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= n) {
            char s_i = s.charAt(i - 1);
            j = 1;
            while (j <= m) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = Math.min(Math.min(d[i - 1][j] + 1, d[i][j - 1] + 1), d[i - 1][j - 1] + cost);
                ++j;
            }
            ++i;
        }
        return d[n][m];
    }

    public static final double computeRelativeDistance(String s, String t) {
        if (s == null || t == null) {
            return 1.0;
        }
        double distance = StringUtils.computeDistance(s, t);
        if (distance == 0.0) {
            return 0.0;
        }
        return distance * 1.0 / (double)Math.max(s.length(), t.length());
    }

    public static final double computeRelativeSimilarity(String s, String t) {
        return 1.0 - StringUtils.computeRelativeDistance(s, t);
    }

    public static final List<String> extractPhraseNGrams(int n, String phrase, boolean includeDuplicates) {
        AssertionUtils.$nNull(phrase, "Provided phrase cannot be null", new Object[0]);
        AssertionUtils.$pos(n, "N-gram length must be greater than zero", new Object[0]);
        ArrayList<String> ngrams = includeDuplicates ? new ArrayList<String>() : new ListSet();
        String[] stringArray = phrase.split("\\s");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String word = stringArray[n3];
            if ((word = StringUtils.rawTrim(word)) != null) {
                ngrams.addAll(StringUtils.extractWordNGrams(n, word));
            }
            ++n3;
        }
        return ngrams;
    }

    public static final List<String> extractWordNGrams(int n, String word) {
        AssertionUtils.$nNull(word, "Provided word cannot be null", new Object[0]);
        AssertionUtils.$true(word.indexOf(32) <= 0, "Provided word ({}) contains at least one space", word);
        AssertionUtils.$pos(n, "N-gram length must be greater than zero", new Object[0]);
        StringBuilder eWord = new StringBuilder(SPACE_REPLACER);
        eWord.append(word).append(SPACE_REPLACER);
        ArrayList<String> ngrams = new ArrayList<String>();
        if (n > word.length()) {
            ngrams.add(word);
            return ngrams;
        }
        char[] chars = eWord.toString().toCharArray();
        int i = 0;
        while (i < chars.length - n + 1) {
            String ngram = StringUtils.rawTrim(StringUtils.nGramsExtraction(chars, i, i + n));
            if (ngram != null) {
                ngrams.add(ngram);
            }
            ++i;
        }
        return ngrams;
    }

    static final String nGramsExtraction(char[] characters, int start, int end) {
        StringBuilder sb = new StringBuilder();
        int i = start;
        while (i < end) {
            sb.append(characters[i]);
            ++i;
        }
        return sb.toString();
    }

    public static final double nGramsSimilarity(String first, String second, int n) {
        first = StringUtils.rawTrim(first);
        second = StringUtils.rawTrim(second);
        if (first == null && second == null) {
            return 0.0;
        }
        if (first == null || second == null) {
            return 1.0;
        }
        return StringUtils.calculateNGramsSimilarityScore(StringUtils.extractWordNGrams(n, first), StringUtils.extractWordNGrams(n, second));
    }

    public static final double nGramsDistance(String first, String second, int n) {
        return 1.0 - StringUtils.nGramsSimilarity(first, second, n);
    }

    public static final double nGramsPhraseDistance(String first, String second, int n) {
        return 1.0 - StringUtils.nGramsPhraseSimilarity(first, second, n);
    }

    public static final double nGramsPhraseSimilarity(String first, String second, int n) {
        first = StringUtils.rawTrim(first);
        second = StringUtils.rawTrim(second);
        if (first == null && second == null) {
            return 0.0;
        }
        if (first == null || second == null) {
            return 1.0;
        }
        return StringUtils.calculateNGramsSimilarityScore(StringUtils.extractPhraseNGrams(n, first, true), StringUtils.extractPhraseNGrams(n, second, true));
    }

    public static final double calculateNGramsSimilarityScore(List<String> firstNGrams, List<String> secondNGrams) {
        ArrayList<String> common;
        int b;
        int a = firstNGrams.size();
        if (a > (b = secondNGrams.size())) {
            common = new ArrayList<String>(secondNGrams);
            common.retainAll(firstNGrams);
        } else {
            common = new ArrayList<String>(firstNGrams);
            common.retainAll(secondNGrams);
        }
        int m = common.size();
        return 2.0 * (double)m / (double)(a + b);
    }

    private static class CamelCaseToCharSeparatedStateTransition {
        private int _uppercaseSequenceLength = 0;

        private CamelCaseToCharSeparatedStateTransition() {
        }

        public void notify(Character character) {
            this._uppercaseSequenceLength = character.equals(Character.valueOf(Character.toUpperCase(character.charValue()))) ? ++this._uppercaseSequenceLength : 0;
        }

        public boolean isInUppercaseSequence() {
            return this._uppercaseSequenceLength > 1;
        }

        public void reset() {
            this._uppercaseSequenceLength = 0;
        }
    }
}

