/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.process.validator;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import org.fao.fi.comet.domain.species.tools.io.readers.CSVFileReader;

public class ResultsValidator {
    public static final void main(String[] args) throws Throwable {
        String[][] inputs;
        HashMap<String, String[]> expected = new HashMap<String, String[]>();
        CSVFileReader inReader = new CSVFileReader();
        String[][] stringArray = inputs = inReader.readRawData(new File("./test/inputData/real5.csv"), ',', '\"', true);
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            String[] input = stringArray[n2];
            String name = input[2].trim();
            String author = input[3].trim();
            String id = String.valueOf(name) + ("".equals(author) ? "" : " " + author);
            expected.put(id, input);
            ++n2;
        }
        CSVFileReader resReader = new CSVFileReader();
        String[][] results = resReader.readRawData(new File("./test/outputData/bionymoutlevreal5csvpreprcsv.csv"), '|', '\"', false);
        int skipped = 0;
        int skippedUnique = 0;
        int matching = 0;
        int matchingAsFirstResult = 0;
        int matchingSciName = 0;
        int matchingSciNameAsFirstResult = 0;
        int sameId = 0;
        int matchingSameId = 0;
        int matchingDifferentId = 0;
        int notMatchingScoreMax = 0;
        int notMatchingScoreHigh = 0;
        HashSet<String> uniqueResults = new HashSet<String>();
        HashSet<String> notFound = new HashSet<String>();
        String previous = null;
        String[][] stringArray2 = results;
        int n3 = results.length;
        int n4 = 0;
        while (n4 < n3) {
            String[] result = stringArray2[n4];
            String[] expectedData = (String[])expected.get(result[0]);
            uniqueResults.add(result[0]);
            if (expectedData == null) {
                notFound.add(result[0]);
                if (!result[0].equalsIgnoreCase(previous)) {
                    ++skippedUnique;
                }
                previous = result[0];
                ++skipped;
            } else {
                String eId = "WoRMS:" + expectedData[1];
                String fId = result[5].trim();
                String eScientificName = expectedData[4].trim();
                String eAuthority = expectedData[5].trim();
                String fScientificName = result[1].trim();
                String fAuthority = result[2].trim();
                if (eId.equals(fId)) {
                    ++sameId;
                }
                if (eScientificName.equalsIgnoreCase(fScientificName)) {
                    ++matchingSciName;
                    if (!result[0].equalsIgnoreCase(previous)) {
                        ++matchingSciNameAsFirstResult;
                    }
                    if (eAuthority == null || eAuthority.equals("") || eAuthority.equalsIgnoreCase(fAuthority)) {
                        ++matching;
                        if (!result[0].equalsIgnoreCase(previous)) {
                            ++matchingAsFirstResult;
                        }
                        if (eId.equals(fId)) {
                            ++matchingSameId;
                        } else {
                            ++matchingDifferentId;
                        }
                    }
                } else {
                    double score = Double.parseDouble(result[3]);
                    if (Double.compare(score, 1.0) == 0) {
                        ++notMatchingScoreMax;
                    } else if (Double.compare(score, 0.9) >= 0) {
                        ++notMatchingScoreHigh;
                    }
                    System.out.println("Expected: " + eId + " - " + eScientificName + ", " + eAuthority + " (as: " + expectedData[2] + ", " + expectedData[3] + ") <> Found: " + fId + " - " + fScientificName + ", " + fAuthority + " [ Score: " + result[3] + " ]");
                }
            }
            ++n4;
        }
        for (String nf : notFound) {
            System.out.println("!!! Cannot find " + nf + " in input data");
        }
        System.out.println("#### Results: " + results.length);
        System.out.println("#### Skipped results: " + skipped);
        System.out.println("#### Unique results: " + uniqueResults.size());
        System.out.println("#### Skipped unique results: " + skippedUnique);
        System.out.println("#### Matching (sci names and authority): " + matching);
        System.out.println("#### Matching (sci names and authority) as first result: " + matchingAsFirstResult);
        System.out.println("#### Matching (sci names only): " + matchingSciName);
        System.out.println("#### Matching (sci names only) as first result: " + matchingSciNameAsFirstResult);
        System.out.println("#### Matching (same ID): " + matchingSameId);
        System.out.println("#### Matching (different ID): " + matchingDifferentId);
        System.out.println("#### Same ID: " + sameId);
        System.out.println("#### Not matching (with high score): " + notMatchingScoreHigh);
        System.out.println("#### Not matching (with score max.): " + notMatchingScoreMax);
    }
}

