/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.model.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.engine.Matching;
import org.fao.fi.comet.core.model.engine.adapters.MatchingsMapAdapter;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;

@XmlType(name="MatchingDetails")
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class MatchingDetails<SOURCE, TARGET>
implements Serializable {
    private static final long serialVersionUID = -3645628461543595729L;
    @XmlTransient
    private DataIdentifier _sourceIdentifier;
    @XmlElement(name="Source")
    private SOURCE _source;
    @XmlJavaTypeAdapter(value=MatchingsMapAdapter.class)
    @XmlElement(name="Matchings")
    protected Map<String, Matching<SOURCE, TARGET>> _matchingsMap;

    public MatchingDetails() {
        this(1000, 0.1f);
    }

    public MatchingDetails(int initialCapacity, float loadFactor) {
        AssertionUtils.$pos(initialCapacity, "Initial capacity must be greater than zero (currently: {})", initialCapacity);
        AssertionUtils.$pos(Float.valueOf(loadFactor), "Load factor must be greater than zero (currently: {})", Float.valueOf(loadFactor));
        this._matchingsMap = Collections.synchronizedMap(new HashMap());
    }

    public MatchingDetails(Map<String, Matching<SOURCE, TARGET>> backingMap) {
        AssertionUtils.$nNull(backingMap, "Backing map cannot be null", new Object[0]);
        this._matchingsMap = Collections.synchronizedMap(backingMap);
    }

    @XmlTransient
    public Collection<Matching<SOURCE, TARGET>> getMatchings() {
        return this._matchingsMap.values();
    }

    @XmlTransient
    public Collection<Matching<SOURCE, TARGET>> getSortedUniqueMatchings() {
        HashSet<Matching<SOURCE, TARGET>> asList = new HashSet<Matching<SOURCE, TARGET>>();
        if (this._matchingsMap.values() != null) {
            asList.addAll(this._matchingsMap.values());
        }
        ArrayList<Matching<SOURCE, TARGET>> sorted = new ArrayList<Matching<SOURCE, TARGET>>(asList);
        Collections.sort(sorted, new Comparator<Matching<SOURCE, TARGET>>(){

            @Override
            public int compare(Matching<SOURCE, TARGET> first, Matching<SOURCE, TARGET> second) {
                return second.getScore().compareTo(first.getScore());
            }
        });
        return sorted;
    }

    public MatchingDetails<SOURCE, TARGET> retain(int maxNumCandidates, Comparator<Matching<SOURCE, TARGET>> comparator) {
        ArrayList<Matching<SOURCE, TARGET>> entries = new ArrayList<Matching<SOURCE, TARGET>>(this.getMatchings());
        if (entries.size() > maxNumCandidates) {
            if (comparator != null) {
                Collections.sort(entries, comparator);
            }
            this._matchingsMap.clear();
            int r = 0;
            while (r < maxNumCandidates) {
                Matching entry = (Matching)entries.get(r);
                this._matchingsMap.put(entry.getTargetIdentifier().toUID(), entry);
                ++r;
            }
        }
        return this;
    }

    @XmlAttribute(name="totalCandidates")
    public int getTotalCandidates() {
        return this._matchingsMap.size();
    }

    public void setTotalCandidates(int totalCandidates) {
    }

    @XmlAttribute(name="sourceId")
    public String getSourceId() {
        return this._sourceIdentifier.getId();
    }

    public void setSourceId(String sourceId) {
        if (this._sourceIdentifier == null) {
            this._sourceIdentifier = new DataIdentifier();
        }
        this._sourceIdentifier.setId(sourceId);
    }

    @XmlAttribute(name="sourceProviderId")
    public String getSourceProviderId() {
        return this._sourceIdentifier.getProviderId();
    }

    public void setSourceProviderId(String sourceProviderId) {
        if (this._sourceIdentifier == null) {
            this._sourceIdentifier = new DataIdentifier();
        }
        this._sourceIdentifier.setProviderId(sourceProviderId);
    }

    public DataIdentifier getSourceIdentifier() {
        return this._sourceIdentifier;
    }

    public void setSourceIdentifier(DataIdentifier sourceIdentifier) {
        this._sourceIdentifier = sourceIdentifier;
    }

    public Object getSource() {
        return this._source;
    }

    public void setSource(SOURCE source) {
        this._source = source;
    }

    public Matching<SOURCE, TARGET> findMatchingByTargetId(DataIdentifier targetIdentifier) {
        return this._matchingsMap.get(targetIdentifier.toUID());
    }

    public Matching<SOURCE, TARGET> removeMatchingByTargetId(DataIdentifier targetIdentifier) {
        return this._matchingsMap.remove(targetIdentifier.toUID());
    }

    public MatchingDetails<SOURCE, TARGET> join(MatchingDetails<SOURCE, TARGET> another) {
        AssertionUtils.$nNull(another, "Provided matching details cannot be null", new Object[0]);
        AssertionUtils.$nNull(another._matchingsMap, "Provided matching details cannot have a null backing data map", new Object[0]);
        for (String key : another._matchingsMap.keySet()) {
            Matching<SOURCE, TARGET> matching = another._matchingsMap.get(key);
            if (this._matchingsMap.containsKey(key)) {
                this._matchingsMap.get(key).join(matching);
                continue;
            }
            this._matchingsMap.put(key, ObjectsUtils.rawClone(matching));
        }
        return this;
    }
}

