/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.topology.algorithms.cycles.detection.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Named;
import org.fao.vrmf.core.extensions.collections.SerializableList;
import org.fao.vrmf.core.extensions.collections.impl.SerializableArrayList;
import org.fao.vrmf.core.extensions.exceptions.WrappedRuntimeException;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;
import org.fao.vrmf.core.tools.topology.GraphNode;
import org.fao.vrmf.core.tools.topology.StronglyConnectedEntries;
import org.fao.vrmf.core.tools.topology.WeightedGraph;
import org.fao.vrmf.core.tools.topology.WeightedGraphLink;
import org.fao.vrmf.core.tools.topology.algorithms.cycles.detection.impl.AbstractCycleDetector;

@Named(value="vrmf.default.cycle.detector")
public class Tarjan<INDEX extends Serializable>
extends AbstractCycleDetector<INDEX> {
    private static final long serialVersionUID = -7269573496829688025L;
    private int _index = 0;
    private List<GraphNode<INDEX>> _stack = new ArrayList<GraphNode<INDEX>>();
    private StronglyConnectedEntries<INDEX> _SCC = new StronglyConnectedEntries();

    @Override
    public StronglyConnectedEntries<INDEX> resolve(GraphNode<INDEX> v, WeightedGraph<INDEX> list) {
        v.setIndex(this._index);
        v.setLowLink(this._index);
        ++this._index;
        this._stack.add(0, v);
        SerializableList<WeightedGraphLink<INDEX>> adjacents = list.getAdjacents(v);
        if (adjacents != null) {
            for (WeightedGraphLink weightedGraphLink : adjacents) {
                GraphNode n = weightedGraphLink.getTarget();
                if (n.getIndex() == -1) {
                    this.resolve(n, list);
                    v.setLowLink(Math.min(v.getLowLink(), n.getLowLink()));
                    continue;
                }
                if (!this._stack.contains(n)) continue;
                v.setLowLink(Math.min(v.getLowLink(), n.getIndex()));
            }
        }
        if (v.getLowLink() == v.getIndex()) {
            GraphNode<INDEX> graphNode;
            SerializableArrayList component = new SerializableArrayList();
            do {
                graphNode = this._stack.remove(0);
                component.add(graphNode);
            } while (!graphNode.equals(v));
            this._SCC.addData(component);
        }
        return this._SCC;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasCycles(WeightedGraph<INDEX> graph) {
        assert (graph != null);
        try {
            GraphNode entry;
            WeightedGraph<INDEX> clonedGraph = ObjectsUtils.rawClone(graph);
            ArrayList<GraphNode<INDEX>> entries = new ArrayList<GraphNode<INDEX>>(clonedGraph.getSourceNodeSet());
            Iterator iterator = entries.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                entry = (GraphNode)iterator.next();
                clonedGraph.reset();
            } while (!new Tarjan<INDEX>().resolve(entry, clonedGraph).hasCycles());
            return true;
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException("Unable to detect cycles", t);
        }
    }
}

