/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.model.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.engine.Matching;
import org.fao.fi.comet.core.model.engine.MatchingDetails;
import org.fao.fi.comet.core.model.engine.MatchingResult;
import org.fao.fi.comet.core.model.engine.adapters.MatchingDetailsMapAdapter;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.core.model.support.MatchingType;
import org.fao.vrmf.core.extensions.collections.SerializableList;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;
import org.fao.vrmf.core.tools.topology.GraphNode;
import org.fao.vrmf.core.tools.topology.WeightedGraph;
import org.fao.vrmf.core.tools.topology.WeightedGraphLink;
import org.fao.vrmf.core.tools.topology.behaviours.WeightValue;

@XmlType(name="MatchingsData")
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class MatchingsData<SOURCE, TARGET>
implements Serializable {
    private static final long serialVersionUID = -7588216518182815655L;
    @XmlJavaTypeAdapter(value=MatchingDetailsMapAdapter.class)
    @XmlElement(name="MatchingsData")
    private Map<String, MatchingDetails<SOURCE, TARGET>> _matchingDetailsMap;
    @XmlTransient
    public final Comparator<Matching<SOURCE, TARGET>> MATCHINGS_COMPARATOR = new Comparator<Matching<SOURCE, TARGET>>(){

        @Override
        public int compare(Matching<SOURCE, TARGET> w1, Matching<SOURCE, TARGET> w2) {
            double lambda1 = w1.getScore().getValue();
            double lambda2 = w2.getScore().getValue();
            return Double.compare(lambda2, lambda1);
        }
    };

    public MatchingsData() {
        this(100, 0.1f);
    }

    public MatchingsData(int initialCapacity, float loadFactor) {
        AssertionUtils.$pos(initialCapacity, "Initial capacity must be greater than zero (currently: {})", initialCapacity);
        AssertionUtils.$pos(Float.valueOf(loadFactor), "Load factor must be greater than zero (currently: {})", Float.valueOf(loadFactor));
        this._matchingDetailsMap = Collections.synchronizedMap(new HashMap(initialCapacity, loadFactor));
    }

    public MatchingsData(Map<String, MatchingDetails<SOURCE, TARGET>> backingMap) {
        AssertionUtils.$nNull(backingMap, "Backing map cannot be null", new Object[0]);
        this._matchingDetailsMap = Collections.synchronizedMap(backingMap);
    }

    @XmlTransient
    public Collection<MatchingDetails<SOURCE, TARGET>> getMatchingDetails() {
        return this._matchingDetailsMap == null ? new ArrayList<MatchingDetails<SOURCE, TARGET>>() : new ArrayList<MatchingDetails<SOURCE, TARGET>>(this._matchingDetailsMap.values());
    }

    @XmlAttribute(name="numIdentifiedEntries")
    public int getNumIdentifiedEntries() {
        return this._matchingDetailsMap.size();
    }

    public void setNumIdentifiedEntries(int numIdentifiedEntries) {
    }

    public MatchingsData<SOURCE, TARGET> join(MatchingsData<SOURCE, TARGET> another) {
        AssertionUtils.$nNull(another, "Provided matching data cannot be null", new Object[0]);
        AssertionUtils.$nNull(another._matchingDetailsMap, "Provided matching data cannot have a null backing data map", new Object[0]);
        for (String matchingsDataKey : another._matchingDetailsMap.keySet()) {
            MatchingDetails<SOURCE, TARGET> details = another._matchingDetailsMap.get(matchingsDataKey);
            if (details._matchingsMap.isEmpty()) continue;
            if (this._matchingDetailsMap.containsKey(matchingsDataKey)) {
                this._matchingDetailsMap.get(matchingsDataKey).join(details);
                continue;
            }
            this._matchingDetailsMap.put(matchingsDataKey, ObjectsUtils.rawClone(details));
        }
        return this;
    }

    public MatchingsData<SOURCE, TARGET> cleanup(int maxCandidatesPerEntry) {
        return this.cleanup(maxCandidatesPerEntry, Double.MIN_VALUE);
    }

    public MatchingsData<SOURCE, TARGET> cleanup(double weightedScoreThreshold) {
        return this.cleanup(Integer.MIN_VALUE, weightedScoreThreshold);
    }

    public MatchingsData<SOURCE, TARGET> cleanup(int maxCandidatesPerEntry, double weightedScoreThreshold) {
        boolean filterScore;
        boolean filterNumCandidates = maxCandidatesPerEntry > 0;
        boolean bl = filterScore = Double.compare(weightedScoreThreshold, 0.0) > 0;
        if (!filterNumCandidates && !filterScore) {
            return this;
        }
        for (MatchingDetails<SOURCE, TARGET> details : this.getMatchingDetails()) {
            if (details == null || details.getSortedUniqueMatchings() == null) continue;
            ArrayList<Matching<SOURCE, TARGET>> entries = new ArrayList<Matching<SOURCE, TARGET>>(details.getMatchings());
            Collections.sort(entries, this.MATCHINGS_COMPARATOR);
            if (filterScore) {
                for (Matching matching : entries) {
                    if (Double.compare(weightedScoreThreshold, matching.getScoreValue()) <= 0) continue;
                    details.removeMatchingByTargetId(matching.getTargetIdentifier());
                }
            }
            entries = new ArrayList<Matching<SOURCE, TARGET>>(details.getMatchings());
            Collections.sort(entries, this.MATCHINGS_COMPARATOR);
            if (filterNumCandidates) {
                while (entries.size() > maxCandidatesPerEntry) {
                    details.removeMatchingByTargetId(((Matching)entries.get(entries.size() - 1)).getTargetIdentifier());
                    entries.remove(entries.size() - 1);
                }
            }
            if (details == null || details.getMatchings() != null && !details.getMatchings().isEmpty()) continue;
            this.removeMatchingDetailsBySourceIdentifier(details.getSourceIdentifier());
        }
        return this;
    }

    public MatchingsData<SOURCE, TARGET> filter(double minScore, int maxCandidates) {
        AssertionUtils.$gte(minScore, 0.0, "The joined matchings data minimum score must be greater than (or equal to) {} (currently: {})", 0.0, minScore);
        AssertionUtils.$lte(minScore, 1.0, "The joined matchings data minimum score must be lower than (or equal to) {} (currently: {})", 1.0, minScore);
        AssertionUtils.$true(maxCandidates >= 0, "The joined matchings data maximum candidates per entry must be greater than (or equal to) 0 (currently: {})", maxCandidates);
        Set<String> keySet = this._matchingDetailsMap.keySet();
        boolean limitCandidates = maxCandidates > 0;
        for (String matchingsDataKey : keySet) {
            MatchingDetails<SOURCE, TARGET> details = this._matchingDetailsMap.get(matchingsDataKey);
            ArrayList<Matching<SOURCE, TARGET>> updated = new ArrayList<Matching<SOURCE, TARGET>>();
            for (Matching<SOURCE, TARGET> matching : details.getSortedUniqueMatchings()) {
                if (limitCandidates && updated.size() == maxCandidates) break;
                if (Double.compare(matching.getScore().getValue(), minScore) < 0) continue;
                updated.add(matching);
            }
            details._matchingsMap.clear();
            for (Matching<SOURCE, TARGET> matching : updated) {
                details._matchingsMap.put(matching.getTargetId(), matching);
            }
            this._matchingDetailsMap.put(matchingsDataKey, details);
        }
        return this;
    }

    public MatchingDetails<SOURCE, TARGET> findMatchingDetailsBySourceIdentifier(DataIdentifier sourceIdentifier) {
        return this._matchingDetailsMap.get(sourceIdentifier.toUID());
    }

    public MatchingDetails<SOURCE, TARGET> removeMatchingDetailsBySourceIdentifier(DataIdentifier sourceIdentifier) {
        return this._matchingDetailsMap.remove(sourceIdentifier.toUID());
    }

    public MatchingDetails<SOURCE, TARGET> lazyGetMatchingDetails(SOURCE source, DataIdentifier sourceIdentifier) {
        MatchingDetails<SOURCE, TARGET> matchingDetails = this.findMatchingDetailsBySourceIdentifier(sourceIdentifier);
        if (matchingDetails == null) {
            matchingDetails = new MatchingDetails();
            matchingDetails.setSource(source);
            matchingDetails.setSourceIdentifier(sourceIdentifier);
            this._matchingDetailsMap.put(sourceIdentifier.toUID(), matchingDetails);
        }
        return matchingDetails;
    }

    public Matching<SOURCE, TARGET> getMatching(DataIdentifier sourceIdentifier, DataIdentifier targetIdentifier) {
        return this.findMatchingDetailsBySourceIdentifier(sourceIdentifier).findMatchingByTargetId(targetIdentifier);
    }

    public Matching<SOURCE, TARGET> lazyGetMatching(SOURCE source, DataIdentifier sourceIdentifier, TARGET target, DataIdentifier targetIdentifier) {
        MatchingDetails<SOURCE, TARGET> matchingDetails = this.lazyGetMatchingDetails(source, sourceIdentifier);
        String targetUID = targetIdentifier.toUID();
        Matching matching = matchingDetails._matchingsMap.get(targetUID);
        if (matching == null) {
            matching = new Matching();
            matching.setSourceIdentifier(sourceIdentifier);
            matching.setTargetIdentifier(targetIdentifier);
            matching.setTarget(target);
            matching.setScore(new MatchingScore(0.0, MatchingType.NON_PERFORMED));
            matchingDetails._matchingsMap.put(targetUID, matching);
        }
        return matching;
    }

    public Matching<SOURCE, TARGET> lazyUpdateMatching(SOURCE source, DataIdentifier sourceIdentifier, TARGET target, DataIdentifier targetIdentifier, MatchingResult<?, ?> currentMatchingResult) {
        Matching<SOURCE, TARGET> matching = this.lazyGetMatching(source, sourceIdentifier, target, targetIdentifier);
        matching.updateMatchingResult(currentMatchingResult);
        return matching;
    }

    public synchronized double meanScore() {
        double score = 0.0;
        int entries = 0;
        double scorePerMatching = 0.0;
        int entriesPerMatching = 0;
        HashSet<Map.Entry<String, MatchingDetails<SOURCE, TARGET>>> mainEntries = new HashSet<Map.Entry<String, MatchingDetails<SOURCE, TARGET>>>(this._matchingDetailsMap.entrySet());
        HashSet matchingEntries = null;
        for (Map.Entry entry : mainEntries) {
            matchingEntries = new HashSet(((MatchingDetails)entry.getValue())._matchingsMap.entrySet());
            for (Map.Entry entry2 : matchingEntries) {
                ++entriesPerMatching;
                scorePerMatching += ((Matching)entry2.getValue()).getScore().getValue();
            }
            if (entriesPerMatching != 0 && Double.compare(scorePerMatching, 0.0) > 0) {
                score += scorePerMatching / (double)entriesPerMatching;
                ++entries;
            }
            scorePerMatching = 0.0;
            entriesPerMatching = 0;
        }
        if (entries == 0) {
            return 0.0;
        }
        return score / (double)entries;
    }

    private boolean toLeaf(WeightedGraph<Serializable> graph, WeightedGraphLink<Serializable> link) {
        SerializableList<WeightedGraphLink<Serializable>> targets = graph.getAdjacents(link.getTarget());
        return targets == null || targets.isEmpty();
    }

    protected WeightedGraphLink<Serializable> computeBestLink(WeightedGraph<Serializable> graph, GraphNode<Serializable> source) {
        SerializableList<WeightedGraphLink<Serializable>> targets = graph.getAdjacents(source);
        WeightValue maximumWeight = null;
        WeightedGraphLink<Serializable> bestLink = null;
        WeightValue currentWeight = null;
        WeightedGraphLink<Serializable> currentLink = null;
        for (WeightedGraphLink<Serializable> currentTarget : targets) {
            currentLink = this.toLeaf(graph, currentTarget) ? currentTarget : this.computeBestLink(graph, currentTarget.getTarget());
            currentWeight = currentLink.getWeight();
            if (maximumWeight != null && maximumWeight.compareTo(currentWeight) > 0) continue;
            maximumWeight = currentWeight;
            bestLink = new WeightedGraphLink<Serializable>(source, currentLink.getTarget(), maximumWeight);
        }
        return bestLink;
    }
}

