/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.matchlets.extended;

import org.fao.fi.comet.core.model.common.TypedComplexName;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.core.model.support.MatchingType;
import org.fao.fi.comet.core.uniform.matchlets.skeleton.UScalarMatchletSkeleton;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;

public class FINGSAyMatchlet
extends UScalarMatchletSkeleton<ReferenceSpeciesData, ReferenceSpeciesData> {
    private static final long serialVersionUID = 5534829313877324698L;
    public static final String NAME = "GSAyMatchlet";

    public FINGSAyMatchlet() {
        this._name = NAME;
    }

    @Override
    public MatchingScore computeScore(ReferenceSpeciesData source, DataIdentifier sourceIdentifier, ReferenceSpeciesData sourceData, ReferenceSpeciesData target, DataIdentifier targetIdentifier, ReferenceSpeciesData targetData) {
        boolean hasYear;
        MatchingScore result = new MatchingScore(0.0, MatchingType.NON_AUTHORITATIVE);
        double scoreValue = 0.0;
        String sourceGenusName = sourceData.getGenus();
        String sourceSpeciesName = sourceData.getSpecies();
        String sourceAuthor = sourceData.getAuthor();
        String sourceAuthority = sourceData.getAuthority();
        String sourceYear = sourceData.getAuthorityYear() == null ? null : sourceData.getAuthorityYear().toString();
        String targetGenusName = targetData.getGenus();
        String targetSpeciesName = targetData.getSpecies();
        String targetAuthor = targetData.getAuthor();
        String targetAuthority = targetData.getAuthority();
        String targetYear = targetData.getAuthorityYear() == null ? null : targetData.getAuthorityYear().toString();
        TypedComplexName sourceNormalizedSpeciesCName = sourceData.getNormalizedSpeciesCName();
        TypedComplexName targetNormalizedSpeciesCName = targetData.getNormalizedSpeciesCName();
        boolean sameGenusName = sourceGenusName != null && !sourceGenusName.isEmpty() && targetGenusName != null && !targetGenusName.isEmpty() && sourceGenusName.equalsIgnoreCase(targetGenusName);
        boolean sameSpeciesName = sourceSpeciesName != null && !sourceSpeciesName.isEmpty() && targetSpeciesName != null && !targetSpeciesName.isEmpty() && sourceSpeciesName.equalsIgnoreCase(targetSpeciesName);
        boolean sameAuthor = sourceAuthor != null && !sourceAuthor.isEmpty() && targetAuthor != null && !targetAuthor.isEmpty() && sourceAuthor.equalsIgnoreCase(targetAuthor);
        boolean sameNormalizedSpeciesCName = sourceNormalizedSpeciesCName != null && !sourceNormalizedSpeciesCName.isEmpty() && sourceNormalizedSpeciesCName.equals(targetNormalizedSpeciesCName);
        boolean hasAuthor = sourceAuthority != null && targetAuthority != null && (sourceAuthority.contains(targetAuthority) || targetAuthority.contains(sourceAuthority));
        boolean bl = hasYear = sourceYear != null && targetYear != null && (sourceYear.contains(targetYear) || targetYear.contains(sourceYear));
        if (sameGenusName) {
            if (sameSpeciesName) {
                scoreValue = sameAuthor ? 100.0 : (hasAuthor && hasYear ? 97.0 : (hasAuthor ? 88.0 : (hasYear ? 82.0 : 76.0)));
            } else if (sameNormalizedSpeciesCName) {
                scoreValue = sameAuthor ? 94.0 : (hasAuthor && hasYear ? 91.0 : (hasAuthor ? 85.0 : (hasYear ? 79.0 : 73.0)));
            } else if (sameAuthor) {
                scoreValue = 35.0;
            } else if (hasAuthor && hasYear) {
                scoreValue = 32.0;
            }
        } else if (sameSpeciesName) {
            if (sameAuthor) {
                scoreValue = 70.0;
            } else if (hasAuthor && hasYear) {
                scoreValue = 64.0;
            }
        } else if (sameNormalizedSpeciesCName) {
            if (sameAuthor) {
                scoreValue = 67.0;
            } else if (hasAuthor && hasYear) {
                scoreValue = 61.0;
            }
        }
        result.setValue(scoreValue /= 100.0);
        return result;
    }

    @Override
    public String getDescription() {
        return "Performs GSAy matching between two reference species data";
    }

    @Override
    protected ReferenceSpeciesData doExtractData(ReferenceSpeciesData entity, DataIdentifier entityIdentifier) {
        return entity;
    }

    public static enum Steplist {
        GSAy,
        GSAY,
        GSrAy,
        GSrAY,
        GSA,
        GSrA,
        GSY,
        GSrY,
        GS,
        GSr,
        SAy,
        SrAy,
        SAY,
        SrAY,
        GAy,
        GAY;

    }
}

