/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.parsers.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.fao.fi.comet.domain.species.ReferenceSpeciesFactory;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.tools.parsers.impl.SpeciesNameParserSkeleton;
import org.fao.vrmf.core.extensions.collections.impl.ListSet;
import org.fao.vrmf.core.helpers.singletons.io.net.URLUtils;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.CollectionsUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Singleton
public abstract class AbstractGNISpeciesNameParser
extends SpeciesNameParserSkeleton {
    protected final DocumentBuilderFactory _builderFactory;
    protected final DocumentBuilder _documentBuilder;
    protected final XPathFactory _xPathFactory;
    protected static final String GNI_ENDPOINT_URL = "http://gni.globalnames.org/parsers.xml?names={query}";
    protected static final String VERBATIM_VARIABLE_NAME = "verbatimName";
    protected static final String SCI_NAME_XPATH = "//scientific_name[node/node[node_key/. = 'verbatim: ']/node_value/text()=$verbatimName]";
    protected static final String PARSED_XPATH = "//node[node_key/. = 'parsed: ']/node_value/text()";
    protected static final String VERBATIM_XPATH = "//node[node_key/. = 'verbatim: ']/node_value/text()";
    protected static final String AUTHOR_XPATH = "//node[node_key/. = 'author']/node_value";
    protected static final String YEAR_XPATH = "//node[node_key/. = 'year: ']/node_value";
    private final XPathExpression PARSED_XPATH_EXPR;
    private final XPathExpression VERBATIM_XPATH_EXPR;
    private final XPathExpression AUTHOR_XPATH_EXPR;
    private final XPathExpression YEAR_XPATH_EXPR;
    private final Pattern YEAR_EXTRACTOR_PATTERN = Pattern.compile(".*(\\d{4}).*");
    private final int _chunkSize;
    private static final int DEFAULT_CHUNK_SIZE = 100;

    public AbstractGNISpeciesNameParser() throws Throwable {
        this(100);
    }

    public AbstractGNISpeciesNameParser(int chunkSize) throws Throwable {
        AssertionUtils.$pos(chunkSize, "Chunk size must be greater than zero", new Object[0]);
        this._builderFactory = DocumentBuilderFactory.newInstance();
        this._builderFactory.setNamespaceAware(false);
        this._documentBuilder = this._builderFactory.newDocumentBuilder();
        this._xPathFactory = XPathFactory.newInstance();
        this.PARSED_XPATH_EXPR = this._xPathFactory.newXPath().compile(PARSED_XPATH);
        this.VERBATIM_XPATH_EXPR = this._xPathFactory.newXPath().compile(VERBATIM_XPATH);
        this.AUTHOR_XPATH_EXPR = this._xPathFactory.newXPath().compile(AUTHOR_XPATH);
        this.YEAR_XPATH_EXPR = this._xPathFactory.newXPath().compile(YEAR_XPATH);
        this._chunkSize = chunkSize;
    }

    @Override
    public ReferenceSpeciesData[] parse(String[] names) {
        ArrayList<ReferenceSpeciesData> parsed = new ArrayList<ReferenceSpeciesData>();
        int n = 0;
        while (n < names.length) {
            parsed.addAll(Arrays.asList(this.parseChunk(Arrays.copyOfRange(names, n, Math.min(n + this._chunkSize, names.length)))));
            n += this._chunkSize;
        }
        return parsed.toArray(new ReferenceSpeciesData[parsed.size()]);
    }

    protected ReferenceSpeciesData[] parseChunk(String[] names) {
        ArrayList<ReferenceSpeciesData> parsedData = new ArrayList<ReferenceSpeciesData>();
        ArrayList<String> encodedNames = new ArrayList<String>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name != null) {
                encodedNames.add(URLUtils.encode(name).replace("&", "%26"));
            }
            ++n2;
        }
        String encoded = CollectionsUtils.join(encodedNames, "|");
        this._log.debug("Attempting to parse names: {} (encoded as: {})", (Object)CollectionsUtils.join(names, ", "), (Object)encoded);
        String URL2 = GNI_ENDPOINT_URL.replace("{query}", encoded);
        if (URL2.length() > 2048) {
            this._log.warn("Actual URL length is {} bytes: this may cause problems if the remote server has a max URL length set to 2048 bytes or less. Reduce the number of entries per chunk (currently: {} entries) to fix the problem", (Object)URL2.length(), (Object)names.length);
        }
        this._log.debug("Invoking GNI via {}", (Object)URL2);
        try {
            long start = System.currentTimeMillis();
            Document overall = this._documentBuilder.parse(URL2);
            long end = System.currentTimeMillis();
            this._log.info("Remote parsing of {} entries took {} mSec.", (Object)names.length, (Object)(end - start));
            String[] stringArray2 = names;
            int n3 = names.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray2[n4];
                if (name == null) {
                    parsedData.add(null);
                } else {
                    XPath identifier = this._xPathFactory.newXPath();
                    identifier.setXPathVariableResolver(new XPathVerbatimNameVariableResolver(name));
                    Node entry = (Node)identifier.compile(SCI_NAME_XPATH).evaluate(overall, XPathConstants.NODE);
                    if (entry == null) {
                        this._log.warn("Unable to identify response in returned XML for raw input name '{}'", (Object)name);
                        parsedData.add(ReferenceSpeciesFactory.newInstance(name));
                    } else {
                        Document root = this._documentBuilder.newDocument();
                        root.appendChild(root.importNode(entry, true));
                        Boolean parsed = this.getParsed(root);
                        String verbatim = this.getVerbatim(root);
                        this._log.debug("Name {} {} been parsed", (Object)name, (Object)(parsed != false ? "has" : "has not"));
                        this._log.debug("'Verbatim' response for {} was: {}", (Object)name, (Object)verbatim);
                        if (!name.equals(verbatim)) {
                            this._log.warn("A difference was detected between the queried name ({}) and the parsed verbatim name ({}). This might be a hint of encoding problems...", (Object)name, (Object)verbatim);
                        }
                        if (!parsed.booleanValue()) {
                            parsedData.add(ReferenceSpeciesFactory.newInstance(name));
                        } else {
                            ReferenceSpeciesData data = this.doParse(root);
                            if (data != null) {
                                String authority = this.getAuthor(root);
                                String authorityYear = this.getAuthorYear(root);
                                if (authority != null) {
                                    data.setAuthor(String.valueOf(authority) + (authorityYear != null ? ", " + authorityYear : ""));
                                }
                            }
                            parsedData.add(data);
                        }
                    }
                }
                ++n4;
            }
            return parsedData.toArray(new ReferenceSpeciesData[parsedData.size()]);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to query / parse response from GNI API @ " + URL2 + ". Original message: " + t.getMessage());
        }
    }

    protected abstract ReferenceSpeciesData doParse(Document var1) throws XPathExpressionException;

    protected final String getAuthor(Document entry) throws XPathExpressionException {
        ListSet authors = new ListSet();
        NodeList authorNodes = (NodeList)this.AUTHOR_XPATH_EXPR.evaluate(entry, XPathConstants.NODESET);
        if (authorNodes != null) {
            int n = 0;
            while (n < authorNodes.getLength()) {
                String author = StringUtils.rawTrim(authorNodes.item(n).getTextContent());
                if (author != null) {
                    authors.add(author);
                }
                ++n;
            }
        }
        return authors.isEmpty() ? null : CollectionsUtils.join(authors, ", ");
    }

    protected final String getAuthorYear(Document entry) throws XPathExpressionException {
        ListSet years = new ListSet();
        NodeList yearNodes = (NodeList)this.YEAR_XPATH_EXPR.evaluate(entry, XPathConstants.NODESET);
        if (yearNodes != null) {
            int n = 0;
            while (n < yearNodes.getLength()) {
                block5: {
                    String year = StringUtils.rawTrim(yearNodes.item(n).getTextContent());
                    if (year != null) {
                        try {
                            years.add(Integer.parseInt(year));
                        }
                        catch (NumberFormatException NFe) {
                            Matcher yearMatcher = this.YEAR_EXTRACTOR_PATTERN.matcher(year);
                            if (!yearMatcher.matches()) break block5;
                            years.add(Integer.parseInt(yearMatcher.group(1)));
                        }
                    }
                }
                ++n;
            }
            Collections.sort(years);
        }
        return years.isEmpty() ? null : ((Integer)years.get(0)).toString();
    }

    protected final Boolean getParsed(Document entry) throws XPathExpressionException {
        return Boolean.valueOf(StringUtils.rawTrim(this.PARSED_XPATH_EXPR.evaluate(entry)));
    }

    protected final String getVerbatim(Document entry) throws XPathExpressionException {
        return StringUtils.rawTrim(this.VERBATIM_XPATH_EXPR.evaluate(entry));
    }

    private class XPathVerbatimNameVariableResolver
    implements XPathVariableResolver {
        private final String _value;

        public XPathVerbatimNameVariableResolver(String value) {
            this._value = value;
        }

        @Override
        public Object resolveVariable(QName varName) {
            String key = varName.getLocalPart();
            return AbstractGNISpeciesNameParser.VERBATIM_VARIABLE_NAME.equals(key) ? this._value : null;
        }
    }
}

