/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.extras.matchlets.common.behaviours;

import java.io.Serializable;
import org.fao.fi.comet.core.matchlets.skeleton.behaviours.BasicBehaviour;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.extras.matchlets.helpers.ValueDistanceHelper;
import org.fao.vrmf.core.behaviours.data.Valued;

public class ValueDistanceAwareBehaviour<SOURCE extends Serializable, SOURCE_DATA extends Valued<? extends Number>, TARGET extends Serializable, TARGET_DATA extends Valued<? extends Number>>
extends BasicBehaviour<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> {
    private static final long serialVersionUID = -8218136145191518357L;
    private final ValueDistanceHelper<Valued<? extends Number>> _valueHelper = new ValueDistanceHelper();
    private double _maximumRelativeValueDistance = 0.0;

    public ValueDistanceAwareBehaviour(double maximumRelativeValueDistance) {
        assert (Double.compare(maximumRelativeValueDistance, 0.0) >= 0) : "The maximum relative value distance cannot be lower than zero (currently: " + maximumRelativeValueDistance + ")";
        assert (Double.compare(maximumRelativeValueDistance, 0.0) <= 1) : "The maximum relative value distance cannot be higher than one (currently: " + maximumRelativeValueDistance + ")";
        this._maximumRelativeValueDistance = maximumRelativeValueDistance;
    }

    @Override
    protected MatchingScore doUpdateScore(MatchingScore current, SOURCE_DATA sourceData, TARGET_DATA targetData) {
        MatchingScore updated = new MatchingScore(current);
        Double relativeValueDistance = this._valueHelper.getRelativeValueDistance((Valued<? extends Number>)sourceData, (Valued<? extends Number>)targetData);
        if (relativeValueDistance == null || Double.compare(relativeValueDistance, this._maximumRelativeValueDistance) > 0) {
            updated = MatchingScore.getNonAuthoritativeNoMatchTemplate();
        } else {
            updated.setValue(updated.getValue() * (1.0 - relativeValueDistance));
        }
        return updated;
    }
}

