/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.extensions.collections.nu.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.fao.vrmf.core.behaviours.design.patterns.predicate.Action;
import org.fao.vrmf.core.behaviours.design.patterns.predicate.Predicate;
import org.fao.vrmf.core.extensions.collections.nu.NuSet;
import org.fao.vrmf.core.impl.design.patterns.predicate.AlwaysTruePredicate;

public class NuTreeSet<ENTRY>
extends TreeSet<ENTRY>
implements NuSet<ENTRY> {
    private static final long serialVersionUID = 836982161123383893L;

    public NuTreeSet() {
    }

    public NuTreeSet(ENTRY[] items) {
        this((Collection<ENTRY>)Arrays.asList(items));
    }

    public NuTreeSet(Collection<ENTRY> items) {
        this();
        this.addAll(items);
    }

    @Override
    public final NuSet<ENTRY> select(Predicate<ENTRY> predicate) {
        assert (predicate != null) : "Predicate cannot be NULL";
        NuTreeSet<ENTRY> selected = new NuTreeSet<ENTRY>();
        for (Object current : this) {
            if (!predicate.is(current)) continue;
            selected.add(current);
        }
        return selected;
    }

    @Override
    public NuSet<ENTRY> selectOthers(Predicate<ENTRY> predicate) {
        assert (predicate != null) : "Predicate cannot be NULL";
        NuTreeSet<ENTRY> selected = new NuTreeSet<ENTRY>();
        for (Object current : this) {
            if (!predicate.isNot(current)) continue;
            selected.add(current);
        }
        return selected;
    }

    @Override
    public final void forEachDo(Action<ENTRY> action) {
        assert (action != null) : "Action cannot be NULL";
        this.forEachSelectedDo(new AlwaysTruePredicate(), action);
    }

    @Override
    public final void forEachSelectedDo(Predicate<ENTRY> predicate, Action<ENTRY> action) {
        assert (predicate != null) : "Predicate cannot be NULL";
        assert (action != null) : "Action cannot be NULL";
        for (Object current : this) {
            if (!predicate.is(current)) continue;
            action.perform(current);
        }
    }

    @Override
    public void forEachOtherDo(Predicate<ENTRY> predicate, Action<ENTRY> action) {
        assert (predicate != null) : "Predicate cannot be NULL";
        assert (action != null) : "Action cannot be NULL";
        for (Object current : this) {
            if (!predicate.isNot(current)) continue;
            action.perform(current);
        }
    }

    @Override
    public NuTreeSet<ENTRY> intersect(final NuSet<ENTRY> other) {
        final NuTreeSet<ENTRY> intersection = new NuTreeSet<ENTRY>();
        this.forEachDo(new Action<ENTRY>(){

            @Override
            public void perform(ENTRY subject) {
                if (other.contains(subject)) {
                    intersection.add(subject);
                }
            }
        });
        return intersection;
    }

    @Override
    public NuTreeSet<ENTRY> reverseIntersect(final NuSet<ENTRY> other) {
        final NuTreeSet<ENTRY> intersection = new NuTreeSet<ENTRY>();
        this.forEachDo(new Action<ENTRY>(){

            @Override
            public void perform(ENTRY subject) {
                if (!other.contains(subject)) {
                    intersection.add(subject);
                }
            }
        });
        return intersection;
    }
}

