/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.impl.design.patterns.factory;

import java.util.Properties;
import org.fao.vrmf.core.behaviours.cache.CacheFactory;
import org.fao.vrmf.core.behaviours.design.patterns.factory.Factory;
import org.fao.vrmf.core.behaviours.design.patterns.factory.FactoryProvidedListenerObject;
import org.fao.vrmf.core.behaviours.design.patterns.factory.FactoryProvidedObject;
import org.fao.vrmf.core.behaviours.design.patterns.factory.annotations.PrototypeMarker;
import org.fao.vrmf.core.behaviours.design.patterns.factory.exceptions.FactoryException;
import org.fao.vrmf.core.helpers.singletons.lang.classes.ClassUtils;
import org.fao.vrmf.core.impl.design.patterns.cache.simple.SimpleCacheFacade;
import org.fao.vrmf.core.impl.logging.ImmutableLoggingClient;

public abstract class AbstractFactory<O extends FactoryProvidedObject>
extends ImmutableLoggingClient
implements Factory<O> {
    private CacheFactory<SimpleCacheFacade<String, O>> _cacheFactory;

    public CacheFactory<SimpleCacheFacade<String, O>> getCacheFactory() {
        return this._cacheFactory;
    }

    public void setCacheFactory(CacheFactory<SimpleCacheFacade<String, O>> cacheFactory) {
        this._cacheFactory = cacheFactory;
    }

    @Override
    public final <P extends O> P create(Class<P> prototype, Properties parameters) throws FactoryException {
        assert (prototype != null) : "Prototype cannot be NULL";
        FactoryProvidedObject concrete = null;
        if (prototype.isAnnotationPresent(PrototypeMarker.class)) {
            this._log.info("Interface '" + prototype.getSimpleName() + " was marked to be a prototype, hence it gets created each time it is requested to a factory...");
            concrete = this.doCreate(prototype, parameters);
            this.notifyCreation(concrete);
        } else {
            String singletonKey = this.getKeyForPrototype(prototype);
            concrete = (FactoryProvidedObject)this._cacheFactory.createCache(this.getClass().getSimpleName(), parameters).get(singletonKey);
            if (concrete == null) {
                concrete = this.doCreate(prototype, parameters);
                this.notifyCreation(concrete);
                this._cacheFactory.createCache(this.getClass().getSimpleName(), parameters).put(singletonKey, concrete);
            }
        }
        return (P)concrete;
    }

    @Override
    public final <PROTOTYPE extends O> PROTOTYPE create(Class<PROTOTYPE> prototype) throws FactoryException {
        return (PROTOTYPE)this.create(prototype, new Properties());
    }

    protected <P extends O> P doCreate(Class<P> prototype, Properties parameters) throws FactoryException {
        assert (prototype != null) : "Prototype cannot be NULL";
        try {
            return (P)((FactoryProvidedObject)prototype.newInstance());
        }
        catch (Throwable t) {
            throw new FactoryException("Unable to create concrete instance for prototype " + ClassUtils.getThis(prototype), t);
        }
    }

    private <P extends O> void notifyCreation(P created) {
        if (created instanceof FactoryProvidedListenerObject) {
            ((FactoryProvidedListenerObject)created).notifyCreation(this);
        } else {
            this._log.warn("Unable to notify creation by factory " + ClassUtils.getThis(this) + " for " + ClassUtils.getThis(created) + ": object doesn't have a 'notifyCreation' method");
        }
    }

    protected <P extends O> String getKeyForPrototype(Class<P> prototype) {
        assert (prototype != null) : "Prototype cannot be NULL";
        return prototype.getSimpleName();
    }
}

