/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.topology;

import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.fao.vrmf.core.behaviours.deserialization.DataIdentifierDeserializer;
import org.fao.vrmf.core.extensions.collections.SerializableList;
import org.fao.vrmf.core.extensions.collections.impl.SerializableArrayList;
import org.fao.vrmf.core.extensions.exceptions.WrappedRuntimeException;
import org.fao.vrmf.core.extensions.maps.SerializableMap;
import org.fao.vrmf.core.extensions.maps.impl.SerializableHashMap;
import org.fao.vrmf.core.helpers.singletons.lang.classes.ClassUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;
import org.fao.vrmf.core.helpers.singletons.text.xml.JAXBUtils;
import org.fao.vrmf.core.helpers.singletons.text.xml.XMLBuilderUtils;
import org.fao.vrmf.core.tools.topology.GraphNode;
import org.fao.vrmf.core.tools.topology.StronglyConnectedEntries;
import org.fao.vrmf.core.tools.topology.WeightedGraphLink;
import org.fao.vrmf.core.tools.topology.algorithms.cycles.detection.CyclesDetector;
import org.fao.vrmf.core.tools.topology.algorithms.cycles.detection.impl.Tarjan;
import org.fao.vrmf.core.tools.topology.behaviours.WeightValue;
import org.fao.vrmf.core.tools.topology.impl.SimpleWeightValue;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@XmlRootElement(name="graph")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WeightedGraph<I extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 8625812943599559174L;
    private SerializableMap<GraphNode<I>, SerializableList<WeightedGraphLink<I>>> _adjacencies = new SerializableHashMap<GraphNode<I>, SerializableList<WeightedGraphLink<I>>>();
    public static final String GRAPH_TAG = "graph";
    public static final String NODE_TAG = "node";
    public static final String ID_ATTRIBUTE = "id";
    public static final String LINKS_TAG = "links";
    public static final String LINK_TAG = "link";
    public static final String WEIGHT_ATTRIBUTE = "weight";
    public static final boolean DEREFERENCED_GRAPH = true;
    public static final boolean NORMAL_GRAPH = false;

    public void link(GraphNode<I> source, GraphNode<I> target, WeightValue weight) {
        SerializableList list;
        if (!this._adjacencies.containsKey(source)) {
            list = new SerializableArrayList();
            this._adjacencies.put(source, list);
        } else {
            list = (SerializableList)this._adjacencies.get(source);
        }
        list.add(new WeightedGraphLink<I>(source, target, weight));
    }

    public void linkIfNotYetLinked(GraphNode<I> source, GraphNode<I> target, WeightValue weight) {
        SerializableList list;
        if (!this._adjacencies.containsKey(source)) {
            list = new SerializableArrayList();
            this._adjacencies.put(source, list);
        } else {
            list = (SerializableList)this._adjacencies.get(source);
        }
        boolean add = list.isEmpty();
        for (WeightedGraphLink link : list) {
            if (!(add &= !link.getTarget().getID().equals(target.getID()))) break;
        }
        if (add) {
            list.add(new WeightedGraphLink<I>(source, target, weight));
        }
    }

    public void unlink(GraphNode<I> source, GraphNode<I> target) {
        List links = (List)this._adjacencies.get(source);
        if (links != null && !links.isEmpty()) {
            Iterator linksIterator = links.iterator();
            while (linksIterator.hasNext()) {
                WeightedGraphLink currentLink = (WeightedGraphLink)linksIterator.next();
                if (!currentLink.getSource().equals(source) || !currentLink.getTarget().equals(target)) continue;
                linksIterator.remove();
            }
        }
        if (links.isEmpty()) {
            this._adjacencies.remove(source);
        }
    }

    public void unlinkAll(GraphNode<I> source) {
        List links = (List)this._adjacencies.get(source);
        if (links != null && !links.isEmpty()) {
            links.clear();
        }
        this._adjacencies.remove(source);
    }

    public void unlink(WeightedGraphLink<I> link) {
        this.unlink(link.getSource(), link.getTarget());
    }

    public boolean isLeaf(GraphNode<I> node) {
        List links = (List)this._adjacencies.get(node);
        return links == null || links.isEmpty();
    }

    public SerializableList<WeightedGraphLink<I>> getAdjacents(GraphNode<I> source) {
        return (SerializableList)this._adjacencies.get(source);
    }

    public void updateAdjacents(GraphNode<I> source, SerializableList<WeightedGraphLink<I>> adjacencies) {
        this._adjacencies.put(source, adjacencies);
    }

    public void reverseEdge(WeightedGraphLink<I> e) {
        ((SerializableList)this._adjacencies.get(e.getSource())).remove(e);
        this.link(e.getTarget(), e.getSource(), e.getWeight());
    }

    public void reverseGraph() {
        this._adjacencies = this.getReversedGraph()._adjacencies;
    }

    public WeightedGraph<I> getReversedGraph() {
        WeightedGraph newGraph = new WeightedGraph();
        for (List edges : this._adjacencies.values()) {
            for (WeightedGraphLink e : edges) {
                newGraph.link(e.getTarget(), e.getSource(), e.getWeight());
            }
        }
        return newGraph;
    }

    public Set<GraphNode<I>> getSourceNodeSet() {
        return this._adjacencies.keySet();
    }

    public Set<GraphNode<I>> getSourceRootNodeSet() {
        HashSet<GraphNode<I>> roots = new HashSet<GraphNode<I>>();
        WeightedGraph<I> reversed = this.getReversedGraph();
        for (GraphNode node : this._adjacencies.keySet()) {
            if (!reversed.isLeaf(node)) continue;
            roots.add(node);
        }
        return roots;
    }

    public GraphNode<I> getNodeByIndex(I index) {
        for (GraphNode<I> node : this.getSourceNodeSet()) {
            if (!node.getID().equals(index)) continue;
            return node;
        }
        return null;
    }

    public WeightedGraphLink<I> getLinkByIndexes(I sourceIndex, I targetIndex) {
        assert (sourceIndex != null) : "Source index cannot be null";
        for (WeightedGraphLink<I> link : this.getAllEdges()) {
            boolean hasTarget;
            if (!sourceIndex.equals(link.getSource().getID())) continue;
            boolean bl = hasTarget = link.getTarget() != null;
            if (!(targetIndex == null ? !hasTarget : hasTarget && targetIndex.equals(link.getTarget().getID()))) continue;
            return link;
        }
        return null;
    }

    public Collection<WeightedGraphLink<I>> getAllEdges() {
        ArrayList<WeightedGraphLink<I>> edges = new ArrayList<WeightedGraphLink<I>>();
        for (List e : this._adjacencies.values()) {
            edges.addAll(e);
        }
        return edges;
    }

    public void reset() {
        for (GraphNode<I> e : this.getSourceNodeSet()) {
            e.reset();
        }
    }

    public boolean hasCycles(CyclesDetector<I> detector) {
        assert (detector != null);
        return detector.hasCycles(this);
    }

    public SerializableList<? super SerializableList<? super SerializableList<I>>> getCycles(CyclesDetector<I> detector) {
        SerializableArrayList cycles = new SerializableArrayList();
        try {
            ArrayList<GraphNode<I>> entries = new ArrayList<GraphNode<I>>(this.getSourceNodeSet());
            for (GraphNode graphNode : entries) {
                this.reset();
                CyclesDetector<I> current = ObjectsUtils.rawClone(detector);
                StronglyConnectedEntries<I> ct = current.resolve(graphNode, this);
                if (!ct.hasCycles()) continue;
                cycles.add(ct.getCycles());
            }
            return cycles;
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException("Unable to detect cycles", t);
        }
    }

    public SerializableList<? super SerializableList<? super SerializableList<I>>> getCycles(CyclesDetector<I> detector, GraphNode<I> sourceNode) {
        SerializableArrayList cycles = new SerializableArrayList();
        try {
            this.reset();
            StronglyConnectedEntries<I> ct = ObjectsUtils.rawClone(detector).resolve(sourceNode, this);
            if (ct.hasCycles()) {
                cycles.add(ct.getCycles());
            }
            return cycles;
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException("Unable to detect cycles", t);
        }
    }

    public WeightedGraph<I> reduce() {
        return this.reduceNode(null);
    }

    public WeightedGraph<I> reduce(Double maximumWeight) {
        for (GraphNode<I> node : this.getSourceNodeSet()) {
            if (this.isLeaf(node)) continue;
            this.reduceNode(node, maximumWeight);
        }
        return this;
    }

    public WeightedGraph<I> reduceNode(GraphNode<I> node) {
        return this.reduceNode(node, null);
    }

    public WeightedGraph<I> reduceNode(GraphNode<I> node, Double maximumWeight) {
        if (this.isLeaf(node)) {
            return this;
        }
        WeightedGraphLink<I> best = this.computeBestLink(null, node, maximumWeight);
        this.getAdjacents(node).clear();
        this.link(best.getSource(), best.getTarget(), best.getWeight());
        return this;
    }

    private boolean toLeaf(WeightedGraphLink<I> link) {
        SerializableList<WeightedGraphLink<I>> targets = this.getAdjacents(link.getTarget());
        return targets == null || targets.isEmpty();
    }

    private WeightedGraphLink<I> computeBestLink(WeightValue weight, GraphNode<I> source, Double maximumWeight) {
        SerializableList<WeightedGraphLink<I>> targets = this.getAdjacents(source);
        WeightValue maximumCurrentWeight = null;
        WeightedGraphLink<I> bestLink = null;
        WeightValue currentWeight = null;
        WeightedGraphLink currentLink = null;
        for (WeightedGraphLink currentTarget : targets) {
            currentLink = this.toLeaf(currentTarget) ? currentTarget : this.computeBestLink(currentTarget.getWeight(), currentTarget.getTarget(), maximumWeight);
            WeightValue weightValue = currentWeight = weight == null ? currentLink.getWeight() : weight.multiply(currentLink.getWeight());
            if (maximumCurrentWeight == null || currentWeight.compareTo(maximumCurrentWeight) >= 0) {
                maximumCurrentWeight = currentWeight;
                bestLink = new WeightedGraphLink<I>(source, currentLink.getTarget(), maximumCurrentWeight);
            }
            if (maximumWeight != null && Double.compare(maximumCurrentWeight.toDouble(), maximumWeight) == 0) break;
        }
        return bestLink;
    }

    public void toXMLStream(OutputStreamWriter stream, boolean deep, CyclesDetector<I> detector) throws Exception {
        if (this.hasCycles(detector)) {
            throw new RuntimeException("Cannot convert this adjacency list to XML: cycles detected");
        }
        ArrayList<GraphNode<I>> rootNodes = new ArrayList<GraphNode<I>>(this.getSourceNodeSet());
        stream.append(XMLBuilderUtils.open(this.getClass())).append("\n");
        for (GraphNode graphNode : rootNodes) {
            this.toXMLStream(stream, graphNode, true, deep);
            stream.append("\n");
        }
        stream.append(XMLBuilderUtils.close(this.getClass())).append("\n");
        stream.flush();
    }

    public WeightedGraph<I> fromDOM(Document DOM, DataIdentifierDeserializer<I> dataIdentifierDeserializer) {
        this._adjacencies.clear();
        Node graphNode = XMLBuilderUtils.getFirstChildByName(DOM, GRAPH_TAG);
        Collection<Node> entryNode = XMLBuilderUtils.filterChildrenByName(graphNode, NODE_TAG);
        for (Node current : entryNode) {
            this.processNode(current, dataIdentifierDeserializer);
        }
        return this;
    }

    private void processNode(Node sourceNode, DataIdentifierDeserializer<I> dataIdentifierDeserializer) {
        boolean hasLinks;
        String sourceNodeID = sourceNode.getAttributes().getNamedItem(ID_ATTRIBUTE).getNodeValue();
        boolean bl = hasLinks = XMLBuilderUtils.getFirstChildByName(sourceNode, LINKS_TAG) != null;
        if (hasLinks) {
            for (Node currentLink : XMLBuilderUtils.filterChildrenByName(XMLBuilderUtils.getFirstChildByName(sourceNode, LINKS_TAG), LINK_TAG)) {
                String weight = currentLink.getAttributes().getNamedItem(WEIGHT_ATTRIBUTE).getNodeValue();
                Node targetNode = XMLBuilderUtils.getFirstChildByName(currentLink, NODE_TAG);
                String targetNodeID = targetNode.getAttributes().getNamedItem(ID_ATTRIBUTE).getNodeValue();
                this.link(new GraphNode<I>(dataIdentifierDeserializer.fromString(sourceNodeID)), new GraphNode<I>(dataIdentifierDeserializer.fromString(targetNodeID)), new SimpleWeightValue(Double.parseDouble(weight)));
                this.processNode(targetNode, dataIdentifierDeserializer);
            }
        }
    }

    private void toXMLStream(OutputStreamWriter stream, GraphNode<I> node, boolean isRoot, boolean deep) throws Exception {
        SerializableList<WeightedGraphLink<I>> links = this.getAdjacents(node);
        boolean hasLinks = links != null && !links.isEmpty();
        stream.append("<node id=\"").append(node.getID().toString()).append("\">").append(hasLinks ? "\n" : "");
        if (hasLinks && (isRoot || deep)) {
            stream.append("<links>\n");
            for (WeightedGraphLink weightedGraphLink : links) {
                stream.append("<link>\n").append(JAXBUtils.toXML(weightedGraphLink.getWeight(), JAXBUtils.OMIT_XML_DECLARATION));
                this.toXMLStream(stream, weightedGraphLink.getTarget(), false, deep);
                stream.append("</link>\n");
            }
            stream.append("</links>\n");
        }
        stream.append("</node>\n");
    }

    public String toXML(boolean style, CyclesDetector<I> detector) throws Exception {
        if (this.hasCycles(detector)) {
            throw new RuntimeException("Cannot convert this graph to its XML representation: cycles detected");
        }
        StringBuffer toReturn = new StringBuffer(1024);
        ArrayList<GraphNode<I>> rootNodes = new ArrayList<GraphNode<I>>(this.getSourceNodeSet());
        toReturn.append(XMLBuilderUtils.open(GRAPH_TAG)).append("\n");
        for (GraphNode graphNode : rootNodes) {
            toReturn.append(this.toXML(graphNode, true, style)).append("\n");
        }
        toReturn.append(XMLBuilderUtils.close(GRAPH_TAG)).append("\n");
        try {
            return XMLBuilderUtils.prettyPrint(toReturn.toString());
        }
        catch (Throwable throwable) {
            return toReturn.toString();
        }
    }

    private String toXML(GraphNode<I> node, boolean isRoot, boolean style) throws Exception {
        StringBuffer toReturn = new StringBuffer(1024);
        SerializableList<WeightedGraphLink<I>> links = this.getAdjacents(node);
        boolean hasLinks = links != null && !links.isEmpty();
        toReturn.append("<").append(NODE_TAG).append(" ").append(ID_ATTRIBUTE).append("=\"").append(node.getID()).append("\">").append(hasLinks ? "\n" : "");
        if (hasLinks && (isRoot || style)) {
            toReturn.append(XMLBuilderUtils.open(LINKS_TAG)).append("\n");
            for (WeightedGraphLink weightedGraphLink : links) {
                toReturn.append("<").append(LINK_TAG).append(" ").append(WEIGHT_ATTRIBUTE).append("=\"").append(weightedGraphLink.getWeight() == null ? "" : Double.valueOf(weightedGraphLink.getWeight().toDouble())).append("\"").append(">\n").append(weightedGraphLink.getWeight() == null ? "" : JAXBUtils.toXML(weightedGraphLink.getWeight(), JAXBUtils.OMIT_XML_DECLARATION)).append(this.toXML(weightedGraphLink.getTarget(), false, style)).append(XMLBuilderUtils.close(LINK_TAG)).append("\n");
            }
            toReturn.append(XMLBuilderUtils.close(LINKS_TAG)).append("\n");
        }
        toReturn.append("</").append(NODE_TAG).append(">\n");
        return toReturn.toString();
    }

    public String toString() {
        try {
            return this.toXML(true, new Tarjan());
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to stringify " + ClassUtils.getThis(this) + ": " + t.getClass().getSimpleName() + " [ " + t.getMessage() + " ]", t);
        }
    }
}

