/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.engine.process.handlers.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import org.fao.fi.comet.core.engine.process.handlers.impl.SilentMatchingProcessHandler;
import org.fao.fi.comet.core.patterns.data.providers.ProvidedData;
import org.fao.vrmf.core.extensions.exceptions.WrappedRuntimeException;

public class SimpleGUIMatchingProcessHandler<SOURCE extends Serializable>
extends SilentMatchingProcessHandler<SOURCE>
implements ActionListener {
    private JFrame _gui;
    private JLabel _sourceDataLabel;
    private JLabel _maxProcessedSourceDataLabel;
    private JLabel _atomicComparisonsInRoundLabel;
    private JLabel _maxAtomicComparisonsInRoundLabel;
    private JLabel _matchletsLabel;
    private JLabel _maxMatchletsLabel;
    private JProgressBar _sourceDataProgressbar;
    private JProgressBar _atomicComparisonsInRoundProgressbar;
    private JProgressBar _matchletsProgressbar;
    private JLabel _authoritativeFullMatch;
    private JLabel _authoritativeNoMatch;
    private JLabel _matches;
    private JLabel _reducedMatches;
    private JButton _stop;
    private JButton _dump;
    private JPanel _processedDataPanel;
    private JPanel _comparisonsPanel;
    private JPanel _matchletsPanel;
    private boolean _GUIAlreadySetUp = false;
    private boolean _isInitialized = false;

    private void createGUI(String id) {
        try {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException("Unable to create GUI", t);
        }
        this._sourceDataLabel = new JLabel("Source data to process");
        this._maxProcessedSourceDataLabel = new JLabel("0");
        this._atomicComparisonsInRoundLabel = new JLabel("Current comparisons");
        this._maxAtomicComparisonsInRoundLabel = new JLabel("0");
        this._matchletsLabel = new JLabel("Matchlets to process");
        this._maxMatchletsLabel = new JLabel("0");
        this._sourceDataProgressbar = new JProgressBar();
        this._atomicComparisonsInRoundProgressbar = new JProgressBar();
        this._matchletsProgressbar = new JProgressBar();
        this._authoritativeFullMatch = new JLabel("0");
        this._authoritativeNoMatch = new JLabel("0");
        this._matches = new JLabel("0");
        this._reducedMatches = new JLabel("0");
        this._stop = new JButton("Halt");
        this._dump = new JButton("Dump Results");
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this._gui = new JFrame(id);
        this._gui.setDefaultCloseOperation(3);
        this._gui.setSize(new Dimension(640, 90));
        this._gui.setResizable(false);
        this._gui.setLocation((int)(((double)screen.width - this._gui.getSize().getWidth()) / 2.0), (int)(((double)screen.height - this._gui.getSize().getHeight()) / 2.0));
        this._maxProcessedSourceDataLabel.setSize(new Dimension(64, 16));
        this._maxProcessedSourceDataLabel.setPreferredSize(this._maxProcessedSourceDataLabel.getSize());
        this._sourceDataLabel.setSize(new Dimension(128, 16));
        this._sourceDataLabel.setPreferredSize(this._sourceDataLabel.getSize());
        this._maxAtomicComparisonsInRoundLabel.setSize(new Dimension(64, 16));
        this._maxAtomicComparisonsInRoundLabel.setPreferredSize(this._maxAtomicComparisonsInRoundLabel.getSize());
        this._atomicComparisonsInRoundLabel.setSize(new Dimension(128, 16));
        this._atomicComparisonsInRoundLabel.setPreferredSize(this._atomicComparisonsInRoundLabel.getSize());
        this._maxMatchletsLabel.setSize(new Dimension(64, 16));
        this._maxMatchletsLabel.setPreferredSize(this._maxMatchletsLabel.getSize());
        this._matchletsLabel.setSize(new Dimension(128, 16));
        this._matchletsLabel.setPreferredSize(this._matchletsLabel.getSize());
        this._sourceDataProgressbar.setMinimum(0);
        this._sourceDataProgressbar.setSize(600, 30);
        this._sourceDataProgressbar.setStringPainted(true);
        this._atomicComparisonsInRoundProgressbar.setMinimum(0);
        this._atomicComparisonsInRoundProgressbar.setSize(600, 30);
        this._atomicComparisonsInRoundProgressbar.setStringPainted(true);
        this._matchletsProgressbar.setMinimum(0);
        this._matchletsProgressbar.setSize(600, 30);
        this._matchletsProgressbar.setStringPainted(true);
        this._stop.setSize(200, 30);
        this._stop.setPreferredSize(this._stop.getSize());
        this._stop.setMinimumSize(this._stop.getSize());
        this._stop.setMaximumSize(this._stop.getSize());
        this._dump.setSize(200, 30);
        this._dump.setPreferredSize(this._dump.getSize());
        this._dump.setMinimumSize(this._dump.getSize());
        this._dump.setMaximumSize(this._dump.getSize());
        JPanel mainPanel = new JPanel(new GridLayout(5, 1));
        this._processedDataPanel = new JPanel(new BorderLayout());
        this._processedDataPanel.setMinimumSize(new Dimension(600, 32));
        this._comparisonsPanel = new JPanel(new BorderLayout());
        this._comparisonsPanel.setMinimumSize(new Dimension(600, 32));
        this._matchletsPanel = new JPanel(new BorderLayout());
        this._matchletsPanel.setMinimumSize(new Dimension(600, 32));
        JPanel infoPanel = new JPanel(new GridBagLayout());
        infoPanel.setMinimumSize(new Dimension(600, 32));
        infoPanel.setPreferredSize(infoPanel.getMinimumSize());
        JPanel commandPanel = new JPanel(new GridLayout(1, 3));
        commandPanel.add(new JLabel(" "));
        commandPanel.setSize(new Dimension(200, 32));
        commandPanel.setMinimumSize(commandPanel.getSize());
        commandPanel.setPreferredSize(commandPanel.getSize());
        commandPanel.setMaximumSize(commandPanel.getSize());
        commandPanel.add(new JLabel(" "));
        commandPanel.add(this._stop);
        commandPanel.add(this._dump);
        this._stop.addActionListener(this);
        this._dump.addActionListener(this);
        mainPanel.add(this._processedDataPanel);
        mainPanel.add(this._comparisonsPanel);
        mainPanel.add(this._matchletsPanel);
        mainPanel.add(infoPanel);
        mainPanel.add(commandPanel);
        this._processedDataPanel.add((Component)this._sourceDataLabel, "West");
        this._processedDataPanel.add((Component)this._sourceDataProgressbar, "Center");
        this._processedDataPanel.add((Component)this._maxProcessedSourceDataLabel, "East");
        this._comparisonsPanel.add((Component)this._atomicComparisonsInRoundLabel, "West");
        this._comparisonsPanel.add((Component)this._atomicComparisonsInRoundProgressbar, "Center");
        this._comparisonsPanel.add((Component)this._maxAtomicComparisonsInRoundLabel, "East");
        this._matchletsPanel.add((Component)this._matchletsLabel, "West");
        this._matchletsPanel.add((Component)this._matchletsProgressbar, "Center");
        this._matchletsPanel.add((Component)this._maxMatchletsLabel, "East");
        JLabel authNoMatches = new JLabel("AUTH. NO MATCH:");
        JLabel authFullMatches = new JLabel("AUTH. FULL MATCH:");
        JLabel matches = new JLabel("MATCHES:");
        JLabel reducedMatches = new JLabel("/");
        authNoMatches.setSize(new Dimension(160, 16));
        authNoMatches.setPreferredSize(authNoMatches.getSize());
        authNoMatches.setMinimumSize(authNoMatches.getSize());
        authFullMatches.setSize(new Dimension(160, 16));
        authFullMatches.setPreferredSize(authFullMatches.getSize());
        authFullMatches.setMinimumSize(authFullMatches.getSize());
        reducedMatches.setSize(new Dimension(16, 16));
        reducedMatches.setPreferredSize(reducedMatches.getSize());
        reducedMatches.setMinimumSize(reducedMatches.getSize());
        infoPanel.add(authNoMatches);
        infoPanel.add(this._authoritativeNoMatch);
        infoPanel.add(this.getSeparator());
        infoPanel.add(authFullMatches);
        infoPanel.add(this._authoritativeFullMatch);
        infoPanel.add(this.getSeparator());
        infoPanel.add(matches);
        infoPanel.add(this.getSeparator());
        infoPanel.add(this._matches);
        infoPanel.add(this.getSeparator());
        infoPanel.add(reducedMatches);
        infoPanel.add(this._reducedMatches);
        this._gui.setPreferredSize(this._gui.getSize());
        this._gui.setMinimumSize(this._gui.getPreferredSize());
        this._gui.setResizable(false);
        this._gui.getContentPane().add(mainPanel);
        this._gui.setVisible(true);
        this._GUIAlreadySetUp = true;
    }

    private JLabel getSeparator() {
        JLabel separator = new JLabel(" ");
        separator.setSize(new Dimension(16, 16));
        separator.setMinimumSize(separator.getSize());
        separator.setPreferredSize(separator.getSize());
        return separator;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._stop.equals(e.getSource())) {
            this.halt();
        }
    }

    @Override
    protected void doNotifyNumberOfMatchesChanged(int matches) {
        this.setLabel(this._matches, matches);
    }

    @Override
    protected void doNotifyNumberOfAuthoritativeFullMatchesChanged(int matches) {
        this.setLabel(this._authoritativeFullMatch, matches);
    }

    @Override
    protected void doNotifyNumberOfAuthoritativeNoMatchesChanged(int matches) {
        this.setLabel(this._authoritativeNoMatch, matches);
    }

    @Override
    protected void doNotifyMaximumNumberOfMatchletsAppliedChanged(int matchlets) {
        this._matchletsProgressbar.setMaximum(matchlets);
        this._matchletsProgressbar.setValue(0);
        this.setLabel(this._maxMatchletsLabel, matchlets);
    }

    @Override
    protected void doNotifyMatchletsProcessStart() {
    }

    @Override
    protected void doNotifyMaximumNumberOfAtomicComparisonsPerformedInRoundChanged(int comparisons) {
        this._atomicComparisonsInRoundProgressbar.setMaximum(comparisons);
        this._atomicComparisonsInRoundProgressbar.setValue(0);
        this.setLabel(this._maxAtomicComparisonsInRoundLabel, comparisons);
    }

    @Override
    protected void doNotifyAtomicComparisonStart() {
        this._matchletsProgressbar.setValue(0);
    }

    @Override
    protected void doNotifyAtomicComparisonPerformed() {
        this._atomicComparisonsInRoundProgressbar.setValue(this.getCurrentNumberOfAtomicComparisonsPerformedInRound());
    }

    @Override
    protected void doNotifyNumberOfComparisonRoundsChanged(int rounds) {
        this._sourceDataProgressbar.setMaximum(rounds);
        this._sourceDataProgressbar.setValue(0);
        this.setLabel(this._maxProcessedSourceDataLabel, rounds);
    }

    @Override
    protected void doNotifyComparisonRoundStart(ProvidedData<SOURCE> source) {
        this._atomicComparisonsInRoundProgressbar.setValue(0);
    }

    @Override
    protected void doNotifyComparisonRoundPerformed(ProvidedData<SOURCE> source) {
        this._sourceDataProgressbar.setValue(this.getCurrentNumberOfComparisonRoundsPerformed());
    }

    @Override
    protected void doNotifyProcessStartEvent(String processId) {
        this._isInitialized = false;
        if (!this._GUIAlreadySetUp) {
            this._GUIAlreadySetUp = true;
            this.createGUI(processId);
            this._isInitialized = true;
        }
        if (this._gui != null && this._GUIAlreadySetUp) {
            this._gui.setTitle(processId);
        }
    }

    @Override
    protected void doNotifyProcessEndEvent() {
        this._gui.setTitle(String.valueOf(this._gui.getTitle()) + " : COMPLETED");
    }

    private void setLabel(JLabel label, Object text) {
        if (text != null) {
            label.setText(text.toString());
        } else {
            label.setText("");
        }
    }
}

