/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.io.providers.streaming.rdbms.protocols.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.fao.fi.comet.core.model.common.LinkedTypedComplexName;
import org.fao.fi.comet.core.patterns.data.providers.ProvidedData;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.tools.io.providers.streaming.AbstractSpeciesReferenceDataProvider;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

public class JDBCStreamingSpeciesReferenceDataProvider
extends AbstractSpeciesReferenceDataProvider {
    private Connection _c;
    private ResultSet _rs;

    private void releaseConnection(Connection connection) throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    private Connection getConnection(String jdbcURL) throws SQLException {
        return DriverManager.getConnection(jdbcURL);
    }

    private ResultSet execute(Connection connection, String query) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(query);
            return resultSet;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException SQLe) {
                    this._log.warn("Unable to close statement: {} [ {} ]", (Object)SQLe.getClass().getSimpleName(), (Object)SQLe.getMessage());
                }
            }
        }
    }

    private ResultSet selectTaxaData(Connection connection) throws SQLException {
        return this.execute(connection, "SELECT * FROM " + this.getProviderID() + "_TAXA");
    }

    private ResultSet selectVernacularData(Connection connection) throws SQLException {
        return this.execute(connection, "SELECT * FROM " + this.getProviderID() + "_VERNACULAR");
    }

    @Override
    public String[] getManagedProtocols() {
        return new String[]{"jdbc"};
    }

    @Override
    public void testEndpoint(String URI2) throws IOException {
        String JDBC_PROTOCOL = "jdbc://";
        AssertionUtils.$nNull(URI2, "Provided URI cannot be null", new Object[0]);
        AssertionUtils.$true(URI2.length() > "jdbc://".length(), "No URI provided (beside the protocol itself: {})", URI2);
        String jdbcURL = URI2.substring("jdbc://".length());
        try {
            this.releaseConnection(this.getConnection(jdbcURL));
        }
        catch (SQLException SQLe) {
            throw new IOException("Unable to properly access data via JDBC at " + URI2);
        }
    }

    @Override
    public int getAvailableDataSize() {
        Connection connection = null;
        try {
            connection = this.getConnection(this._taxaResourceURI);
            int n = this.execute(connection, "SELECT COUNT(*) FROM " + this.getProviderID() + "_TAXA").getInt(1);
            return n;
        }
        catch (SQLException SQLe) {
            this._log.warn("Unable to get available data size from URL {}: {} [ {} ]", new Object[]{this._taxaResourceURI, SQLe.getClass().getSimpleName(), SQLe.getMessage()});
            return -1;
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(connection);
                }
                catch (SQLException SQLe) {
                    this._log.warn("Unable to release connection: {} [ {} ]", (Object)SQLe.getClass().getSimpleName(), (Object)SQLe.getMessage());
                }
            }
        }
    }

    @Override
    public void rewind() {
        try {
            this.releaseResources();
            this._c = this.getConnection(this._taxaResourceURI);
            this._rs = this.selectTaxaData(this._c);
        }
        catch (Throwable t) {
            this._log.error("Unable to rewind iterator: {} [ {} ]", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
        }
    }

    @Override
    public Iterable<ProvidedData<ReferenceSpeciesData>> seek(int position) throws NoSuchElementException {
        try {
            if (this._c == null) {
                this._c = this.getConnection(this._taxaResourceURI);
            }
            if (this._rs == null) {
                this._rs = this.selectTaxaData(this._c);
            }
            this._rs.absolute(position);
            if (!this._rs.next()) {
                throw new NoSuchElementException();
            }
            return null;
        }
        catch (NoSuchElementException NSEe) {
            throw NSEe;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    protected final void doReleaseResources() throws Exception {
        if (this._rs != null) {
            try {
                this._rs.close();
            }
            catch (Throwable t) {
                this._log.warn("Unable to close resultset: {} [ {} ]", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
            }
            this._rs = null;
        }
        if (this._c != null) {
            try {
                this._c.close();
            }
            catch (Throwable t) {
                this._log.warn("Unable to close connection: {} [ {} ]", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
            }
            this._c = null;
        }
    }

    @Override
    public Iterator<ProvidedData<ReferenceSpeciesData>> iterator() {
        try {
            if (this._c == null) {
                this._c = this.getConnection(this._taxaResourceURI);
            }
            if (this._rs == null) {
                this._rs = this.selectTaxaData(this._c);
            }
            final JDBCStreamingSpeciesReferenceDataProvider $this = this;
            return new Iterator<ProvidedData<ReferenceSpeciesData>>(){

                @Override
                public boolean hasNext() {
                    try {
                        boolean hasNext;
                        boolean bl = hasNext = $this._rs != null && $this._rs.next();
                        if (hasNext) {
                            $this._rs.beforeFirst();
                        }
                        return hasNext;
                    }
                    catch (Throwable t) {
                        $this._log.error("Unable to check whether iterator hasNext(): {} [ {} ]", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
                        return false;
                    }
                }

                @Override
                public ProvidedData<ReferenceSpeciesData> next() {
                    try {
                        $this._rs.next();
                        return new ProvidedData<ReferenceSpeciesData>($this.getProviderID(), $this.convertReferenceSpeciesData($this._rs));
                    }
                    catch (Throwable t) {
                        $this._log.error("Unable to get next() element in iterator: {} [ {} ]", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
                        return null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (Throwable t) {
            this._log.warn("Unable to build reference species data iterator from resultset: {} [ {} ]", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
            throw new RuntimeException(t);
        }
    }

    @Override
    protected LinkedTypedComplexName[] getVernacularNames(String vernacularNamesResourceURI) throws IOException {
        try {
            Connection c = this.getConnection(this._vernacularNamesResourceURI);
            ResultSet rs = this.selectVernacularData(c);
            ArrayList<LinkedTypedComplexName> vernacularNames = new ArrayList<LinkedTypedComplexName>();
            while (rs.next()) {
                LinkedTypedComplexName vernacularName = this.convertLinkedTypedComplexName(rs);
                if (vernacularName == null || vernacularName.isEmpty()) continue;
                vernacularNames.add(vernacularName);
            }
            return vernacularNames.toArray(new LinkedTypedComplexName[vernacularNames.size()]);
        }
        catch (Throwable t) {
            this._log.error("Unable to get vernacular names: {} [ {} ]", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
            throw new IOException(t);
        }
    }

    private ReferenceSpeciesData convertReferenceSpeciesData(ResultSet rs) throws SQLException {
        ReferenceSpeciesData converted = new ReferenceSpeciesData();
        return converted;
    }

    private LinkedTypedComplexName convertLinkedTypedComplexName(ResultSet rs) throws SQLException {
        LinkedTypedComplexName converted = new LinkedTypedComplexName();
        converted.setParentId(rs.getString("PARENT_ID"));
        converted.setType(rs.getString("LANGUAGE"));
        converted.setName(rs.getString("VERNACULAR_NAME"));
        converted.setSimplifiedName(rs.getString("VERNACULAR_NAME_SIMPLIFIED_NAME"));
        converted.setSimplifiedNameNGrams(this.getNGrams(rs.getString("VERNACULAR_NAME_SIMPLIFIED_NAME_TRIGRAMS")));
        converted.setSimplifiedNameSoundex(rs.getString("VERNACULAR_NAME_SIMPLIFIED_NAME_SOUNDEX"));
        converted.setSimplifiedNameSoundexParts(this.getSoundexParts(rs.getString("VERNACULAR_NAME_SIMPLIFIED_NAME_SOUNDEX")));
        return converted;
    }

    private String[] getSoundexParts(String soundex) {
        if (soundex == null) {
            return null;
        }
        return soundex.split("\\s", -1);
    }

    private String[] getNGrams(String NGrams) {
        if (NGrams == null) {
            return null;
        }
        return NGrams.split("\\s", -1);
    }
}

