/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.parsers.impl;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.fao.fi.comet.domain.species.ReferenceSpeciesFactory;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.tools.parsers.impl.SpeciesNameParserSkeleton;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

@Singleton
@Named(value="SimpleSpeciesNameParser")
public class SimpleSpeciesNameParser
extends SpeciesNameParserSkeleton {
    @Override
    public String getId() {
        return "SIMPLE";
    }

    @Override
    public String getName() {
        return "Simple, regexp-based";
    }

    @Override
    public ReferenceSpeciesData[] parse(String[] names) {
        ArrayList<ReferenceSpeciesData> parsed = new ArrayList<ReferenceSpeciesData>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            parsed.add(this.doParse(name));
            ++n2;
        }
        return parsed.toArray(new ReferenceSpeciesData[parsed.size()]);
    }

    protected ReferenceSpeciesData doParse(String name) {
        String parsedName = StringUtils.rawTrim(name);
        if (parsedName == null) {
            return null;
        }
        parsedName = parsedName.replaceAll("\\'[^\\']*\\'", "");
        parsedName = parsedName.replaceAll("\\([^)]*\\)", "");
        parsedName = parsedName.replaceAll("\\([^)]*$", "");
        parsedName = parsedName.replaceAll("\\[[^\\]]*\\]", "");
        parsedName = parsedName.replaceAll("\\[[^)]*$", "");
        if ((parsedName = this.commonSanitization(parsedName)) != null) {
            parsedName = parsedName.replaceAll("[^\\p{L}]", " ");
        }
        if ((parsedName = StringUtils.rawTrim(parsedName)) == null) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        String[] stringArray = parsedName.split("\\s");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if ((part = StringUtils.rawTrim(part)) != null && part.length() > 2) {
                parts.add(part);
            }
            ++n2;
        }
        if (parts.isEmpty()) {
            return null;
        }
        String scientificName = parts.size() == 1 ? (String)parts.get(0) : String.valueOf((String)parts.get(0)) + " " + (String)parts.get(1);
        String authority = this.extractAuthority(name);
        if (authority != null) {
            String authors = authority.replaceAll("[^\\p{L}]", " ");
            authors = StringUtils.rawTrim(authors.replaceAll("\\s{2,}", " "));
            String[] stringArray2 = authors.split("\\s");
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String author = stringArray2[n4];
                scientificName = scientificName.replaceAll("(^|\\s)" + author + "(\\s|$)", "$1 $2");
                scientificName = StringUtils.rawTrim(scientificName.replaceAll("\\s{2,}", " "));
                ++n4;
            }
        }
        return ReferenceSpeciesFactory.newInstance(scientificName, authority);
    }

    public String extractBracketedAuthority(String name) {
        Matcher authorityMatcher = Pattern.compile(".*\\(([^)]+,?[\\d]{4})\\)").matcher(name);
        if (authorityMatcher.matches()) {
            return authorityMatcher.group(1);
        }
        authorityMatcher = Pattern.compile(".*\\[([^]]+,?[\\d]{4})\\]").matcher(name);
        if (authorityMatcher.matches()) {
            return authorityMatcher.group(1);
        }
        return name;
    }

    public String extractAuthority(String name) {
        name = name.replaceAll("(et al\\.?|\\set all|[a-zA-Z\\s]+?\\sin\\s|\\sin\\s)", "");
        String parsed = this.extractBracketedAuthority(name = name.replaceAll("(\\sand\\s|\\set\\s)", " & "));
        if (parsed != null && parsed.equals(name)) {
            Matcher authorityMatcher = Pattern.compile(".*?((([\\p{L}'-]+\\s?&\\s?([\\p{L}\\s'-]+))|(([\\p{L}'-]+\\s?,\\s?)+)|(([\\p{L}'-]+\\s?,\\s?)+)|(([\\p{L}'-])+))([\\s,])*([\\d]{4})).*?").matcher(name);
            if (authorityMatcher.matches()) {
                parsed = authorityMatcher.group(1).replaceAll("(.*)([\\p{L}])(\\s)([\\d]{4})", "$1$2,$3$4");
            } else {
                return null;
            }
        }
        parsed = StringUtils.rawTrim(this.commonAuthoritySanitization(parsed));
        return parsed;
    }

    private String commonAuthoritySanitization(String authority) {
        if (authority == null) {
            return null;
        }
        return StringUtils.rawTrim(authority.replaceAll("(in\\s|and\\s|et al\\.?|et all|et\\s)", " ").replaceAll("(.*[\\d]{4})(.*)", "$1").replaceAll("\\&", ",").replaceAll("\\s,", ","));
    }
}

