/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.extensions.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

public class FilterableProperties
extends Properties {
    private static final long serialVersionUID = 600781518167281114L;
    private static final String DEFAULT_PROPS_CHARSET = "ISO-8859-1";
    private final Charset _charset;

    public FilterableProperties() {
        this((Charset)null);
    }

    public FilterableProperties(Charset charset) {
        this._charset = charset;
    }

    public FilterableProperties(String charset) {
        this._charset = Charset.forName(charset);
    }

    protected FilterableProperties applyCharset() {
        if (this._charset != null) {
            return this.applyCharsetToKeys().applyCharsetToValues();
        }
        return this;
    }

    protected FilterableProperties applyCharsetToKeys() {
        TreeSet<Object> keys = new TreeSet<Object>(this.keySet());
        for (Object e : keys) {
            Object property = this.get(e);
            this.remove(e);
            this.put(this.applyCharsetToObject(e), property);
        }
        return this;
    }

    protected FilterableProperties applyCharsetToValues() {
        TreeSet<Object> keys = new TreeSet<Object>(this.keySet());
        for (Object e : keys) {
            this.put(e, this.applyCharsetToObject(this.get(e)));
        }
        return this;
    }

    protected Object applyCharsetToObject(Object object) {
        if (object != null && this._charset != null && String.class.isAssignableFrom(object.getClass())) {
            return this.toCharsetString((String)object);
        }
        return object;
    }

    protected String toCharsetString(String toConvert) {
        if (this._charset == null) {
            return toConvert;
        }
        String converted = toConvert;
        try {
            converted = converted == null ? null : new String(converted.getBytes(DEFAULT_PROPS_CHARSET), this._charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return converted;
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        super.load(reader);
        this.applyCharset();
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        super.load(inStream);
        this.applyCharset();
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        super.loadFromXML(in);
        this.applyCharset();
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return super.put(key, value);
    }

    public FilterableProperties filter(Pattern regexp) {
        assert (regexp != null);
        FilterableProperties filtered = new FilterableProperties(this._charset);
        for (Object key : this.keySet()) {
            if (key == null || !String.class.isAssignableFrom(key.getClass()) || !regexp.matcher((String)key).matches()) continue;
            filtered.put(key, this.get(key));
        }
        return filtered;
    }

    public FilterableProperties filter(String prefix) {
        assert (StringUtils.rawTrim(prefix) != null);
        return this.filter(Pattern.compile("^" + prefix.replaceAll("\\.", "\\\\.") + ".*"));
    }
}

