/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.singletons.lang.classes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.fao.vrmf.core.extensions.collections.impl.ListSet;
import org.fao.vrmf.core.helpers.singletons.AbstractHelperSingleton;
import org.fao.vrmf.core.helpers.singletons.lang.objects.CollectionsUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.support.FieldFilter;
import org.fao.vrmf.core.helpers.singletons.lang.objects.support.impl.NonStaticFieldFilter;
import org.fao.vrmf.core.helpers.singletons.lang.objects.support.impl.NonStaticNonFinalFieldFilter;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

public final class ClassUtils
extends AbstractHelperSingleton {
    public static final boolean TRAVERSE_CLASS_HIERARCHY = true;
    public static final boolean DONT_TRAVERSE_CLASS_HIERARCHY = false;
    private static final Set<Class<?>> BASIC_TYPES = new HashSet();
    private static final Map<String, Collection<Method>> GETTER_METHODS;
    private static final Pattern GETTER_METHOD_NAME_PATTERNS;
    private static final Map<String, Map<Class<?>, List<Field>>> FILTERED_CLASS_FIELDS_MAP;
    private static final Map<String, Map<Class<?>, List<Field>>> FILTERED_ALL_CLASS_FIELDS_MAP;
    private static final Map<Class<?>, List<Field>> CLASS_FIELDS_MAP;
    private static final Map<Class<?>, List<Field>> ALL_CLASS_FIELDS_MAP;

    static {
        BASIC_TYPES.add(Byte.class);
        BASIC_TYPES.add(Integer.class);
        BASIC_TYPES.add(Long.class);
        BASIC_TYPES.add(Float.class);
        BASIC_TYPES.add(Double.class);
        BASIC_TYPES.add(String.class);
        BASIC_TYPES.add(StringBuffer.class);
        BASIC_TYPES.add(Date.class);
        BASIC_TYPES.add(Calendar.class);
        BASIC_TYPES.add(Map.class);
        BASIC_TYPES.add(Collection.class);
        GETTER_METHODS = new HashMap<String, Collection<Method>>();
        GETTER_METHOD_NAME_PATTERNS = Pattern.compile("^get[A-Z|0-9|\\_].+|^is[A-Z|0-9|\\_].+|^has[A-Z|0-9|\\_].+");
        FILTERED_CLASS_FIELDS_MAP = Collections.synchronizedMap(new HashMap());
        FILTERED_ALL_CLASS_FIELDS_MAP = Collections.synchronizedMap(new HashMap());
        CLASS_FIELDS_MAP = Collections.synchronizedMap(new HashMap());
        ALL_CLASS_FIELDS_MAP = Collections.synchronizedMap(new HashMap());
    }

    private ClassUtils() {
    }

    public static String getSimpleClassNameForObject(Object object) {
        assert (object != null) : "Object cannot be NULL";
        return object.getClass().getSimpleName();
    }

    /*
     * Unable to fully structure code
     */
    public static String getPackageName(Class<?> clazz) {
        if (!ClassUtils.$assertionsDisabled && clazz == null) {
            throw new AssertionError((Object)"Class cannot be NULL");
        }
        if (!ClassUtils.isInDefaultPackage(clazz)) ** GOTO lbl6
        return "";
lbl-1000:
        // 1 sources

        {
            clazz = clazz.getComponentType();
lbl6:
            // 2 sources

            ** while (clazz.isArray())
        }
lbl7:
        // 1 sources

        return clazz.getPackage().getName();
    }

    public static String getPackageName(Object object) {
        assert (object != null) : "Object cannot be NULL";
        return ClassUtils.getPackageName(object.getClass());
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isInDefaultPackage(Class<?> clazz) {
        if (ClassUtils.$assertionsDisabled || clazz != null) ** GOTO lbl4
        throw new AssertionError((Object)"Class cannot be NULL");
lbl-1000:
        // 1 sources

        {
            clazz = clazz.getComponentType();
lbl4:
            // 2 sources

            ** while (clazz.isArray())
        }
lbl5:
        // 1 sources

        return clazz.getPackage() == null;
    }

    public static boolean isInDefaultPackage(Object object) {
        assert (object != null) : "Object cannot be NULL";
        return ClassUtils.isInDefaultPackage(object.getClass());
    }

    public static String getThis(Object object) {
        if (object == null) {
            return "<NULL>";
        }
        return String.valueOf(ClassUtils.getSimpleClassNameForObject(object)) + "@" + System.identityHashCode(object);
    }

    public static String getMethodInvocationSignature(Class<?> clazz, Method method, Object[] methodArguments) {
        assert (clazz != null);
        assert (method != null);
        int modifiers = method.getModifiers();
        Class<?> returnedType = method.getReturnType();
        String methodName = method.getName();
        String arguments = methodArguments == null || methodArguments.length == 0 ? "" : CollectionsUtils.serializeArray(methodArguments);
        StringBuffer signature = new StringBuffer();
        signature.append("[ ");
        signature.append("(").append(clazz.getSimpleName()).append(")");
        signature.append(" ");
        if (Modifier.isFinal(modifiers)) {
            signature.append("final ");
        }
        if (Modifier.isAbstract(modifiers)) {
            signature.append("abstract ");
        }
        if (Modifier.isPrivate(modifiers)) {
            signature.append("private ");
        }
        if (Modifier.isProtected(modifiers)) {
            signature.append("protected ");
        }
        if (Modifier.isPublic(modifiers)) {
            signature.append("public ");
        }
        if (Modifier.isStatic(modifiers)) {
            signature.append("static ");
        }
        signature.append(returnedType.getSimpleName()).append(" ");
        signature.append(methodName);
        signature.append("(").append(arguments).append(")");
        signature.append(" ]");
        return signature.toString();
    }

    public static String getMethodResponseCacheKey(Class<?> targetClass, Method method, Object[] methodArguments) {
        assert (targetClass != null) : "Target class cannot be NULL";
        assert (method != null) : "Method cannot be NULL";
        String serializedArguments = methodArguments == null ? "NULL" : (methodArguments.length == 0 ? "VOID" : ObjectsUtils.toString(30, methodArguments));
        return String.valueOf(targetClass.getName()) + "|" + method.getName() + "|" + serializedArguments;
    }

    public static boolean overridesEquals(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Method equals = clazz.getDeclaredMethod("equals", Object.class);
                    if (equals != null && Modifier.isPublic(equals.getModifiers())) {
                        return true;
                    }
                    return false;
                }
                catch (Throwable t) {
                    ClassUtils.getLogger().warn("Unexpected {} while attempting to check for 'equals' method definition. {}", (Object)ClassUtils.getSimpleClassNameForObject(t), (Object)t.getMessage());
                    return false;
                }
            }
        });
    }

    public static <A extends Annotation> boolean isAnnotationPresent(Class<?> clazz, Class<A> annotation) {
        ClassUtils.getLogger().debug("Navigating class {} in search of {}", clazz, annotation);
        Object currentClass = clazz;
        do {
            Type iface;
            if (((Class)currentClass).isAnnotationPresent(annotation)) {
                ClassUtils.getLogger().debug("Found annotation {} in {}", annotation, currentClass);
                return true;
            }
            Type[] typeArray = ((Class)currentClass).getInterfaces();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                iface = typeArray[n2];
                ClassUtils.getLogger().debug("Navigating interface {} in search of {}", iface, annotation);
                if (ClassUtils.isAnnotationPresent(iface, annotation)) {
                    ClassUtils.getLogger().debug("Found annotation {} in {}", annotation, iface);
                    return true;
                }
                ++n2;
            }
            typeArray = ((Class)currentClass).getGenericInterfaces();
            n = typeArray.length;
            n2 = 0;
            while (n2 < n) {
                iface = typeArray[n2];
                if (iface instanceof Class) {
                    ClassUtils.getLogger().debug("Navigating interface {} in search of {}", iface, annotation);
                    if (ClassUtils.isAnnotationPresent(iface, annotation)) {
                        ClassUtils.getLogger().debug("Found annotation {} in {}", annotation, iface);
                        return true;
                    }
                }
                ++n2;
            }
        } while ((currentClass = ((Class)currentClass).getGenericSuperclass() instanceof Class ? (Class)((Class)currentClass).getGenericSuperclass() : (((Class)currentClass).getGenericSuperclass() == null ? null : ((Class)currentClass).getSuperclass())) != null);
        return false;
    }

    public static <A extends Annotation> A getFirstAnnotationOfType(Class<?> clazz, Class<A> annotation) {
        Class<?> currentClass = clazz;
        do {
            Type iface;
            A annotationFound;
            if (currentClass.isAnnotationPresent(annotation) && (annotationFound = currentClass.getAnnotation(annotation)) != null) {
                return annotationFound;
            }
            Type[] typeArray = currentClass.getInterfaces();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                iface = typeArray[n2];
                if (ClassUtils.isAnnotationPresent(iface, annotation) && (annotationFound = ((Class)iface).getAnnotation(annotation)) != null) {
                    return annotationFound;
                }
                ++n2;
            }
            typeArray = currentClass.getGenericInterfaces();
            n = typeArray.length;
            n2 = 0;
            while (n2 < n) {
                iface = typeArray[n2];
                if (iface instanceof Class && ClassUtils.isAnnotationPresent(iface, annotation) && (annotationFound = ((Class)iface).getAnnotation(annotation)) != null) {
                    return annotationFound;
                }
                ++n2;
            }
        } while ((currentClass.getGenericSuperclass() instanceof Class ? (Class<?>)currentClass.getGenericSuperclass() : (currentClass = currentClass.getGenericSuperclass() == null ? null : currentClass.getSuperclass())) != null);
        return null;
    }

    public static <A extends Annotation> Collection<A> getAllAnnotationsOfType(Class<?> clazz, Class<A> annotation) {
        Class<?> currentClass = clazz;
        ListSet toReturn = new ListSet();
        do {
            A annotationFound;
            if (currentClass.isAnnotationPresent(annotation) && (annotationFound = currentClass.getAnnotation(annotation)) != null) {
                toReturn.add(annotationFound);
            }
            Class<?>[] classArray = currentClass.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                Collection<A> foundOnInterfaces = ClassUtils.getAllAnnotationsOfType(iface, annotation);
                if (foundOnInterfaces != null && !foundOnInterfaces.isEmpty()) {
                    toReturn.addAll(foundOnInterfaces);
                }
                ++n2;
            }
        } while ((currentClass.getGenericSuperclass() instanceof Class ? (Class<?>)currentClass.getGenericSuperclass() : (currentClass = currentClass.getGenericSuperclass() == null ? null : currentClass.getSuperclass())) != null);
        return toReturn;
    }

    public static Collection<Method> getAllMethods(Class<?> clazz) {
        Class<?> currentClass = clazz;
        ArrayList<Method> toReturn = new ArrayList<Method>();
        do {
            toReturn.addAll(Arrays.asList(currentClass.getDeclaredMethods()));
        } while ((currentClass.getGenericSuperclass() instanceof Class ? (Class<?>)currentClass.getGenericSuperclass() : (currentClass = currentClass.getGenericSuperclass() == null ? null : currentClass.getSuperclass())) != null);
        return toReturn;
    }

    public static Collection<Method> getAllGetterMethods(Class<?> clazz) {
        return ClassUtils.getAllGetterMethods(clazz, null);
    }

    public static Collection<Method> getAllGetterMethods(Class<?> clazz, Class<?> attributeClass) {
        Class<?> currentClass = clazz;
        ArrayList<Method> toReturn = new ArrayList<Method>();
        String cacheKey = String.valueOf(clazz.toString()) + (attributeClass == null ? "" : "_" + attributeClass.toString());
        if (GETTER_METHODS.containsKey(cacheKey)) {
            return GETTER_METHODS.get(cacheKey);
        }
        do {
            Method[] methodArray = currentClass.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (ClassUtils.isGetter(method, attributeClass)) {
                    toReturn.add(method);
                }
                ++n2;
            }
        } while ((currentClass.getGenericSuperclass() instanceof Class ? (Class<?>)currentClass.getGenericSuperclass() : (currentClass = currentClass.getGenericSuperclass() == null ? null : currentClass.getSuperclass())) != null);
        GETTER_METHODS.put(cacheKey, toReturn);
        return toReturn;
    }

    public static boolean isGetter(Method method, Class<?> attributeClass) {
        assert (method != null);
        assert (method.getName() != null);
        String name = method.getName();
        return GETTER_METHOD_NAME_PATTERNS.matcher(name).matches() && !"getClass".equals(name) && Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.class) && (attributeClass == null || attributeClass.isAssignableFrom(method.getReturnType()));
    }

    public static boolean isGetter(Method method) {
        return ClassUtils.isGetter(method, null);
    }

    public static Method getGetter(Class<?> clazz, String attributeName, Class<?> attributeClass) {
        assert (clazz != null);
        assert (attributeName != null);
        String updatedAttributeName = StringUtils.capitalizeFirstLetter(attributeName.replace("_", ""));
        for (Method getter : ClassUtils.getAllGetterMethods(clazz, attributeClass)) {
            String getterName = getter.getName();
            if (!ClassUtils.isGetter(getter) || !getterName.equals("get" + updatedAttributeName) && !getterName.equals("is" + updatedAttributeName) && !getterName.equals("has" + updatedAttributeName)) continue;
            return getter;
        }
        return null;
    }

    public static Method getGetter(Class<?> clazz, String attributeName) {
        return ClassUtils.getGetter(clazz, attributeName, null);
    }

    public static String getInvokerClassName() {
        return Thread.currentThread().getStackTrace()[2].getClassName();
    }

    public static Class<?> getInvokerClass() {
        long now = System.currentTimeMillis();
        String key = "getInvokerClass_" + now;
        try {
            throw new RuntimeException(key);
        }
        catch (RuntimeException Re) {
            StackTraceElement[] trace = Re.getStackTrace();
            String className = trace[2].getClassName();
            try {
                return Class.forName(className);
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    public static Method getCurrentMethod(Class<?> ownerClass) {
        if (ownerClass == null) {
            return null;
        }
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        Method currentMethod = null;
        for (Method m : ClassUtils.getAllMethods(ownerClass)) {
            if (!m.getName().equals(methodName)) continue;
            currentMethod = m;
            break;
        }
        return currentMethod;
    }

    public static Method getCurrentMethod(Object owner) {
        if (owner == null) {
            return null;
        }
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        Method currentMethod = null;
        for (Method m : ClassUtils.getAllMethods(owner.getClass())) {
            if (!m.getName().equals(methodName)) continue;
            currentMethod = m;
            break;
        }
        return currentMethod;
    }

    public static Collection<Field> listAllFields(Class<?> clazz) {
        return ClassUtils.listFields(clazz, true);
    }

    public static Collection<Field> listAllModifiableFields(Class<?> clazz) {
        return ClassUtils.listFields(clazz, true, NonStaticNonFinalFieldFilter.instance());
    }

    public static Collection<Field> listFields(Class<?> clazz, boolean traverseHierarchy) {
        return ClassUtils.listFields(clazz, traverseHierarchy, NonStaticFieldFilter.instance());
    }

    public static Collection<Field> listFields(final Class<?> clazz, final boolean traverseHierarchy, final FieldFilter ... fieldFilters) {
        assert (clazz != null) : "Provided class cannot be null";
        final boolean hasFieldFilters = fieldFilters != null && fieldFilters.length > 0;
        String fieldFiltersKey = "";
        Map<Class<?>, List<Field>> classFieldsCache = null;
        List<Field> cachedFields = null;
        if (hasFieldFilters) {
            ListSet fieldFilterKeys = new ListSet();
            FieldFilter[] fieldFilterArray = fieldFilters;
            int n = fieldFilters.length;
            int n2 = 0;
            while (n2 < n) {
                FieldFilter filter = fieldFilterArray[n2];
                if (filter != null) {
                    fieldFilterKeys.add(filter.toString());
                }
                ++n2;
            }
            Collections.sort(fieldFilterKeys);
            fieldFiltersKey = CollectionsUtils.join(fieldFilterKeys, "&");
            classFieldsCache = (traverseHierarchy ? FILTERED_ALL_CLASS_FIELDS_MAP : FILTERED_CLASS_FIELDS_MAP).get(fieldFiltersKey);
        } else {
            Map<Class<?>, List<Field>> map = classFieldsCache = traverseHierarchy ? ALL_CLASS_FIELDS_MAP : CLASS_FIELDS_MAP;
        }
        if (classFieldsCache != null && (cachedFields = classFieldsCache.get(clazz)) != null) {
            return cachedFields;
        }
        final ArrayList<Field> fields = new ArrayList<Field>();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                FieldFilter filter;
                int n;
                int n2;
                FieldFilter[] fieldFilterArray;
                boolean include;
                Field current;
                int n3;
                int n4;
                Field[] fieldArray;
                Class parentClass = clazz.getSuperclass();
                ArrayList<Field> currentFields = null;
                while (traverseHierarchy && parentClass != null && !parentClass.equals(Object.class)) {
                    currentFields = new ArrayList();
                    fieldArray = parentClass.getDeclaredFields();
                    n4 = fieldArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        current = fieldArray[n3];
                        include = true;
                        if (hasFieldFilters) {
                            fieldFilterArray = fieldFilters;
                            n2 = fieldFilters.length;
                            n = 0;
                            while (n < n2) {
                                filter = fieldFilterArray[n];
                                if (!(include &= filter.include(current))) break;
                                ++n;
                            }
                        }
                        if (include) {
                            current.setAccessible(true);
                            currentFields.add(current);
                        }
                        ++n3;
                    }
                    fields.addAll(0, currentFields);
                    parentClass = parentClass.getSuperclass();
                }
                currentFields = new ArrayList<Field>();
                fieldArray = clazz.getDeclaredFields();
                n4 = fieldArray.length;
                n3 = 0;
                while (n3 < n4) {
                    current = fieldArray[n3];
                    include = true;
                    if (hasFieldFilters) {
                        fieldFilterArray = fieldFilters;
                        n2 = fieldFilters.length;
                        n = 0;
                        while (n < n2) {
                            filter = fieldFilterArray[n];
                            if (!(include &= filter.include(current))) break;
                            ++n;
                        }
                    }
                    if (include) {
                        current.setAccessible(true);
                        currentFields.add(current);
                    }
                    ++n3;
                }
                fields.addAll(0, currentFields);
                return null;
            }
        });
        if (hasFieldFilters) {
            HashMap filteredFieldsCache = new HashMap();
            filteredFieldsCache.put(clazz, fields);
            (traverseHierarchy ? FILTERED_ALL_CLASS_FIELDS_MAP : FILTERED_CLASS_FIELDS_MAP).put(fieldFiltersKey, filteredFieldsCache);
        } else {
            (traverseHierarchy ? ALL_CLASS_FIELDS_MAP : CLASS_FIELDS_MAP).put(clazz, fields);
        }
        return fields;
    }

    public static Field getField(Class<?> clazz, String fieldName, boolean traverseHierarchy) {
        assert (clazz != null) : "Provided class cannot be null";
        assert (fieldName != null) : "Provided field name cannot be null";
        final Collection<Field> fields = ClassUtils.listFields(clazz, traverseHierarchy);
        final String updatedFieldName = fieldName.startsWith("_") ? fieldName.substring(1) : fieldName;
        Field byName = AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                for (Field field : fields) {
                    String currentFieldName = field.getName();
                    String string = currentFieldName = currentFieldName.startsWith("_") ? currentFieldName.substring(1) : currentFieldName;
                    if (!updatedFieldName.equals(currentFieldName)) continue;
                    return field;
                }
                return null;
            }
        });
        return byName;
    }
}

