/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fao.fi.comet.core.model.common.LinkedTypedComplexName;
import org.fao.fi.comet.core.model.common.TypedComplexName;
import org.fao.fi.comet.domain.species.ReferenceSpeciesFactory;
import org.fao.fi.comet.domain.species.VernacularNamesFactory;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.model.VernacularNameData;
import org.fao.vrmf.core.helpers.singletons.lang.objects.CollectionsUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.fao.vrmf.core.tools.lexical.processors.LexicalProcessor;
import org.fao.vrmf.core.tools.lexical.soundex.PhraseSoundexGenerator;
import org.fao.vrmf.core.tools.lexical.soundex.SoundexGenerator;

public class CommonReferenceSpeciesFactory {
    protected static final Pattern AUTHORITY_YEAR_PATTERN = Pattern.compile(".*([0-9]{4}).*");

    public static <S extends ReferenceSpeciesData> S updateComplexNames(S data, LexicalProcessor speciesSimplifierProcessor, LexicalProcessor speciesNormalizerProcessor, LexicalProcessor authoritySimplifierProcessor, LexicalProcessor authorityNormalizerProcessor, PhraseSoundexGenerator phraseSoundexer, SoundexGenerator soundexer) {
        String normalizedSoundex;
        String normalized;
        List<String> nGrams;
        String simplified;
        if (speciesSimplifierProcessor == null || speciesNormalizerProcessor == null || authoritySimplifierProcessor == null || authorityNormalizerProcessor == null || phraseSoundexer == null || soundexer == null) {
            return data;
        }
        if (data.getScientificName() != null) {
            simplified = speciesSimplifierProcessor.process(data.getScientificName());
            String simplifiedSoundex = simplified == null ? null : phraseSoundexer.getFullPhraseSoundex(simplified, false);
            nGrams = simplified == null ? null : StringUtils.extractPhraseNGrams(3, simplified, true);
            String[] parts = data.getScientificName().split(" ");
            data.setScientificCName(new TypedComplexName("scientific", data.getScientificName(), simplified, nGrams == null ? null : nGrams.toArray(new String[nGrams.size()]), simplifiedSoundex));
            if (parts != null && parts.length >= 1 && simplified != null && data.getGenus() == null) {
                data.setGenus(parts[0]);
                simplified = speciesSimplifierProcessor.process(data.getGenus());
                String string = simplifiedSoundex = simplified == null ? null : phraseSoundexer.getFullPhraseSoundex(simplified, false);
                if (parts.length >= 2 && data.getSpecies() == null) {
                    String remainingParts = CollectionsUtils.join(CollectionsUtils.behead(parts), " ");
                    data.setSpecies(remainingParts);
                    simplified = speciesSimplifierProcessor.process(remainingParts);
                    simplifiedSoundex = simplified == null ? null : phraseSoundexer.getFullPhraseSoundex(simplified, false);
                    List<String> list = nGrams = simplified == null ? null : StringUtils.extractPhraseNGrams(3, simplified, true);
                    if (simplified != null) {
                        data.setSpeciesCName(new TypedComplexName("species", remainingParts, simplified, nGrams == null ? null : nGrams.toArray(new String[nGrams.size()]), simplifiedSoundex));
                    }
                }
            }
        }
        if (data.getGenericCName() != null) {
            simplified = speciesSimplifierProcessor.process(data.getGenericCName().getName());
            if (simplified != null) {
                CommonReferenceSpeciesFactory.update(data.getGenericCName(), simplified, phraseSoundexer.getFullPhraseSoundex(simplified, false));
            } else {
                data.setGenericCName(null);
            }
        }
        if (data.getKingdom() != null) {
            simplified = speciesSimplifierProcessor.process(data.getKingdom());
            if (simplified != null) {
                data.setKingdomCName(new TypedComplexName("kingdom"));
                CommonReferenceSpeciesFactory.update(data.getKingdomCName(), data.getKingdom(), simplified, phraseSoundexer.getFullPhraseSoundex(simplified, false));
            } else {
                data.setKingdomCName(null);
            }
        }
        if (data.getPhylum() != null) {
            simplified = speciesSimplifierProcessor.process(data.getPhylum());
            if (simplified != null) {
                data.setPhylumCName(new TypedComplexName("phylum"));
                CommonReferenceSpeciesFactory.update(data.getPhylumCName(), data.getPhylum(), simplified, phraseSoundexer.getFullPhraseSoundex(simplified, false));
            } else {
                data.setPhylumCName(null);
            }
        }
        if (data.getKlass() != null) {
            simplified = speciesSimplifierProcessor.process(data.getKlass());
            if (simplified != null) {
                data.setClassCName(new TypedComplexName("class"));
                CommonReferenceSpeciesFactory.update(data.getClassCName(), data.getKlass(), simplified, phraseSoundexer.getFullPhraseSoundex(simplified, false));
            } else {
                data.setClassCName(null);
            }
        }
        if (data.getOrder() != null) {
            simplified = speciesSimplifierProcessor.process(data.getOrder());
            if (simplified != null) {
                data.setOrderCName(new TypedComplexName("order"));
                CommonReferenceSpeciesFactory.update(data.getOrderCName(), data.getOrder(), simplified, phraseSoundexer.getFullPhraseSoundex(simplified, false));
            } else {
                data.setOrderCName(null);
            }
        }
        if (data.getFamily() != null) {
            simplified = speciesSimplifierProcessor.process(data.getFamily());
            if (simplified != null) {
                data.setFamilyCName(new TypedComplexName("family"));
                CommonReferenceSpeciesFactory.update(data.getFamilyCName(), data.getFamily(), simplified, phraseSoundexer.getFullPhraseSoundex(simplified, false));
            } else {
                data.setFamilyCName(null);
            }
        }
        if (data.getGenus() != null) {
            simplified = speciesSimplifierProcessor.process(data.getGenus());
            List<String> list = nGrams = simplified == null ? null : StringUtils.extractPhraseNGrams(3, simplified, true);
            if (simplified != null) {
                data.setGenusCName(new TypedComplexName("genus", data.getGenus(), simplified, nGrams == null ? null : nGrams.toArray(new String[nGrams.size()]), phraseSoundexer.getFullPhraseSoundex(simplified, false)));
                normalized = StringUtils.rawTrim(speciesNormalizerProcessor.process(simplified));
                nGrams = normalized == null ? null : StringUtils.extractPhraseNGrams(3, normalized, true);
                normalizedSoundex = normalized == null ? null : soundexer.computeSoundex(normalized);
                data.setNormalizedGenusCName(new TypedComplexName("normalizedSpecies", normalized, normalized, nGrams == null ? null : nGrams.toArray(new String[nGrams.size()]), normalizedSoundex));
            } else {
                data.setGenusCName(null);
                data.setNormalizedGenusCName(null);
            }
        }
        if (data.getSpecies() != null) {
            simplified = speciesSimplifierProcessor.process(data.getSpecies());
            List<String> list = nGrams = simplified == null ? null : StringUtils.extractPhraseNGrams(3, simplified, true);
            if (simplified != null) {
                data.setSpeciesCName(new TypedComplexName("species", data.getSpecies(), simplified, nGrams == null ? null : nGrams.toArray(new String[nGrams.size()]), phraseSoundexer.getFullPhraseSoundex(simplified, false)));
                normalized = StringUtils.rawTrim(speciesNormalizerProcessor.process(simplified));
                nGrams = normalized == null ? null : StringUtils.extractPhraseNGrams(3, normalized, true);
                normalizedSoundex = normalized == null ? null : soundexer.computeSoundex(normalized);
                data.setNormalizedSpeciesCName(new TypedComplexName("normalizedSpecies", normalized, normalized, nGrams == null ? null : nGrams.toArray(new String[nGrams.size()]), normalizedSoundex));
            } else {
                data.setSpeciesCName(null);
                data.setNormalizedSpeciesCName(null);
            }
        }
        if (data.getAuthor() != null) {
            String authorities = StringUtils.rawTrim(data.getAuthor());
            HashSet<String> authoritiesSet = new HashSet<String>();
            if (authorities != null) {
                Matcher yearMatcher = AUTHORITY_YEAR_PATTERN.matcher(authorities);
                if (yearMatcher.matches()) {
                    data.setAuthorityYear(Integer.parseInt(yearMatcher.group(1)));
                }
                authorities = StringUtils.rawTrim(authorities.replaceAll("[\\d\\(\\)]", ""));
                authorities = StringUtils.rawTrim(authorities.replaceAll(",$", ""));
                data.setAuthority(authorities);
                ArrayList<TypedComplexName> authors = new ArrayList<TypedComplexName>();
                String normalizedAuthorities = authorityNormalizerProcessor.process(authorities);
                if (normalizedAuthorities != null) {
                    String[] stringArray = normalizedAuthorities.split("\\,");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String authority = stringArray[n2];
                        if (!authoritiesSet.contains(authority = StringUtils.rawTrim(authority))) {
                            String simplifiedAuthority = authoritySimplifierProcessor.process(authority);
                            List<String> list = nGrams = simplifiedAuthority == null ? null : StringUtils.extractPhraseNGrams(3, simplifiedAuthority, true);
                            if (simplifiedAuthority != null && simplifiedAuthority.length() > 1) {
                                authors.add(new TypedComplexName("authority", authority, simplifiedAuthority, nGrams == null ? null : nGrams.toArray(new String[nGrams.size()]), phraseSoundexer.getFullPhraseSoundex(simplifiedAuthority, false)));
                            }
                            authoritiesSet.add(authority);
                        }
                        ++n2;
                    }
                }
                if (!authors.isEmpty()) {
                    data.setAuthoritiesCName(authors.toArray(new TypedComplexName[authors.size()]));
                }
            }
        }
        ReferenceSpeciesFactory.updateComplexVernacularNames(data, speciesSimplifierProcessor, speciesNormalizerProcessor, authoritySimplifierProcessor, authorityNormalizerProcessor, phraseSoundexer, soundexer);
        return data;
    }

    public static ReferenceSpeciesData updateComplexVernacularNames(ReferenceSpeciesData data, LexicalProcessor speciesSimplifierProcessor, LexicalProcessor speciesNormalizerProcessor, LexicalProcessor authoritySimplifierProcessor, LexicalProcessor authorityNormalizerProcessor, PhraseSoundexGenerator phraseSoundexer, SoundexGenerator soundexer) {
        if (data.getVernacularNames() != null) {
            List<VernacularNameData> sorted = Arrays.asList(data.getVernacularNames());
            Collections.sort(sorted);
            data.setVernacularNames(sorted.toArray(new VernacularNameData[sorted.size()]));
            ArrayList<LinkedTypedComplexName> vernacularCNames = new ArrayList<LinkedTypedComplexName>();
            VernacularNameData[] vernacularNameDataArray = data.getVernacularNames();
            int n = vernacularNameDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                VernacularNameData vernacularName = vernacularNameDataArray[n2];
                if (vernacularName != null) {
                    vernacularCNames.add(VernacularNamesFactory.toComplexName(vernacularName, speciesSimplifierProcessor, phraseSoundexer));
                }
                ++n2;
            }
            if (!vernacularCNames.isEmpty()) {
                data.setVernacularCNames(vernacularCNames.toArray(new LinkedTypedComplexName[vernacularCNames.size()]));
            }
        }
        return data;
    }

    private static TypedComplexName update(TypedComplexName cName, String simplified, String simplifiedSoundex) {
        cName.setSimplifiedName(simplified);
        if (simplified != null) {
            List<String> nGrams = StringUtils.extractPhraseNGrams(3, simplified, true);
            cName.setSimplifiedNameNGrams(nGrams.toArray(new String[nGrams.size()]));
        }
        cName.setSimplifiedNameSoundex(simplifiedSoundex);
        if (simplifiedSoundex != null) {
            cName.setSimplifiedNameSoundexParts(simplifiedSoundex.split("\\s"));
        }
        return cName;
    }

    private static TypedComplexName update(TypedComplexName cName, String name, String simplified, String simplifiedSoundex) {
        TypedComplexName updated = CommonReferenceSpeciesFactory.update(cName, simplified, simplifiedSoundex);
        updated.setName(name);
        return updated;
    }
}

