/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.io.support.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fao.fi.comet.core.model.common.LinkedTypedComplexName;
import org.fao.fi.comet.core.model.common.TypedComplexName;
import org.fao.fi.comet.domain.species.VernacularNamesFactory;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.model.VernacularNameData;
import org.fao.fi.comet.domain.species.tools.io.support.ReferenceDataConverter;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.CollectionsUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

public class DefaultTAFReferenceDataConverter
implements ReferenceDataConverter<ReferenceSpeciesData> {
    private static final String[] NO_SOUNDEX_PARTS = new String[0];
    public static final String TAB_SEPARATOR_REGEXP = "\\t";
    public static final String COMMA_SEPARATOR_REGEXP = "\\,";
    public static final String SEMICOLON_SEPARATOR_REGEXP = ";";
    private final String _separatorRegexp;
    private final int _lexicalFlags;
    private final int _taxaFlags;
    private final int _vernFlags;

    public DefaultTAFReferenceDataConverter() {
        this(TAB_SEPARATOR_REGEXP, 0, 0, 0);
    }

    public DefaultTAFReferenceDataConverter(String separatorRegexp) {
        this(separatorRegexp, 0, 0, 0);
    }

    public DefaultTAFReferenceDataConverter(int lexicalFlags, int taxaFlags, int vernacularFlags) {
        this(TAB_SEPARATOR_REGEXP, lexicalFlags, taxaFlags, vernacularFlags);
    }

    public DefaultTAFReferenceDataConverter(String separatorRegexp, int lexicalFlags, int taxaFlags, int vernFlags) {
        AssertionUtils.$true(separatorRegexp != null && !"".equals(separatorRegexp), "The separator regexp for CSV lines cannot be NULL or NULL-equivalent", new Object[0]);
        AssertionUtils.$nNeg(lexicalFlags, "Lexical flags must be non-negative", new Object[0]);
        AssertionUtils.$nNeg(taxaFlags, "Taxa flags must be non-negative", new Object[0]);
        AssertionUtils.$nNeg(vernFlags, "Vernacular flags must be non-negative", new Object[0]);
        this._separatorRegexp = separatorRegexp;
        this._lexicalFlags = lexicalFlags;
        this._taxaFlags = taxaFlags;
        this._vernFlags = vernFlags;
    }

    protected final String unwrap(String wrapped) {
        return wrapped == null || wrapped.length() == 0 ? null : wrapped.substring(1, wrapped.length() - 1).replace("\"\"", "\"");
    }

    protected final String wrap(String unwrapped) {
        return unwrapped == null ? "\"\"" : "\"" + unwrapped.replace("\"", "\"\"") + "\"";
    }

    protected final TypedComplexName clear(TypedComplexName data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        return data;
    }

    protected final boolean includeLexicalData(int lexicalData) {
        return this._lexicalFlags == 0 || (lexicalData & this._lexicalFlags) == lexicalData;
    }

    protected final boolean retrieveTaxaData(int taxaData) {
        return this._taxaFlags == 0 || (taxaData & this._taxaFlags) == taxaData;
    }

    protected final boolean retrieveVernData(int vernData) {
        return this._vernFlags == 0 || (vernData & this._vernFlags) == vernData;
    }

    protected final int skipTaxaData(int taxaData, int counter) {
        if (this.retrieveTaxaData(taxaData)) {
            return counter;
        }
        switch (taxaData) {
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 4096: {
                return counter + 1 + 1 + 1 + 1;
            }
            case 2048: 
            case 8192: {
                return counter + 1;
            }
        }
        return counter;
    }

    protected final boolean includeVernData(int vernData, int vernFlags) {
        return vernFlags == 0 || (vernData & vernFlags) == vernData;
    }

    protected final int skipVernData(int vernData, int vernFlags, int counter) {
        if (this.includeVernData(vernData, vernFlags)) {
            return counter;
        }
        switch (vernData) {
            case 8: {
                return counter + 1 + 1 + 1 + 1;
            }
            case 2: 
            case 4: {
                return counter + 1;
            }
        }
        return counter;
    }

    @Override
    public ReferenceSpeciesData deserialize(String providerID, String line, Map<String, LinkedTypedComplexName[]> vernacularCNamesMap) {
        LinkedTypedComplexName[] vernacularCNames;
        ReferenceSpeciesData data = this.deserializeTaxa(providerID, line);
        if (data != null && vernacularCNamesMap != null && (vernacularCNames = vernacularCNamesMap.get(data.getId())) != null) {
            List<LinkedTypedComplexName> cSorted = Arrays.asList(vernacularCNames);
            Collections.sort(cSorted);
            data.setVernacularCNames(cSorted.toArray(new LinkedTypedComplexName[cSorted.size()]));
            data.setVernacularNames(new VernacularNameData[vernacularCNames.length]);
            int n = 0;
            LinkedTypedComplexName[] linkedTypedComplexNameArray = vernacularCNames;
            int n2 = vernacularCNames.length;
            int n3 = 0;
            while (n3 < n2) {
                LinkedTypedComplexName vernacularName = linkedTypedComplexNameArray[n3];
                data.getVernacularNames()[n++] = VernacularNamesFactory.newInstance(vernacularName.getParentId(), vernacularName.getType(), null, vernacularName.getName());
                ++n3;
            }
        }
        return data;
    }

    @Override
    public String serializeTaxaHeader() {
        Object[] headers = new String[]{"ID", "KINGDOM", "KINGDOM_SIMPLIFIED_NAME", "KINGDOM_SIMPLIFIED_NAME_TRIGRAMS", "KINGDOM_SIMPLIFIED_NAME_SOUNDEX", "PHYLUM", "PHYLUM_SIMPLIFIED_NAME", "PHYLUM_SIMPLIFIED_NAME_TRIGRAMS", "PHYLUM_SIMPLIFIED_NAME_SOUNDEX", "CLASS", "CLASS_SIMPLIFIED_NAME", "CLASS_SIMPLIFIED_NAME_TRIGRAMS", "CLASS_SIMPLIFIED_NAME_SOUNDEX", "ORDER", "ORDER_SIMPLIFIED_NAME", "ORDER_SIMPLIFIED_NAME_TRIGRAMS", "ORDER_SIMPLIFIED_NAME_SOUNDEX", "FAMILY", "FAMILY_SIMPLIFIED_NAME", "FAMILY_SIMPLIFIED_NAME_TRIGRAMS", "FAMILY_SIMPLIFIED_NAME_SOUNDEX", "GENUS", "GENUS_SIMPLIFIED_NAME", "GENUS_SIMPLIFIED_NAME_TRIGRAMS", "GENUS_SIMPLIFIED_NAME_SOUNDEX", "NORMALIZED_GENUS", "NORMALIZED_GENUS_SIMPLIFIED_NAME", "NORMALIZED_GENUS_SIMPLIFIED_NAME_TRIGRAMS", "NORMALIZED_GENUS_SIMPLIFIED_NAME_SOUNDEX", "SPECIES", "SPECIES_SIMPLIFIED_NAME", "SPECIES_SIMPLIFIED_NAME_TRIGRAMS", "SPECIES_SIMPLIFIED_NAME_SOUNDEX", "NORMALIZED_SPECIES", "NORMALIZED_SPECIES_SIMPLIFIED_NAME", "NORMALIZED_SPECIES_SIMPLIFIED_NAME_TRIGRAMS", "NORMALIZED_SPECIES_SIMPLIFIED_NAME_SOUNDEX", "SCIENTIFIC_NAME", "SCIENTIFIC_NAME_SIMPLIFIED_NAME", "SCIENTIFIC_NAME_SIMPLIFIED_NAME_TRIGRAMS", "SCIENTIFIC_NAME_SIMPLIFIED_NAME_SOUNDEX", "AUTHOR", "AUTHORITY_YEAR", "AUTHORITIES", "AUTHORITIES_SIMPLIFIED_NAME", "AUTHORITIES_SIMPLIFIED_NAME_TRIGRAMS", "AUTHORITIES_SIMPLIFIED_NAME_SOUNDEX"};
        return CollectionsUtils.join(headers, "\t");
    }

    @Override
    public String serializeVernacularNamesHeader() {
        Object[] headers = new String[]{"PARENT_ID", "LANGUAGE", "VERNACULAR_NAME", "VERNACULAR_NAME_SIMPLIFIED_NAME", "VERNACULAR_NAME_SIMPLIFIED_NAME_TRIGRAMS", "VERNACULAR_NAME_SIMPLIFIED_NAME_SOUNDEX"};
        return CollectionsUtils.join(headers, "\t");
    }

    @Override
    public ReferenceSpeciesData deserializeTaxa(String providerID, String line) {
        String[] parts = line.split(this._separatorRegexp, -1);
        ReferenceSpeciesData data = new ReferenceSpeciesData();
        data.setDataSource(providerID);
        int counter = 0;
        data.setId(StringUtils.rawTrim(this.unwrap(parts[counter++])));
        if (this.retrieveTaxaData(2)) {
            data.setKingdom(StringUtils.rawTrim(this.unwrap(parts[counter++])));
            data.setKingdomCName(this.deserializeCName("kingdom", data.getKingdom(), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++]))));
        } else {
            counter = this.skipTaxaData(2, counter);
        }
        if (this.retrieveTaxaData(4)) {
            data.setPhylum(StringUtils.rawTrim(this.unwrap(parts[counter++])));
            data.setPhylumCName(this.deserializeCName("phylum", data.getPhylum(), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++]))));
        } else {
            counter = this.skipTaxaData(4, counter);
        }
        if (this.retrieveTaxaData(8)) {
            data.setKlass(StringUtils.rawTrim(this.unwrap(parts[counter++])));
            data.setClassCName(this.deserializeCName("class", data.getKlass(), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++]))));
        } else {
            counter = this.skipTaxaData(8, counter);
        }
        if (this.retrieveTaxaData(16)) {
            data.setOrder(StringUtils.rawTrim(this.unwrap(parts[counter++])));
            data.setOrderCName(this.deserializeCName("order", data.getOrder(), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++]))));
        } else {
            counter = this.skipTaxaData(16, counter);
        }
        if (this.retrieveTaxaData(32)) {
            data.setFamily(StringUtils.rawTrim(this.unwrap(parts[counter++])));
            data.setFamilyCName(this.deserializeCName("family", data.getFamily(), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++]))));
        } else {
            counter = this.skipTaxaData(32, counter);
        }
        if (this.retrieveTaxaData(64)) {
            data.setGenus(StringUtils.rawTrim(this.unwrap(parts[counter++])));
            data.setGenusCName(this.deserializeCName("genus", data.getGenus(), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++]))));
        } else {
            counter = this.skipTaxaData(64, counter);
        }
        if (this.retrieveTaxaData(512)) {
            data.setNormalizedGenusCName(this.deserializeCName("normalizedGenus", StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++]))));
        } else {
            counter = this.skipTaxaData(512, counter);
        }
        if (this.retrieveTaxaData(128)) {
            data.setSpecies(StringUtils.rawTrim(this.unwrap(parts[counter++])));
            data.setSpeciesCName(this.deserializeCName("species", data.getSpecies(), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++]))));
        } else {
            counter = this.skipTaxaData(128, counter);
        }
        if (this.retrieveTaxaData(1024)) {
            data.setNormalizedSpeciesCName(this.deserializeCName("normalizedSpecies", StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++]))));
        } else {
            counter = this.skipTaxaData(1024, counter);
        }
        if (this.retrieveTaxaData(256)) {
            data.setScientificName(StringUtils.rawTrim(this.unwrap(parts[counter++])));
            data.setScientificCName(this.deserializeCName("scientific", data.getScientificName(), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++])), StringUtils.rawTrim(this.unwrap(parts[counter++]))));
        } else {
            counter = this.skipTaxaData(256, counter);
        }
        if (this.retrieveTaxaData(2048)) {
            data.setAuthor(StringUtils.rawTrim(this.unwrap(parts[counter++])));
        } else {
            counter = this.skipTaxaData(2048, counter);
        }
        if (counter < parts.length) {
            if (this.retrieveTaxaData(8192)) {
                String year;
                if ((year = StringUtils.rawTrim(this.unwrap(parts[counter++]))) != null) {
                    data.setAuthorityYear(Integer.valueOf(year));
                }
            } else {
                counter = this.skipTaxaData(8192, counter);
            }
            if (this.retrieveTaxaData(4096)) {
                String authority = StringUtils.rawTrim(this.unwrap(parts[counter++]));
                String simplifiedAuthority = StringUtils.rawTrim(this.unwrap(parts[counter++]));
                data.setAuthority(authority);
                if (simplifiedAuthority != null) {
                    String authoritiesTrigramParts = StringUtils.rawTrim(this.unwrap(parts[counter++]));
                    String authoritiesSoundexParts = StringUtils.rawTrim(this.unwrap(parts[counter++]));
                    String[] singleAuthorities = authority.split("\\|", -1);
                    String[] singleSimplifiedAuthorities = simplifiedAuthority == null ? new String[singleAuthorities.length] : simplifiedAuthority.split("\\|", -1);
                    String[] singleAuthoritiesSoundexParts = null;
                    String[] singleAuthoritiesTrigrams = null;
                    singleAuthoritiesSoundexParts = authoritiesSoundexParts != null ? authoritiesSoundexParts.split("\\|", -1) : new String[singleAuthorities.length];
                    singleAuthoritiesTrigrams = authoritiesTrigramParts != null ? authoritiesTrigramParts.split("\\|", -1) : new String[singleAuthorities.length];
                    int saLength = singleAuthorities == null ? -1 : singleAuthorities.length;
                    int ssaLength = singleSimplifiedAuthorities == null ? -1 : singleSimplifiedAuthorities.length;
                    int saspLength = singleAuthoritiesSoundexParts == null ? -1 : singleAuthoritiesSoundexParts.length;
                    int satLength = singleAuthoritiesTrigrams == null ? -1 : singleAuthoritiesTrigrams.length;
                    AssertionUtils.$true(saLength == ssaLength, "Size mismatch between authorities length ({}) and simplified authorities length ({})", saLength, ssaLength);
                    AssertionUtils.$true(saLength == saspLength, "Size mismatch between authorities length ({}) and authorities soundex parts length ({})", saLength, saspLength);
                    AssertionUtils.$true(saLength == satLength, "Size mismatch between authorities length ({}) and authorities trigrams length ({})", saLength, saspLength);
                    ArrayList<TypedComplexName> authorityData = new ArrayList<TypedComplexName>();
                    int a = 0;
                    while (a < singleAuthorities.length) {
                        String singleAuthority = StringUtils.rawTrim(singleAuthorities[a]);
                        String singleSimplifiedAuthority = StringUtils.rawTrim(singleSimplifiedAuthorities[a]);
                        String singleAuthoritySoundex = StringUtils.rawTrim(singleAuthoritiesSoundexParts[a]);
                        String singleAuthorityTrigrams = StringUtils.rawTrim(singleAuthoritiesTrigrams[a]);
                        if (singleAuthority != null) {
                            TypedComplexName cName = new TypedComplexName();
                            cName.setType("authority");
                            cName.setName(singleAuthority);
                            if (this.includeLexicalData(2)) {
                                cName.setSimplifiedName(singleSimplifiedAuthority);
                            }
                            if (this.includeLexicalData(4)) {
                                cName.setSimplifiedNameSoundex(singleAuthoritySoundex);
                                cName.setSimplifiedNameSoundexParts(singleAuthoritySoundex == null ? null : singleAuthoritySoundex.split("\\s"));
                            }
                            if (this.includeLexicalData(8)) {
                                cName.setSimplifiedNameNGrams(singleAuthorityTrigrams == null ? null : singleAuthorityTrigrams.split("\\s"));
                            }
                            if ((cName = this.clear(cName)) != null) {
                                authorityData.add(cName);
                            }
                        }
                        ++a;
                    }
                    if (!authorityData.isEmpty()) {
                        data.setAuthoritiesCName(authorityData.toArray(new TypedComplexName[authorityData.size()]));
                    }
                }
            } else {
                counter = this.skipTaxaData(4096, counter);
            }
        }
        return data;
    }

    @Override
    public String serializeTaxa(ReferenceSpeciesData data, String providerID) {
        TypedComplexName[] complexNames;
        if (data == null) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.wrap(data.getId()));
        TypedComplexName[] typedComplexNameArray = complexNames = new TypedComplexName[]{data.getKingdomCName(), data.getPhylumCName(), data.getClassCName(), data.getOrderCName(), data.getFamilyCName(), data.getGenusCName(), data.getNormalizedGenusCName(), data.getSpeciesCName(), data.getNormalizedSpeciesCName(), data.getScientificCName()};
        int n = complexNames.length;
        int n2 = 0;
        while (n2 < n) {
            TypedComplexName complexName = typedComplexNameArray[n2];
            for (String part : this.serializeCName(complexName)) {
                parts.add(this.wrap(part));
            }
            ++n2;
        }
        parts.add(this.wrap(data.getAuthor()));
        parts.add(this.wrap(ObjectsUtils.coalesce(data.getAuthorityYear(), "").toString()));
        int numAuthorities = data.getAuthoritiesCName() == null ? 0 : data.getAuthoritiesCName().length;
        Object[] authorities = new String[numAuthorities];
        Object[] simplifiedAuthorities = new String[numAuthorities];
        Object[] simplifiedAuthoritiesNGrams = new String[numAuthorities];
        Object[] simplifiedAuthoritiesSoundex = new String[numAuthorities];
        if (numAuthorities > 0) {
            int counter = 0;
            TypedComplexName[] typedComplexNameArray2 = data.getAuthoritiesCName();
            int n3 = typedComplexNameArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TypedComplexName authority = typedComplexNameArray2[n4];
                authorities[counter] = ObjectsUtils.coalesce(authority.getName(), "");
                simplifiedAuthorities[counter] = ObjectsUtils.coalesce(authority.getSimplifiedName(), "");
                simplifiedAuthoritiesNGrams[counter] = ObjectsUtils.coalesce(authority.getSimplifiedNameNGrams() == null ? null : CollectionsUtils.join(authority.getSimplifiedNameNGrams(), " "), "");
                simplifiedAuthoritiesSoundex[counter] = ObjectsUtils.coalesce(authority.getSimplifiedNameSoundex(), "");
                ++counter;
                ++n4;
            }
        }
        parts.add(this.wrap(CollectionsUtils.join(authorities, "|")));
        parts.add(this.wrap(CollectionsUtils.join(simplifiedAuthorities, "|")));
        parts.add(this.wrap(CollectionsUtils.join(simplifiedAuthoritiesNGrams, "|")));
        parts.add(this.wrap(CollectionsUtils.join(simplifiedAuthoritiesSoundex, "|")));
        return CollectionsUtils.join(parts, "\t");
    }

    @Override
    public String[] serializeVernacularNames(ReferenceSpeciesData data, String providerID) {
        LinkedTypedComplexName[] vernacularNames = data.getVernacularCNames();
        ArrayList<String> serialized = new ArrayList<String>();
        if (vernacularNames != null) {
            LinkedTypedComplexName[] linkedTypedComplexNameArray = vernacularNames;
            int n = vernacularNames.length;
            int n2 = 0;
            while (n2 < n) {
                LinkedTypedComplexName vernacularName = linkedTypedComplexNameArray[n2];
                String line = this.serializeVernacularName(vernacularName, data.getId(), providerID);
                if (line != null) {
                    serialized.add(line);
                }
                ++n2;
            }
        }
        if (serialized.isEmpty()) {
            return null;
        }
        return serialized.toArray(new String[serialized.size()]);
    }

    @Override
    public String serializeVernacularName(TypedComplexName data, String parentId, String providerID) {
        String line = null;
        if (data != null) {
            line = String.valueOf(this.wrap(parentId)) + "\t";
            line = String.valueOf(line) + this.wrap(data.getType().substring("vernacular_".length())) + "\t";
            for (String part : this.serializeCName(data)) {
                line = String.valueOf(line) + this.wrap(part) + "\t";
            }
            line = line.substring(0, line.length() - 1);
        }
        return line;
    }

    @Override
    public LinkedTypedComplexName deserializeVernacularCName(String providerID, String line) {
        String[] parts = line.split(this._separatorRegexp, -1);
        if (parts.length == 0) {
            return null;
        }
        LinkedTypedComplexName vernacularName = new LinkedTypedComplexName();
        int counter = 0;
        vernacularName.setParentId(this.unwrap(parts[counter++]));
        String nGrams = null;
        String type = this.unwrap(parts[counter++]);
        type = type.replaceAll("\\s?\\(.+\\)$", "");
        if (this.retrieveVernData(2)) {
            vernacularName.setType("vernacular_" + type);
        }
        vernacularName.setName(this.unwrap(parts[counter++]));
        if (this.includeLexicalData(2)) {
            vernacularName.setSimplifiedName(this.unwrap(parts[counter++]));
        }
        nGrams = this.unwrap(parts[counter++]);
        if (this.includeLexicalData(8) && nGrams != null) {
            vernacularName.setSimplifiedNameNGrams(nGrams.split("\\s", -1));
        }
        if (this.includeLexicalData(4)) {
            vernacularName.setSimplifiedNameSoundex(this.unwrap(parts[counter++]));
            if (vernacularName.getSimplifiedNameSoundex() != null) {
                vernacularName.setSimplifiedNameSoundexParts(vernacularName.getSimplifiedNameSoundex().split("\\s", -1));
            } else {
                vernacularName.setSimplifiedNameSoundexParts(null);
            }
        }
        return vernacularName;
    }

    protected Collection<String> serializeCName(TypedComplexName cName) {
        ArrayList<String> parts = new ArrayList<String>();
        if (cName == null) {
            parts.add(null);
            parts.add(null);
            parts.add(null);
            parts.add(null);
        } else {
            parts.add(cName.getName());
            if (this.includeLexicalData(2)) {
                parts.add(cName.getSimplifiedName());
            }
            if (this.includeLexicalData(8)) {
                parts.add(cName.getSimplifiedNameNGrams() == null ? null : CollectionsUtils.join(cName.getSimplifiedNameNGrams(), " "));
            }
            if (this.includeLexicalData(4)) {
                parts.add(cName.getSimplifiedNameSoundex());
            }
        }
        return parts;
    }

    protected TypedComplexName deserializeCName(String type, String name, String simplified, String ngrams, String soundex) {
        TypedComplexName cName = new TypedComplexName();
        cName.setType(type);
        cName.setName(name);
        cName.setSimplifiedName(simplified);
        cName.setSimplifiedNameNGrams(ngrams == null ? null : ngrams.split("\\s", -1));
        cName.setSimplifiedNameSoundex(soundex);
        cName.setSimplifiedNameSoundexParts(cName.getSimplifiedNameSoundex() == null ? NO_SOUNDEX_PARTS : cName.getSimplifiedNameSoundex().split("\\s", -1));
        return this.clear(cName);
    }
}

