/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.matchlets.skeleton;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.fao.fi.comet.core.exceptions.MatchletConfigurationException;
import org.fao.fi.comet.core.matchlets.skeleton.MatchletSkeleton;
import org.fao.fi.comet.core.matchlets.skeleton.behaviours.BasicBehaviour;
import org.fao.fi.comet.core.matchlets.skeleton.behaviours.BehaviourSkeleton;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.engine.MatchingResult;
import org.fao.fi.comet.core.model.engine.MatchingResultData;
import org.fao.fi.comet.core.model.matchlets.VectorialMatchlet;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletParameter;
import org.fao.fi.comet.core.model.matchlets.annotations.parameters.StringValidValues;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

public abstract class VectorialMatchletSkeleton<SOURCE, SOURCE_DATA extends Serializable, TARGET, TARGET_DATA extends Serializable>
extends MatchletSkeleton<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA>
implements VectorialMatchlet<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> {
    private static final long serialVersionUID = -858237716778011026L;
    @MatchletParameter(name="combinationCriteria", description="Sets the combination criteria to derive the final score for source data matching with multiple target data. If set to OR, the highest-valued matching result will be returned at the end of the process. Conversely, when set to AND, an authoritative match will halt this' matchlet comparisons and be returned as final match result.")
    @StringValidValues(values={"OR", "AND"}, multiple=false)
    private String _combinationCriteria = "OR";

    public VectorialMatchletSkeleton() {
        this(new BasicBehaviour());
    }

    public VectorialMatchletSkeleton(BehaviourSkeleton<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> behaviour) {
        super(behaviour);
    }

    @Override
    protected void doValidateConfiguration() throws MatchletConfigurationException {
        try {
            AssertionUtils.$true("AND".equals(this._combinationCriteria) || "OR".equals(this._combinationCriteria), "The combination criteria must be one among { {}, {} } (currently: {})", "AND", "OR", this._combinationCriteria);
        }
        catch (IllegalArgumentException IAe) {
            throw new MatchletConfigurationException(IAe.getMessage());
        }
    }

    public String getCombinationCriteria() {
        return this._combinationCriteria;
    }

    public void setCombinationCriteria(String combinationCriteria) {
        this._combinationCriteria = combinationCriteria;
    }

    @Override
    public MatchingResult<SOURCE_DATA, TARGET_DATA> compareData(SOURCE sourceEntity, DataIdentifier sourceIdentifier, TARGET targetEntity, DataIdentifier targetIdentifier) {
        AssertionUtils.$nNull(sourceEntity, "Source entity cannot be null", new Object[0]);
        AssertionUtils.$nNull(sourceIdentifier, "Source entity identifier cannot be null", new Object[0]);
        AssertionUtils.$nNull(targetEntity, "Target entity cannot be null", new Object[0]);
        AssertionUtils.$nNull(targetIdentifier, "Target entity identifier cannot be null", new Object[0]);
        Collection sourceData = this.extractSourceData(sourceEntity, sourceIdentifier);
        Collection targetData = this.extractTargetData(targetEntity, targetIdentifier);
        boolean noSourceData = sourceData == null;
        boolean noTargetData = targetData == null;
        boolean emptySourceData = noSourceData || sourceData.isEmpty();
        boolean emptyTargetData = noTargetData || targetData.isEmpty();
        boolean dontPerformMatching = noSourceData && noTargetData;
        boolean assertNoMatch = emptySourceData || emptyTargetData;
        MatchingResult<Object, Object> result = this.newMatchingResult();
        if (dontPerformMatching) {
            result.setScore(MatchingScore.getNonPerformedTemplate());
            return result;
        }
        if (!assertNoMatch) {
            MatchingResult<Serializable, Serializable> temporaryResult = null;
            MatchingScore currentScore = null;
            for (Serializable currentSourceData : sourceData) {
                Iterator iterator = targetData.iterator();
                while (iterator.hasNext()) {
                    Serializable currentTargetData;
                    currentScore = currentSourceData == null && currentTargetData == null ? MatchingScore.getNonPerformedTemplate() : (currentSourceData == null || currentTargetData == null ? MatchingScore.getNonAuthoritativeNoMatchTemplate() : this._behaviour.updateScore(this.computeScore(sourceEntity, sourceIdentifier, currentSourceData, targetEntity, targetIdentifier, currentTargetData), sourceEntity, currentSourceData, targetEntity, currentTargetData));
                    temporaryResult = this.updateResult(new MatchingResult(this), currentScore, currentSourceData, sourceIdentifier, currentTargetData = (Serializable)iterator.next());
                    if (temporaryResult.isAuthoritative() && "AND".equals(this._combinationCriteria)) {
                        return temporaryResult;
                    }
                    if (temporaryResult.isNonPerformed()) continue;
                    if (Double.compare(temporaryResult.getScore().getValue(), result.getScore().getValue()) > 0) {
                        result = temporaryResult;
                        continue;
                    }
                    if (Double.compare(temporaryResult.getScore().getValue(), result.getScore().getValue()) != 0) continue;
                    MatchingResultData<Object, Object> matching = null;
                    if (result.containsMatchingFor(currentSourceData, sourceIdentifier) && currentTargetData != null) {
                        matching = result.getMatchingsResultDataFor(currentSourceData, sourceIdentifier);
                        matching.getMatchingTargetData().add(currentTargetData);
                    } else {
                        result.getMatchingsResultData().addAll(temporaryResult.getMatchingsResultData());
                    }
                    result.getScore().setMatchingType(temporaryResult.getScore().getMatchingType());
                }
            }
            return result;
        }
        if (this.isOptional()) {
            result.setScore(MatchingScore.getNonPerformedTemplate());
        } else {
            result.setScore(MatchingScore.getNonAuthoritativeNoMatchTemplate());
        }
        return result;
    }
}

