/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.io.providers.streaming.taf.protocols.classpath;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.fao.fi.comet.domain.species.tools.io.providers.streaming.taf.AbstractTAFSpeciesReferenceDataProvider;

public class ClasspathTAFStreamingSpeciesReferenceDataProvider
extends AbstractTAFSpeciesReferenceDataProvider {
    private static String CLASSPATH_PROTOCOL_ID = "classpath";
    private static String CLASSPATH_PROTOCOL = String.valueOf(CLASSPATH_PROTOCOL_ID) + ":///";
    private static URLStreamHandler CLASSPATH_URL_STREAM_HANDLER = new URLStreamHandler(){

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            URL resourceURL = Thread.currentThread().getContextClassLoader().getResource(u.getPath());
            if (resourceURL == null) {
                throw new FileNotFoundException(u.toExternalForm());
            }
            return resourceURL.openConnection();
        }
    };

    @Override
    public final String[] getManagedProtocols() {
        return new String[]{CLASSPATH_PROTOCOL};
    }

    @Override
    protected final URL getActualURL(String resourceURL) throws IOException {
        return new URL(CLASSPATH_PROTOCOL_ID, null, -1, resourceURL.substring(CLASSPATH_PROTOCOL.length()), CLASSPATH_URL_STREAM_HANDLER);
    }
}

