/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.process.matching;

import java.util.concurrent.Callable;
import org.fao.fi.comet.core.engine.process.handlers.MatchingProcessHandler;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessConfiguration;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessResult;
import org.fao.fi.comet.core.patterns.data.partitioners.DataPartitioner;
import org.fao.fi.comet.core.patterns.data.providers.DataProvider;
import org.fao.fi.comet.core.patterns.handlers.id.IDHandler;
import org.fao.fi.comet.core.uniform.engine.UMatchingEngineCore;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;

public class CallableEngine
implements Callable<MatchingEngineProcessResult<ReferenceSpeciesData, ReferenceSpeciesData, MatchingEngineProcessConfiguration>> {
    private final UMatchingEngineCore<ReferenceSpeciesData, MatchingEngineProcessConfiguration> _engine;
    private final MatchingEngineProcessConfiguration _conf;
    private final MatchingProcessHandler<ReferenceSpeciesData> _tracker;
    private final DataProvider<ReferenceSpeciesData> _sources;
    private final DataPartitioner<ReferenceSpeciesData, ReferenceSpeciesData> _partitioner;
    private final DataProvider<ReferenceSpeciesData> _targets;
    private final IDHandler<ReferenceSpeciesData, String> _sourceIDHandler;
    private final IDHandler<ReferenceSpeciesData, String> _targetIDHandler;

    public CallableEngine(UMatchingEngineCore<ReferenceSpeciesData, MatchingEngineProcessConfiguration> engine, MatchingEngineProcessConfiguration conf, MatchingProcessHandler<ReferenceSpeciesData> tracker, DataProvider<ReferenceSpeciesData> sources, DataPartitioner<ReferenceSpeciesData, ReferenceSpeciesData> partitioner, DataProvider<ReferenceSpeciesData> targets, IDHandler<ReferenceSpeciesData, String> sourceIDHandler, IDHandler<ReferenceSpeciesData, String> targetIDHandler) {
        this._engine = engine;
        this._conf = conf;
        this._tracker = tracker;
        this._sources = sources;
        this._partitioner = partitioner;
        this._targets = targets;
        this._sourceIDHandler = sourceIDHandler;
        this._targetIDHandler = targetIDHandler;
    }

    @Override
    public MatchingEngineProcessResult<ReferenceSpeciesData, ReferenceSpeciesData, MatchingEngineProcessConfiguration> call() throws Exception {
        try {
            MatchingEngineProcessResult<ReferenceSpeciesData, ReferenceSpeciesData, MatchingEngineProcessConfiguration> matchingEngineProcessResult = this._engine.compareAll(this._conf, this._tracker, this._sources, this._partitioner, this._targets, this._sourceIDHandler, this._targetIDHandler);
            return matchingEngineProcessResult;
        }
        finally {
            this._targets.releaseResources();
        }
    }
}

