/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.process.results.cli;

import java.io.File;
import org.fao.fi.comet.core.model.common.TypedComplexName;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessConfiguration;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessResult;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessorInfo;
import org.fao.fi.comet.domain.species.model.InputSpeciesData;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.vrmf.core.helpers.beans.io.file.FileUtils;
import org.fao.vrmf.core.helpers.singletons.text.xml.JAXBUtils;
import org.fao.vrmf.core.helpers.singletons.text.xml.XMLBuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessResultsMerger {
    private static String VERSION = "1.2.0";
    private final FileUtils _fileUtils = new FileUtils();

    private MatchingEngineProcessResult<ReferenceSpeciesData, ReferenceSpeciesData, MatchingEngineProcessConfiguration> deserialize(String fileName) throws Throwable {
        File file = new File(fileName);
        String fileContent = this._fileUtils.fetchUTF8TextFile(file.getParentFile(), file.getName());
        return JAXBUtils.fromXML(MatchingEngineProcessResult.class, fileContent);
    }

    private void serialize(MatchingEngineProcessResult<ReferenceSpeciesData, ReferenceSpeciesData, MatchingEngineProcessConfiguration> data, String fileName) throws Throwable {
        File file = new File(fileName);
        String xml = JAXBUtils.toXML(new Class[]{InputSpeciesData.class, ReferenceSpeciesData.class, TypedComplexName.class}, data, JAXBUtils.OMIT_XML_DECLARATION);
        this._fileUtils.storeFile(file.getParentFile(), file.getName(), XMLBuilderUtils.prettyPrint(xml).getBytes("UTF-8"));
    }

    public static final void main(String[] args) throws Throwable {
        if (args == null || args.length <= 1) {
            System.out.println("Usage: java " + ProcessResultsMerger.class.getCanonicalName() + " <output file> <input file> <input file> ...");
            System.exit(0);
        }
        Logger log = LoggerFactory.getLogger(ProcessResultsMerger.class);
        log.info("### YASMEEN - {} v{} - process results file merger for species matching data", (Object)ProcessResultsMerger.class.getSimpleName(), (Object)VERSION);
        try {
            String out = args[0];
            MatchingEngineProcessResult<ReferenceSpeciesData, ReferenceSpeciesData, MatchingEngineProcessConfiguration> joined = null;
            ProcessResultsMerger merger = new ProcessResultsMerger();
            int i = 1;
            while (i < args.length) {
                log.info("Loading and merging process results file {}", (Object)args[i]);
                joined = joined == null ? merger.deserialize(args[i]) : joined.join(merger.deserialize(args[i]));
                ++i;
            }
            int maxCandidates = Integer.MAX_VALUE;
            double minScore = Double.MIN_VALUE;
            log.info("Identifying final values for maximum numer of candidates and minimum weighted score threshold ...");
            for (MatchingEngineProcessorInfo processorInfo : joined.getProcessorsInfo()) {
                Object configuration = processorInfo.getConfiguration();
                Integer curMaxCandidates = ((MatchingEngineProcessConfiguration)configuration).getMaxCandidatesPerEntry();
                Double curMinScore = ((MatchingEngineProcessConfiguration)configuration).getMinimumAllowedWeightedScore();
                if (curMaxCandidates != null && curMaxCandidates > 0) {
                    maxCandidates = Math.min(maxCandidates, curMaxCandidates);
                }
                if (curMinScore == null) continue;
                minScore = Math.max(minScore, curMinScore);
            }
            log.info("Final value for minimum weighted score threshold has been identified as: {}", (Object)minScore);
            log.info("Final value for maximum number of candidates has been identified as: {}", (Object)maxCandidates);
            log.info("Cleaning up merged results...");
            joined.getResults().cleanup(maxCandidates, minScore);
            log.info("Serializing data...");
            merger.serialize(joined, out);
            log.info("Merged process results have been stored under: {}", (Object)out);
        }
        catch (Throwable t) {
            log.error("{} : aborting...", (Object)t.getMessage());
        }
    }
}

