/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.topology.impl;

import javax.xml.bind.annotation.XmlAttribute;
import org.fao.vrmf.core.helpers.singletons.lang.classes.ClassUtils;
import org.fao.vrmf.core.tools.topology.behaviours.WeightValue;

public class SimpleWeightValue
implements WeightValue {
    private static final long serialVersionUID = -5634760715222609876L;
    @XmlAttribute(name="value")
    private final double _weight;

    public SimpleWeightValue(double weight) {
        this._weight = weight;
    }

    @Override
    public int compareTo(WeightValue o) {
        return Double.compare(this._weight, o.toDouble());
    }

    @Override
    public double toDouble() {
        return this._weight;
    }

    @Override
    public WeightValue multiply(WeightValue another) {
        return new SimpleWeightValue(this._weight * another.toDouble());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._weight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleWeightValue other = (SimpleWeightValue)obj;
        return Double.doubleToLongBits(this._weight) == Double.doubleToLongBits(other._weight);
    }

    public String toString() {
        return String.valueOf(ClassUtils.getSimpleClassNameForObject(this)) + ":" + this._weight;
    }
}

