/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.model.engine;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.fao.fi.comet.core.model.engine.Matching;
import org.fao.fi.comet.core.model.engine.MatchingDetails;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessConfiguration;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessorInfo;
import org.fao.fi.comet.core.model.engine.MatchingsData;
import org.fao.vrmf.core.extensions.collections.impl.ListSet;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

@XmlRootElement(name="MatchingEngineProcessResult")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MatchingEngineProcessResult<SOURCE, TARGET, CONFIG extends MatchingEngineProcessConfiguration>
implements Serializable {
    private static final long serialVersionUID = 1369256622240246122L;
    @XmlElementWrapper(name="ProcessorsInfo")
    @XmlElement(name="ProcessorInfo")
    private Collection<MatchingEngineProcessorInfo<CONFIG>> _processorsInfo = new ListSet<MatchingEngineProcessorInfo<CONFIG>>();
    @XmlElement(name="Results")
    private MatchingsData<SOURCE, TARGET> _results;

    public MatchingEngineProcessResult() {
    }

    public MatchingEngineProcessResult(MatchingEngineProcessorInfo<CONFIG> processorInfo, MatchingsData<SOURCE, TARGET> results) {
        this();
        AssertionUtils.$nNull(processorInfo, "The processor info cannot be NULL", new Object[0]);
        this._processorsInfo.add(processorInfo);
        this._results = results;
        if (results != null) {
            for (MatchingDetails<SOURCE, TARGET> detail : results.getMatchingDetails()) {
                if (detail == null) continue;
                for (Matching<SOURCE, TARGET> matching : detail.getMatchings()) {
                    matching.setProcessID(processorInfo.getProcessID());
                }
            }
        }
    }

    public Collection<MatchingEngineProcessorInfo<CONFIG>> getProcessorsInfo() {
        return this._processorsInfo;
    }

    public void setProcessorsInfo(Collection<MatchingEngineProcessorInfo<CONFIG>> processorsInfo) {
        this._processorsInfo = processorsInfo;
    }

    public MatchingsData<SOURCE, TARGET> getResults() {
        return this._results;
    }

    public void setResults(MatchingsData<SOURCE, TARGET> results) {
        AssertionUtils.$nNull(results, "Please provide a non-null reference to matchings data", new Object[0]);
        this._results = results;
    }

    public MatchingEngineProcessResult<SOURCE, TARGET, CONFIG> join(MatchingEngineProcessResult<SOURCE, TARGET, CONFIG> another) {
        AssertionUtils.$nNull(another, "Provided matching engine process result cannot be null", new Object[0]);
        AssertionUtils.$nNull(another._processorsInfo, "Provided matching engine process info cannot be null", new Object[0]);
        this._processorsInfo.addAll(another._processorsInfo);
        this._results = this._results.join(another._results);
        return this;
    }
}

