/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.patterns.data.providers.impl.multiple;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.fao.fi.comet.core.patterns.data.providers.DataProvider;
import org.fao.fi.comet.core.patterns.data.providers.ProvidedData;
import org.fao.fi.comet.core.patterns.data.providers.impl.DataProviderSkeleton;
import org.fao.fi.comet.core.patterns.data.providers.impl.support.MultipleDataProvidersIterator;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

public abstract class MultipleDataProviderSkeleton<ENTITY extends Serializable, PROVIDER extends DataProvider<ENTITY>>
extends DataProviderSkeleton<ENTITY> {
    protected List<PROVIDER> _dataProviders;

    public MultipleDataProviderSkeleton(PROVIDER ... dataProviders) {
        this(null, (DataProvider[])dataProviders);
    }

    public MultipleDataProviderSkeleton(String providerId, PROVIDER ... dataProviders) {
        if (providerId != null) {
            this.setProviderID(providerId);
        }
        AssertionUtils.$nNull(dataProviders, "Data providers cannot be null", new Object[0]);
        AssertionUtils.$nEm(dataProviders, "Data providers cannot be empty", new Object[0]);
        PROVIDER[] PROVIDERArray = dataProviders;
        int n = dataProviders.length;
        int n2 = 0;
        while (n2 < n) {
            PROVIDER provider = PROVIDERArray[n2];
            AssertionUtils.$nNull(provider, "Cannot handle a NULL data provider", new Object[0]);
            ++n2;
        }
        this._dataProviders = Arrays.asList(dataProviders);
    }

    @Override
    public Iterator<ProvidedData<ENTITY>> iterator() {
        return new MultipleDataProvidersIterator(this._dataProviders);
    }

    @Override
    protected void doReleaseResources() throws Exception {
        for (DataProvider provider : this._dataProviders) {
            provider.releaseResources();
        }
    }
}

