/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species;

import java.util.List;
import org.fao.fi.comet.core.model.common.LinkedTypedComplexName;
import org.fao.fi.comet.domain.species.model.VernacularNameData;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.fao.vrmf.core.tools.lexical.processors.LexicalProcessor;
import org.fao.vrmf.core.tools.lexical.soundex.PhraseSoundexGenerator;

public class VernacularNamesFactory {
    public static final String VERNACULAR_CNAME_PREFIX = "vernacular_";
    public static final String UNKNOWN_LANGUAGE = "UNKNOWN";

    public static VernacularNameData newInstance(String parentId, String language, String locality, String name) {
        VernacularNameData data = new VernacularNameData();
        data.setParentId(parentId);
        data.setLanguage(language);
        data.setLocality(locality);
        data.setName(name);
        return data;
    }

    public static LinkedTypedComplexName toComplexName(VernacularNameData data, LexicalProcessor processor, PhraseSoundexGenerator soundexer) {
        LinkedTypedComplexName toReturn = new LinkedTypedComplexName();
        toReturn.setParentId(data.getParentId());
        toReturn.setName(data.getName());
        toReturn.setType(VERNACULAR_CNAME_PREFIX + data.getLanguage());
        toReturn.setSimplifiedName(processor.process(data.getName()));
        if (toReturn.getSimplifiedName() != null) {
            List<String> nGrams = StringUtils.extractPhraseNGrams(3, toReturn.getSimplifiedName(), true);
            toReturn.setSimplifiedNameNGrams(nGrams.toArray(new String[nGrams.size()]));
        }
        toReturn.setSimplifiedNameSoundex(soundexer.getFullPhraseSoundex(toReturn.getSimplifiedName(), false));
        toReturn.setSimplifiedNameSoundexParts(toReturn.getSimplifiedNameSoundex() == null ? null : toReturn.getSimplifiedNameSoundex().split("\\s"));
        return toReturn;
    }
}

