/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.matchlets.extended.support;

import java.io.Serializable;
import java.util.Arrays;
import org.fao.fi.comet.core.model.common.TypedComplexName;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.core.model.support.MatchingType;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

public final class CNamesScoreCalculator
implements Serializable {
    private static final long serialVersionUID = 3412964792752998737L;
    private static final String[] NO_TRIGRAMS = new String[0];

    public MatchingScore computeScore(double levenshteinWeight, double soundexWeight, double trigramWeight, ReferenceSpeciesData source, DataIdentifier sourceIdentifier, TypedComplexName sourceData, ReferenceSpeciesData target, DataIdentifier targetIdentifier, TypedComplexName targetData) {
        String simplifiedTargetName;
        String targetName;
        boolean checkLevenshtein = Double.compare(levenshteinWeight, 0.0) > 0;
        boolean checkSoundex = Double.compare(soundexWeight, 0.0) > 0;
        boolean checkTrigrams = Double.compare(trigramWeight, 0.0) > 0;
        boolean onlySoundex = checkSoundex && !checkLevenshtein && !checkTrigrams;
        boolean onlyLevenshtein = checkLevenshtein && !checkSoundex && !checkTrigrams;
        boolean onlyTrigrams = checkTrigrams && !checkLevenshtein && !checkSoundex;
        double trigramScore = 0.0;
        double soundexScore = 0.0;
        double levenshteinScore = 0.0;
        double simplifiedLevenshteinScore = 0.0;
        double currentScore = 0.0;
        String sourceName = sourceData.getName();
        if (sourceName.equalsIgnoreCase(targetName = targetData.getName())) {
            return MatchingScore.getNonAuthoritativeFullMatchTemplate();
        }
        String simplifiedSourceName = sourceData.getSimplifiedName();
        if (simplifiedSourceName.equalsIgnoreCase(simplifiedTargetName = targetData.getSimplifiedName())) {
            return MatchingScore.getNonAuthoritativeFullMatchTemplate();
        }
        if (checkLevenshtein) {
            levenshteinScore = simplifiedLevenshteinScore = StringUtils.computeRelativeSimilarity(simplifiedSourceName, simplifiedTargetName);
        }
        if (checkSoundex) {
            String[] firstNameSoundexParts = sourceData.getSimplifiedNameSoundexParts();
            String[] secondNameSoundexParts = targetData.getSimplifiedNameSoundexParts();
            int firstNameSoundexPartsSize = firstNameSoundexParts == null ? 0 : firstNameSoundexParts.length;
            int secondNameSoundexPartsSize = secondNameSoundexParts == null ? 0 : secondNameSoundexParts.length;
            boolean switchFirstAndSecond = firstNameSoundexPartsSize < secondNameSoundexPartsSize;
            int partsNum = 0;
            double max = 0.0;
            double current = 0.0;
            double total = 0.0;
            if (firstNameSoundexParts != null && secondNameSoundexParts != null) {
                String[] stringArray = switchFirstAndSecond ? secondNameSoundexParts : firstNameSoundexParts;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String fPart = stringArray[n2];
                    String[] stringArray2 = switchFirstAndSecond ? firstNameSoundexParts : secondNameSoundexParts;
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String sPart = stringArray2[n4];
                        current = StringUtils.computeRelativeSimilarity(fPart, sPart);
                        double factor = 1.0 * (double)(switchFirstAndSecond ? fPart.length() : sPart.length()) / (double)Math.max(sPart.length(), fPart.length());
                        AssertionUtils.$gte(factor, 0.0, "The soundex parts factor must be greater than (or equal to) 0.0 (currently: {})", factor);
                        AssertionUtils.$lte(factor, 1.0, "The soundex parts factor must be lower than (or equal to) 1.0 (currently: {})", factor);
                        current *= factor;
                        if (current > max) {
                            max = current;
                        }
                        ++n4;
                    }
                    total += max;
                    max = 0.0;
                    ++n2;
                }
            }
            soundexScore = total /= (partsNum = Math.max(firstNameSoundexPartsSize, secondNameSoundexPartsSize)) == 0 ? 1.0 : (double)partsNum;
        }
        if (checkTrigrams) {
            trigramScore = StringUtils.calculateNGramsSimilarityScore(Arrays.asList((String[])ObjectsUtils.coalesce(sourceData.getSimplifiedNameNGrams(), NO_TRIGRAMS)), Arrays.asList((String[])ObjectsUtils.coalesce(targetData.getSimplifiedNameNGrams(), NO_TRIGRAMS)));
        }
        currentScore = onlyLevenshtein ? levenshteinScore : (onlySoundex ? soundexScore : (onlyTrigrams ? trigramScore : (levenshteinWeight * levenshteinScore + soundexWeight * soundexScore + trigramWeight * trigramScore) / (levenshteinWeight + soundexWeight + trigramWeight)));
        return new MatchingScore(currentScore, MatchingType.NON_AUTHORITATIVE);
    }
}

