/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.io.readers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTextFileReader {
    protected static Logger LOG = LoggerFactory.getLogger(BasicTextFileReader.class);
    public static boolean SKIP_EMPTY_LINES = true;
    public static boolean KEEP_EMPTY_LINES = !SKIP_EMPTY_LINES;
    public static int UNLIMITED_LINES = -1;

    public String[] readLines(File input, int numLinesToRead, boolean skipEmptyLines) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        FileInputStream is = new FileInputStream(input);
        InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        int numNonEmptyLines = 0;
        int numLines = 0;
        while ((line = br.readLine()) != null) {
            if ((line = StringUtils.rawTrim(line)) == null) {
                if (skipEmptyLines == KEEP_EMPTY_LINES) {
                    lines.add("");
                }
            } else {
                lines.add(line);
                ++numNonEmptyLines;
            }
            if (numLinesToRead != UNLIMITED_LINES && (skipEmptyLines && numNonEmptyLines == numLinesToRead || !skipEmptyLines && numLines == numLinesToRead)) break;
            ++numLines;
        }
        br.close();
        isr.close();
        ((InputStream)is).close();
        LOG.info("Read {} non empty lines out of {} total lines in {}", new Object[]{numNonEmptyLines, numLines, input.getAbsolutePath()});
        return lines.toArray(new String[lines.size()]);
    }

    public String[] readLines(File input, boolean skipEmptyLines) throws IOException {
        return this.readLines(input, UNLIMITED_LINES, skipEmptyLines);
    }

    public String read(File input, boolean skipEmptyLines) throws IOException {
        String line;
        FileInputStream is = new FileInputStream(input);
        InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        int numNonEmptyLines = 0;
        int numLines = 0;
        StringBuilder result = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if ((line = StringUtils.rawTrim(line)) == null) {
                if (skipEmptyLines == KEEP_EMPTY_LINES) {
                    result.append("\n");
                }
            } else {
                result.append(line).append("\n");
                ++numNonEmptyLines;
            }
            ++numLines;
        }
        br.close();
        isr.close();
        ((InputStream)is).close();
        LOG.info("Read {} non empty lines out of {} total lines in {}", new Object[]{numNonEmptyLines, numLines, input.getAbsolutePath()});
        return result.toString();
    }
}

