/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.lexical.processors;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.fao.vrmf.core.tools.lexical.processors.LexicalProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LexicalProcessorsUtils {
    static final Logger LOG = LoggerFactory.getLogger(LexicalProcessorsUtils.class);

    public static final <L extends LexicalProcessor> L getProcessor(Class<L> processorType) {
        ServiceLoader<L> loader = ServiceLoader.load(processorType);
        Iterator<L> iterator = loader.iterator();
        if (iterator.hasNext()) {
            LexicalProcessor processor = (LexicalProcessor)iterator.next();
            LOG.info("[ SYSTEM ] : Using {} as actual implementation of service {}", (Object)processor.getClass().getName(), (Object)processorType.getName());
            return (L)processor;
        }
        throw new IllegalArgumentException("No service of type '" + processorType.getName() + "' can be loaded from the classpath");
    }
}

