/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.extras.matchlets.common.behaviours;

import java.io.Serializable;
import org.fao.fi.comet.core.matchlets.skeleton.behaviours.BasicBehaviour;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.extras.matchlets.helpers.TimeDistanceHelper;
import org.fao.fi.comet.extras.matchlets.helpers.ValueDistanceHelper;
import org.fao.vrmf.core.behaviours.data.DateReferenced;
import org.fao.vrmf.core.behaviours.data.Valued;
import org.fao.vrmf.core.extensions.date.TimeResolutionUnit;

public class TimeAndValueDistanceAwareBehaviour<SOURCE extends Serializable, SOURCE_DATA extends DateReferenced & Valued<? extends Number>, TARGET extends Serializable, TARGET_DATA extends DateReferenced & Valued<? extends Number>>
extends BasicBehaviour<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> {
    private static final long serialVersionUID = -8218136145191518357L;
    protected final long _absoluteMaximumTimeDistance;
    protected final TimeResolutionUnit _timeResolutionUnit;
    protected final double _maximumRelativeValueDistance;
    private final TimeDistanceHelper _timeHelper = new TimeDistanceHelper();
    private final ValueDistanceHelper<Valued<? extends Number>> _valueHelper = new ValueDistanceHelper();

    public TimeAndValueDistanceAwareBehaviour(long absoluteMaximumTimeDistance, TimeResolutionUnit timeResolutionUnit, double maximumRelativeValueDistance) {
        assert (timeResolutionUnit != null) : "Provided time resolution unit cannot be null";
        assert (Double.compare(absoluteMaximumTimeDistance, 0.0) > 0) : "The absolute maximum time distance cannot be zero or lower (currently: " + absoluteMaximumTimeDistance + ")";
        assert (Double.compare(maximumRelativeValueDistance, 0.0) >= 0) : "The maximum relative value distance cannot be lower than zero (currently: " + maximumRelativeValueDistance + ")";
        assert (Double.compare(maximumRelativeValueDistance, 0.0) <= 1) : "The maximum relative value distance cannot be higher than one (currently: " + maximumRelativeValueDistance + ")";
        this._absoluteMaximumTimeDistance = absoluteMaximumTimeDistance;
        this._timeResolutionUnit = timeResolutionUnit;
        this._maximumRelativeValueDistance = maximumRelativeValueDistance;
    }

    @Override
    protected MatchingScore doUpdateScore(MatchingScore current, SOURCE_DATA sourceData, TARGET_DATA targetData) {
        MatchingScore updated = new MatchingScore(current);
        Long timeDistance = this._timeHelper.getTimeDistance(sourceData.getReferenceDate(), targetData.getReferenceDate(), this._timeResolutionUnit);
        if (timeDistance == null || timeDistance > this._absoluteMaximumTimeDistance) {
            updated = MatchingScore.getNonAuthoritativeNoMatchTemplate();
        } else {
            double relativeTimeDistance = (double)timeDistance.longValue() * 1.0 / (double)this._absoluteMaximumTimeDistance;
            updated.setValue(updated.getValue() * (1.0 - relativeTimeDistance));
            if (this.continueComparison(updated)) {
                Double relativeValueDistance = this._valueHelper.getRelativeValueDistance((Valued<? extends Number>)sourceData, (Valued<? extends Number>)targetData);
                if (relativeValueDistance == null || Double.compare(relativeValueDistance, this._maximumRelativeValueDistance) > 0) {
                    updated = MatchingScore.getNonAuthoritativeNoMatchTemplate();
                } else {
                    updated.setValue(updated.getValue() * (1.0 - relativeValueDistance));
                }
            }
        }
        return updated;
    }
}

