/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.extras.matchlets.helpers;

import java.util.Arrays;
import java.util.TreeSet;
import org.fao.fi.comet.core.matchlets.skeleton.helpers.StringComparisonHelperSkeleton;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.core.model.support.MatchingType;
import org.fao.vrmf.core.behaviours.data.composite.ComplexNameAware;

public final class SmartNameAbsoluteDistanceHelper<DATA extends ComplexNameAware>
extends StringComparisonHelperSkeleton {
    private static final long serialVersionUID = 8494565119229131253L;

    public MatchingScore computeScore(double nameWeight, double simplifiedNameWeight, double soundexWeight, int maximumDistance, DATA firstData, DATA secondData) {
        assert (Double.compare(nameWeight, 0.0) >= 0) : "The name weight cannot be lower than zero";
        assert (Double.compare(simplifiedNameWeight, 0.0) >= 0) : "The simplified name weight cannot be lower than zero";
        assert (Double.compare(soundexWeight, 0.0) >= 0) : "The soundex weight cannot be lower than zero";
        assert (maximumDistance >= 0) : "The maximum distance cannot be lower than zero";
        String firstName = firstData.getName();
        String secondName = secondData.getName();
        String simplifiedFirstName = firstData.getSimplifiedName();
        String simplifiedSecondName = secondData.getSimplifiedName();
        String firstNameSoundex = firstData.getSimplifiedNameSoundex();
        String secondNameSoundex = secondData.getSimplifiedNameSoundex();
        if (firstName == null && secondName == null) {
            return MatchingScore.getNonPerformedTemplate();
        }
        if (firstName == null || secondName == null) {
            return MatchingScore.getNonAuthoritativeNoMatchTemplate();
        }
        double totalWeight = nameWeight;
        double lambda = 0.0;
        if (firstName.equalsIgnoreCase(secondName)) {
            return MatchingScore.getNonAuthoritativeFullMatchTemplate();
        }
        lambda = nameWeight * super.compareStrings(firstName, secondName, maximumDistance, true, true).getValue();
        if (simplifiedFirstName != null && simplifiedSecondName != null) {
            totalWeight += simplifiedNameWeight;
            if (simplifiedFirstName.equalsIgnoreCase(simplifiedSecondName)) {
                return new MatchingScore((lambda + 1.0 * simplifiedNameWeight) / totalWeight, MatchingType.NON_AUTHORITATIVE);
            }
            lambda += simplifiedNameWeight * super.compareStrings(simplifiedFirstName, simplifiedSecondName, maximumDistance, true, true).getValue();
            totalWeight += soundexWeight;
            if (firstNameSoundex.equalsIgnoreCase(secondNameSoundex)) {
                return new MatchingScore((lambda + 1.0 * soundexWeight) / totalWeight, MatchingType.NON_AUTHORITATIVE);
            }
            TreeSet<String> firstNameSoundexParts = new TreeSet<String>(Arrays.asList(firstNameSoundex.split("\\s")));
            TreeSet<String> secondNameSoundexParts = new TreeSet<String>(Arrays.asList(secondNameSoundex.split("\\s")));
            int partMatchings = 0;
            for (String firstPart : firstNameSoundexParts) {
                if (!secondNameSoundexParts.contains(firstPart)) continue;
                ++partMatchings;
            }
            lambda += soundexWeight * ((double)partMatchings * 1.0 / (double)firstNameSoundexParts.size());
        }
        return new MatchingScore(lambda / totalWeight, MatchingType.NON_AUTHORITATIVE);
    }
}

