/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.impl.design.patterns.cache;

import org.fao.vrmf.core.behaviours.design.patterns.cache.CacheFacade;
import org.fao.vrmf.core.impl.design.patterns.cache.AbstractCacheEventListener;

public class SysOutCacheEventListener<K, V>
extends AbstractCacheEventListener<K, V> {
    private static final long serialVersionUID = 8725421299298683843L;

    public SysOutCacheEventListener(CacheFacade<K, V> cache) {
        super(cache);
    }

    @Override
    public void entryAdded(CacheFacade<K, V> cache, K key, V value) {
        System.out.println("Entry added for cache " + cache.getCacheID() + " (Key: " + key + ", Value: " + value + ")");
    }

    @Override
    public void entryUpdated(CacheFacade<K, V> cache, K key, V oldValue, V newValue) {
        System.out.println("Entry updated for cache " + cache.getCacheID() + " (Key: " + key + ", Old value: " + oldValue + ", New value: " + newValue + ")");
    }

    @Override
    public void entryRemoved(CacheFacade<K, V> cache, K key, V value) {
        System.out.println("Entry removed for cache " + cache.getCacheID() + " (Key: " + key + ", Value: " + value + ")");
    }

    @Override
    public void entryEvicted(CacheFacade<K, V> cache, K key, V value) {
        System.out.println("Entry evicted for cache " + cache.getCacheID() + " (Key: " + key + ", Value: " + value + ")");
    }

    @Override
    public void entryExpired(CacheFacade<K, V> cache, K key, V value) {
        System.out.println("Entry expired for cache " + cache.getCacheID() + " (Key: " + key + ", Value: " + value + ")");
    }

    @Override
    public void cacheCleared(CacheFacade<K, V> cache) {
        System.out.println("Cache cleared for cache " + cache.getCacheID());
    }
}

