/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.models.gis;

import java.io.Serializable;

public class Coordinates
implements Serializable {
    private static final long serialVersionUID = 3861345116604046251L;
    public static final String NORTH_MARKER = "N";
    public static final String SOUTH_MARKER = "S";
    public static final String EAST_MARKER = "E";
    public static final String WEST_MARKER = "W";
    public static final boolean DECIMAL_COORDINATES = true;
    public static final boolean DEGREES_COORDINATES = false;
    public static final double DEGREES_TO_DECIMAL = 1.6666666666666667;
    public static final double DECIMAL_TO_DEGREES = 0.6;
    public static final double DEGREES_TO_RADIANS = Math.PI / 180;
    public static final double RADIANS_TO_DEGREES = 57.29577951308232;
    public static final double EARTH_RADIUS_IN_KILOMETERS = 6378.7;
    public static final double EARTH_RADIUS_IN_MILES = 3963.0;
    public static final double EARTH_RADIUS_IN_NAUTICAL_MILES = 3437.74677;
    private double _latitude;
    private double _longitude;

    public Coordinates(double latitude, double longitude) {
        this(latitude, longitude, false);
    }

    public Coordinates(String latitude, String longitude) {
        this(latitude, longitude, false);
    }

    public Coordinates(String latitude, String longitude, boolean decimalCoordinates) {
        double lat = Coordinates.latitudeFromString(latitude);
        double lon = Coordinates.longitudeFromString(longitude);
        this.setLatitude(decimalCoordinates ? this.convertFromDecimalCoordinate(lat) : lat);
        this.setLongitude(decimalCoordinates ? this.convertFromDecimalCoordinate(lon) : lon);
    }

    public Coordinates(Coordinates another) {
        this(another._latitude, another._longitude);
    }

    public Coordinates(double latitude, double longitude, boolean decimalCoordinates) {
        this._latitude = decimalCoordinates ? this.convertFromDecimalCoordinate(latitude) : latitude;
        this._longitude = decimalCoordinates ? this.convertFromDecimalCoordinate(longitude) : longitude;
    }

    public Coordinates(Coordinates another, boolean decimalCoordinates) {
        this(another._latitude, another._longitude, decimalCoordinates);
    }

    public Coordinates toDecimal() {
        return new Coordinates(this, true);
    }

    public Coordinates toDegrees() {
        return new Coordinates(this, false);
    }

    public double getLatitude() {
        return this._latitude;
    }

    public String getLatitudeAsString() {
        return this.getLatitudeAsString(2, 2);
    }

    public String getLatitudeAsString(int numInteger, int numDecimal) {
        String latMark = this._latitude <= 0.0 ? SOUTH_MARKER : NORTH_MARKER;
        return String.valueOf(this.pad(String.valueOf(Math.abs(this._latitude)), numInteger, numDecimal)) + latMark;
    }

    public String getLongitudeAsString() {
        return this.getLongitudeAsString(3, 2);
    }

    public String getLongitudeAsString(int numInteger, int numDecimal) {
        String lonMark = this._longitude <= 0.0 ? WEST_MARKER : EAST_MARKER;
        return String.valueOf(this.pad(String.valueOf(Math.abs(this._longitude)), numInteger, numDecimal)) + lonMark;
    }

    public void setLatitude(double latitude) {
        this._latitude = latitude;
    }

    public double getLongitude() {
        return this._longitude;
    }

    public void setLongitude(double longitude) {
        this._longitude = longitude;
    }

    public double distanceTo(Coordinates target) {
        double latDist = this._latitude - target._latitude;
        double lonDist = this._longitude - target._longitude;
        return Math.sqrt(Math.pow(latDist, 2.0) + Math.pow(lonDist, 2.0));
    }

    public double distanceInKilometersTo(Coordinates target) {
        return this.distanceTo(target, 6378.7);
    }

    public double distanceInMilesTo(Coordinates target) {
        return this.distanceTo(target, 3963.0);
    }

    public double distanceInNauticalMilesTo(Coordinates target) {
        return this.distanceTo(target, 3437.74677);
    }

    private double distanceTo(Coordinates target, double earthRadius) {
        double lat1 = this._latitude;
        double lat2 = target._latitude;
        double lon1 = this._longitude;
        double lon2 = target._longitude;
        if (Double.compare(lat1, lat2) == 0 && Double.compare(lon1, lon2) == 0) {
            return 0.0;
        }
        double distance = earthRadius * Math.acos(Math.sin(lat1 * (Math.PI / 180)) * Math.sin(lat2 * (Math.PI / 180)) + Math.cos(lat1 * (Math.PI / 180)) * Math.cos(lat2 * (Math.PI / 180)) * Math.cos((lon2 - lon1) * (Math.PI / 180)));
        if (Double.isNaN(distance)) {
            return 0.0;
        }
        return distance;
    }

    private double convertFromDecimalCoordinate(double decimalCoordinate) {
        double signum = Math.signum(decimalCoordinate);
        double integerPart = Math.floor(Math.abs(decimalCoordinate));
        double decimalPart = Math.abs(decimalCoordinate) - integerPart;
        return signum * (integerPart + decimalPart * 0.6);
    }

    public static double convertToDecimalCoordinate(double coordinate) {
        double signum = Math.signum(coordinate);
        double integerPart = Math.floor(Math.abs(coordinate));
        double decimalPart = Math.abs(coordinate) - integerPart;
        return signum * (integerPart + decimalPart * 1.6666666666666667);
    }

    public static Double latitudeFromString(String latitude) {
        return Coordinates.coordinateFromString(latitude, SOUTH_MARKER.charAt(0));
    }

    public static Double longitudeFromString(String longitude) {
        return Coordinates.coordinateFromString(longitude, WEST_MARKER.charAt(0));
    }

    private static Double coordinateFromString(String coordinate, char negativeSignumChar) {
        if (coordinate == null) {
            return null;
        }
        double coordinateSignum = coordinate.toUpperCase().contains(String.valueOf(Character.toUpperCase(negativeSignumChar))) ? -1 : 1;
        return coordinateSignum * Double.parseDouble(coordinate.replaceAll("[a-zA-Z]", ""));
    }

    private String pad(String toPad, int numIntegerDigits, int numDecimalDigits) {
        double pow = Math.pow(10.0, numDecimalDigits);
        double invPow = Math.pow(10.0, -numDecimalDigits);
        StringBuffer zeroPad = new StringBuffer();
        while (zeroPad.length() < numDecimalDigits) {
            zeroPad.append("0");
        }
        double value = Double.parseDouble(toPad);
        double decimal = (double)Math.round((value - Math.floor(value)) * pow) * invPow;
        long integer = Math.round(Math.floor(value));
        StringBuffer toReturn = new StringBuffer(String.valueOf(integer));
        while (toReturn.length() < numIntegerDigits) {
            toReturn.insert(0, "0");
        }
        toReturn.append(".");
        toReturn.append(String.valueOf(decimal).replaceAll("0E\\-\\d\\+", zeroPad.toString()).substring(2, Math.min(2 + numDecimalDigits, String.valueOf(decimal).length())));
        while (toReturn.length() < 1 + numIntegerDigits + numDecimalDigits) {
            toReturn.append("0");
        }
        return toReturn.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this._longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Coordinates)) {
            return false;
        }
        Coordinates other = (Coordinates)obj;
        if (Double.doubleToLongBits(this._latitude) != Double.doubleToLongBits(other._latitude)) {
            return false;
        }
        return Double.doubleToLongBits(this._longitude) == Double.doubleToLongBits(other._longitude);
    }

    public boolean oldEquals(Object another) {
        if (another == null || !Coordinates.class.isAssignableFrom(another.getClass())) {
            return false;
        }
        return this.toString().equals(another.toString());
    }

    public String toString() {
        return String.valueOf(this.getLatitudeAsString()) + " " + this.getLongitudeAsString();
    }
}

