/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.topology.helpers;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.fao.vrmf.core.behaviours.data.Mappable;
import org.fao.vrmf.core.tools.topology.GraphNode;
import org.fao.vrmf.core.tools.topology.WeightedGraph;
import org.fao.vrmf.core.tools.topology.WeightedGraphLink;
import org.fao.vrmf.core.tools.topology.helpers.NonTransitiveMappedDataManager;

public class TransitiveMappedDataManager<I extends Serializable, M extends Mappable<I>>
extends NonTransitiveMappedDataManager<I, M> {
    private static final long serialVersionUID = 8854974003205440072L;

    public TransitiveMappedDataManager() {
    }

    public TransitiveMappedDataManager(WeightedGraph<I> graph) {
        super(graph);
    }

    public TransitiveMappedDataManager(Collection<M> data) {
        super(data);
    }

    public TransitiveMappedDataManager(Collection<M> mappedData, boolean checkCyclesOnGraphBuild) {
        super.safelyAddMappedData(mappedData, checkCyclesOnGraphBuild);
    }

    @Override
    public final boolean maps(M source, M target) {
        assert (source != null) : "Source cannot be null";
        if (target == null || target.getId() == null) {
            return false;
        }
        return this.maps((I)source.getId(), (I)target.getId());
    }

    @Override
    public final boolean maps(I sourceID, I targetID) {
        assert (sourceID != null) : "Source ID cannot be null";
        assert (targetID != null) : "Target ID cannot be null";
        return this.maps(new GraphNode<I>(sourceID), new GraphNode<I>(targetID), this._graph, new HashSet<GraphNode<I>>());
    }

    @Override
    protected final boolean maps(GraphNode<I> source, GraphNode<I> target, WeightedGraph<I> graph, Set<GraphNode<I>> visitedNodes) {
        return super.maps(source, target, graph, visitedNodes) || super.maps(source, target, graph.getReversedGraph(), visitedNodes);
    }

    @Override
    public final synchronized Set<I> mappedNodes(I sourceNodeID) {
        TreeSet mapped = new TreeSet();
        GraphNode<I> node = this._graph.getNodeByIndex(sourceNodeID);
        if (node == null) {
            node = this._graph.getReversedGraph().getNodeByIndex(sourceNodeID);
        }
        if (sourceNodeID == null || node == null) {
            return null;
        }
        mapped.add(sourceNodeID);
        mapped.addAll(this.mappedNodes(this._graph.getNodeByIndex(sourceNodeID), mapped, this._graph));
        mapped.addAll(this.mappedNodes(this._graph.getReversedGraph().getNodeByIndex(sourceNodeID), mapped, this._graph.getReversedGraph()));
        return mapped;
    }

    @Override
    protected final synchronized Set<I> mappedNodes(GraphNode<I> sourceNode, Set<I> alreadyMapped, WeightedGraph<I> graph) {
        WeightedGraph<I> weightedGraph;
        GraphNode target;
        if (sourceNode == null) {
            return alreadyMapped;
        }
        TreeSet mapped = new TreeSet();
        mapped.add(sourceNode.getID());
        if (graph.getAdjacents(sourceNode) != null) {
            for (WeightedGraphLink weightedGraphLink : graph.getAdjacents(sourceNode)) {
                target = weightedGraphLink.getTarget();
                if (alreadyMapped.contains(target.getID())) continue;
                mapped.addAll(this.mappedNodes(target, mapped, graph));
            }
        }
        if ((weightedGraph = graph.getReversedGraph()).getAdjacents(sourceNode) != null) {
            for (WeightedGraphLink weightedGraphLink : weightedGraph.getAdjacents(sourceNode)) {
                target = weightedGraphLink.getTarget();
                if (alreadyMapped.contains(target.getID())) continue;
                mapped.addAll(this.mappedNodes(target, mapped, weightedGraph));
            }
        }
        return mapped;
    }
}

