/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.parsers.impl;

import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.fao.fi.comet.domain.species.ReferenceSpeciesFactory;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.tools.parsers.impl.AbstractGNISpeciesNameParser;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.w3c.dom.Document;

@Singleton
@Named(value="GNILegacySpeciesNameParser")
public class GNILegacySpeciesNameParser
extends AbstractGNISpeciesNameParser {
    protected static final String UNINOMIAL_XPATH = "//node[node_key/. = 'uninomial']/node[node_key/. = 'string: ']/node_value/text()";
    protected static final String GENUS_NAME_XPATH = "//node[node_key/. = 'genus']/node[node_key/. = 'string: ']/node_value/text()";
    protected static final String SPECIES_NAME_XPATH = "//node[node_key/. = 'species']/node[node_key/. = 'string: ']/node_value/text()";
    private final XPathExpression UNINOMIAL_XPATH_EXPR;
    private final XPathExpression GENUS_NAME_XPATH_EXPR;
    private final XPathExpression SPECIES_NAME_XPATH_EXPR;

    public GNILegacySpeciesNameParser() throws Throwable {
        this.UNINOMIAL_XPATH_EXPR = this._xPathFactory.newXPath().compile(UNINOMIAL_XPATH);
        this.GENUS_NAME_XPATH_EXPR = this._xPathFactory.newXPath().compile(GENUS_NAME_XPATH);
        this.SPECIES_NAME_XPATH_EXPR = this._xPathFactory.newXPath().compile(SPECIES_NAME_XPATH);
    }

    @Override
    public String getId() {
        return "GNI_LEGACY";
    }

    @Override
    public String getName() {
        return "Global Names Index (legacy)";
    }

    @Override
    protected ReferenceSpeciesData doParse(Document entry) throws XPathExpressionException {
        boolean isUninomial;
        String uninomial = StringUtils.rawTrim(this.UNINOMIAL_XPATH_EXPR.evaluate(entry));
        String genus = StringUtils.rawTrim(this.GENUS_NAME_XPATH_EXPR.evaluate(entry));
        String species = StringUtils.rawTrim(this.SPECIES_NAME_XPATH_EXPR.evaluate(entry));
        boolean bl = isUninomial = uninomial != null && (genus == null || species == null);
        return ReferenceSpeciesFactory.newInstance(isUninomial ? uninomial : (genus != null && species != null ? String.valueOf(genus) + " " + species : (genus == null ? species : genus)));
    }
}

