/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.lexical.soundex.impl;

import java.util.TreeSet;
import javax.inject.Named;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.fao.vrmf.core.tools.lexical.soundex.PhraseSoundexGenerator;
import org.fao.vrmf.core.tools.lexical.soundex.impl.BasicSoundexGenerator;

@Named
public class BasicPhraseSoundexGenerator
extends BasicSoundexGenerator
implements PhraseSoundexGenerator {
    private static final long serialVersionUID = 6244056044888575218L;
    private int _processedWordsMinimumLengthLimit = 2;

    public BasicPhraseSoundexGenerator() {
    }

    public BasicPhraseSoundexGenerator(int minimumLength, int maximumLength) {
        super(minimumLength, maximumLength);
    }

    public BasicPhraseSoundexGenerator(int length) {
        super(length);
    }

    public int getProcessedWordsMinimumLengthLimit() {
        return this._processedWordsMinimumLengthLimit;
    }

    @Override
    public void setProcessedWordsMinimumLengthLimit(int wordLengthMinimumLimit) {
        if (wordLengthMinimumLimit <= 0) {
            throw new RuntimeException("The word length minimum limit should be greater than zero");
        }
        this._processedWordsMinimumLengthLimit = wordLengthMinimumLimit;
    }

    @Override
    public final String getWordSoundex(String word) {
        if (StringUtils.rawTrim(word) == null) {
            return null;
        }
        if (!this.isWord(word)) {
            throw new RuntimeException("You should provide a word to convert, not a phrase");
        }
        String preprocessed = this.preprocess(word);
        if (preprocessed.length() >= this.getProcessedWordsMinimumLengthLimit()) {
            return this.computeSoundex(preprocessed);
        }
        return null;
    }

    @Override
    public final String getPhraseSoundex(String phrase, boolean includeDuplicateParts) {
        if (StringUtils.rawTrim(phrase) == null) {
            return null;
        }
        String[] parts = this.preprocess(phrase).split("\\s");
        StringBuffer result = new StringBuffer();
        TreeSet<String> processedParts = new TreeSet<String>();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.length() >= this._processedWordsMinimumLengthLimit) {
                String soundexPart = this.computeSoundex(part);
                if (includeDuplicateParts || !processedParts.contains(soundexPart)) {
                    result.append(this.computeSoundex(part)).append(" ");
                }
                processedParts.add(soundexPart);
            }
            ++n2;
        }
        return result.toString().trim();
    }

    @Override
    public final String[] getPhraseSoundexParts(String phrase, boolean includeDuplicateParts) {
        if (StringUtils.rawTrim(phrase) == null) {
            return new String[0];
        }
        return this.getPhraseSoundex(phrase, includeDuplicateParts).split("\\s");
    }

    @Override
    public final String getFullPhraseSoundex(String phrase, boolean includeDuplicateParts) {
        if (StringUtils.rawTrim(phrase) == null) {
            return null;
        }
        return this.getPhraseSoundex(String.valueOf(phrase) + (this.isWord(phrase) ? "" : " " + phrase.replaceAll("\\s", "")), includeDuplicateParts).trim();
    }

    @Override
    public final String[] getFullPhraseSoundexParts(String phrase, boolean includeDuplicateParts) {
        if (StringUtils.rawTrim(phrase) == null) {
            return new String[0];
        }
        return this.getFullPhraseSoundex(phrase, includeDuplicateParts).split("\\s");
    }

    @Override
    public final String getFullPhraseSoundex(String phrase) {
        return this.getFullPhraseSoundex(phrase, false);
    }

    @Override
    public final String[] getFullPhraseSoundexParts(String phrase) {
        return this.getFullPhraseSoundexParts(phrase, false);
    }

    @Override
    public final String getPhraseSoundex(String phrase) {
        return this.getPhraseSoundex(phrase, false);
    }

    @Override
    public final String[] getPhraseSoundexParts(String phrase) {
        return this.getPhraseSoundexParts(phrase, false);
    }

    private final boolean isWord(String text) {
        return !text.contains(" ");
    }

    private final String preprocess(String toConvert) {
        String toReturn = toConvert.replaceAll("[^a-zA-Z|\\s]", "").replaceAll("\\s{2,}", " ").trim();
        return toReturn;
    }
}

