/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.oldutils;

import org.json.simple.JSONObject;

public class CustomField
implements Comparable<CustomField> {
    private String key;
    private String qualifiedKey;
    private String value;
    private int indexCategory = Integer.MAX_VALUE;
    private int indexMetadataField = Integer.MAX_VALUE;

    private void init(String key, String value, int indexCategory, int indexMetadataField) {
        if (key == null || value == null || key.isEmpty()) {
            throw new IllegalArgumentException("A custom field must have a key and a value! Provided values are " + key + "=" + value);
        }
        this.key = key;
        this.qualifiedKey = key;
        this.value = value;
        this.indexMetadataField = indexMetadataField;
        this.indexCategory = indexCategory;
        if (this.indexCategory < 0) {
            this.indexCategory = Integer.MAX_VALUE;
        }
        if (this.indexMetadataField < 0) {
            this.indexMetadataField = Integer.MAX_VALUE;
        }
    }

    public CustomField(JSONObject object) {
        this.init((String)object.get((Object)"key"), (String)object.get((Object)"value"), -1, -1);
    }

    public CustomField(String key, String value) {
        this.init(key, value, -1, -1);
    }

    public CustomField(String key, String value, int indexCategory, int indexMetadataField) {
        this.init(key, value, indexCategory, indexMetadataField);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getQualifiedKey() {
        return this.qualifiedKey;
    }

    public void setQualifiedKey(String qualifiedKey) {
        this.qualifiedKey = qualifiedKey;
    }

    public int getIndexCategory() {
        return this.indexCategory;
    }

    public void setIndexCategory(int indexCategory) {
        this.indexCategory = indexCategory;
        if (this.indexCategory < 0) {
            this.indexCategory = Integer.MAX_VALUE;
        }
    }

    public int getIndexMetadataField() {
        return this.indexMetadataField;
    }

    public void setIndexMetadataField(int indexMetadataField) {
        this.indexMetadataField = indexMetadataField;
        if (this.indexMetadataField < 0) {
            this.indexMetadataField = Integer.MAX_VALUE;
        }
    }

    public String toString() {
        return "CustomField [key=" + this.key + ", qualifiedKey=" + this.qualifiedKey + ", value=" + this.value + ", indexMetadataField=" + this.indexMetadataField + ", indexCategory=" + this.indexCategory + "]";
    }

    @Override
    public int compareTo(CustomField o) {
        if (this.indexCategory == o.indexCategory) {
            if (this.indexMetadataField == o.indexMetadataField) {
                return 0;
            }
            return this.indexMetadataField > o.indexMetadataField ? 1 : -1;
        }
        return this.indexCategory > o.indexCategory ? 1 : -1;
    }
}

