/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.workspace;

import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.gcat.utils.Constants;
import org.gcube.gcat.workspace.CatalogueMetadata;
import org.gcube.storagehub.ApplicationMode;
import org.gcube.storagehub.MetadataMatcher;
import org.gcube.storagehub.StorageHubManagement;
import org.glassfish.jersey.media.multipart.ContentDisposition;

public class CatalogueStorageHubManagement {
    protected StorageHubManagement storageHubManagement = new StorageHubManagement();
    protected String originalFilename;
    protected String mimeType;

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    protected String getOriginalFileName(HttpURLConnection httpURLConnection) throws ParseException {
        String contentDisposition = httpURLConnection.getHeaderFields().get("Content-Disposition").get(0);
        contentDisposition = contentDisposition.replaceAll("= ", "=").replaceAll(" =", "=");
        ContentDisposition formDataContentDisposition = new ContentDisposition(contentDisposition);
        return formDataContentDisposition.getFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL ensureResourcePersistence(URL persistedURL, String itemID, String resourceID) throws Exception {
        ApplicationMode applicationMode = new ApplicationMode(Constants.getCatalogueApplicationToken());
        try {
            applicationMode.start();
            GXHTTPStringRequest gxhttpStringRequest = GXHTTPStringRequest.newRequest((String)persistedURL.toString());
            gxhttpStringRequest.from("gCat");
            gxhttpStringRequest.isExternalCall(true);
            HttpURLConnection httpURLConnection = gxhttpStringRequest.get();
            this.mimeType = httpURLConnection.getContentType().split(";")[0];
            this.originalFilename = this.getOriginalFileName(httpURLConnection);
            CatalogueMetadata catalogueMetadata = new CatalogueMetadata(itemID);
            this.storageHubManagement.setCheckMetadata((MetadataMatcher)catalogueMetadata);
            Metadata metadata = catalogueMetadata.getMetadata(persistedURL, this.originalFilename, resourceID);
            persistedURL = this.storageHubManagement.persistFile(httpURLConnection.getInputStream(), resourceID, this.mimeType, metadata);
            this.mimeType = this.storageHubManagement.getMimeType();
            URL uRL = persistedURL;
            return uRL;
        }
        finally {
            applicationMode.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResourcePersistence(String itemID, String resourceID, String mimeType) throws Exception {
        ApplicationMode applicationMode = new ApplicationMode(Constants.getCatalogueApplicationToken());
        try {
            applicationMode.start();
            this.storageHubManagement = new StorageHubManagement();
            CatalogueMetadata catalogueMetadata = new CatalogueMetadata(itemID);
            this.storageHubManagement.setCheckMetadata((MetadataMatcher)catalogueMetadata);
            this.storageHubManagement.removePersistedFile(resourceID, mimeType);
        }
        finally {
            applicationMode.end();
        }
    }

    protected void internalAddRevisionID(String resourceID, String revisionID) {
        FileContainer fileContainer = this.storageHubManagement.getCreatedFile();
        Metadata metadata = ((AbstractFileItem)fileContainer.get()).getMetadata();
        Map map = metadata.getMap();
        map.put("CatalogueResourceID", resourceID);
        map.put("CatalogueResourceRevisionID", revisionID);
        metadata.setMap(map);
        fileContainer.setMetadata(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFile(String resourceID, String revisionID) {
        ApplicationMode applicationMode = new ApplicationMode(Constants.getCatalogueApplicationToken());
        try {
            applicationMode.start();
            FileContainer createdfile = this.storageHubManagement.getCreatedFile();
            createdfile.rename(resourceID);
            this.internalAddRevisionID(resourceID, revisionID);
        }
        finally {
            applicationMode.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRevisionID(String resourceID, String revisionID) {
        ApplicationMode applicationMode = new ApplicationMode(Constants.getCatalogueApplicationToken());
        try {
            applicationMode.start();
            this.internalAddRevisionID(resourceID, revisionID);
        }
        finally {
            applicationMode.end();
        }
    }
}

