/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.search;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.j2ee.workspacemanager.search.JCRSearchFolder;
import org.gcube.common.homelibary.model.items.SearchItemDelegate;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;

public class JCRSearchFolderItem
extends JCRSearchFolder {
    protected static final String CONTENT = "jcr:content";
    protected static final String DATA = "jcr:data";
    private static final String MIME_TYPE = "jcr:mimeType";
    private static final String SIZE = "hl:size";
    long size;
    String mimeType;
    String folderItemType;

    public JCRSearchFolderItem(Node node, String itemName) throws RepositoryException {
        super(node, itemName);
        this.folderItemType = node.getPrimaryNodeType().getName();
        String[] nameGlobs = new String[]{MIME_TYPE, SIZE};
        try {
            PropertyIterator properties = node.getNode(CONTENT).getProperties(nameGlobs);
            while (properties.hasNext()) {
                Property propery = properties.nextProperty();
                switch (propery.getName()) {
                    case "jcr:mimeType": {
                        this.mimeType = propery.getString();
                        break;
                    }
                    case "hl:size": {
                        this.size = propery.getLong();
                        break;
                    }
                }
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public SearchItemDelegate getSearchItemDelegate() {
        super.getSearchItemDelegate();
        this.item.setType(WorkspaceItemType.FOLDER_ITEM);
        this.item.setMimeType(this.mimeType);
        this.item.setSize(this.size);
        return this.item;
    }
}

