/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.ftp;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.ItemDelegateWrapper;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateFolder
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(CreateFolder.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        String name = request.getParameter("name");
        String description = request.getParameter("description");
        String parentPath = request.getParameter("parentPath");
        logger.info("Servlet CreateFolder called with parameters: [ name: " + name + " - description: " + description + "- parentPath: " + parentPath + "]");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            ItemDelegate item = this.createFolder(sessionManager.getLogin(request), name, description, parentPath, session);
            xmlConfig = xstream.toXML((Object)item.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error repository ex " + e.getMessage());
            xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    private ItemDelegate createFolder(String portalLogin, String name, String description, String parentPath, Session session) throws Exception {
        ItemDelegate new_item = null;
        try {
            Node parent = session.getNode(parentPath);
            ItemDelegate delegate = new ItemDelegate();
            delegate.setName(name);
            delegate.setTitle(name);
            delegate.setDescription(description);
            delegate.setParentId(parent.getIdentifier());
            delegate.setOwner(portalLogin);
            delegate.setPrimaryType("nthl:workspaceItem");
            delegate.setLastAction(WorkspaceItemAction.CREATED);
            ItemDelegateWrapper wrapper = new ItemDelegateWrapper(delegate, portalLogin);
            new_item = wrapper.save(session);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return new_item;
    }
}

