/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.dataminermanagercl.server.monitor;

import java.util.ArrayList;
import java.util.TimerTask;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.dataminermanagercl.server.monitor.DMMonitor;
import org.gcube.data.analysis.dataminermanagercl.server.monitor.DMMonitorListener;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationId;
import org.gcube.data.analysis.dataminermanagercl.shared.process.ComputationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMMonitorTask
extends TimerTask {
    private static Logger logger = LoggerFactory.getLogger(DMMonitorTask.class);
    private ArrayList<DMMonitorListener> listeners;
    private ComputationId computationId;
    private SClient sClient;
    private DMMonitor dmMonitor;

    public DMMonitorTask(DMMonitor dmMonitor, ComputationId computationId, SClient sClient, ArrayList<DMMonitorListener> listeners) {
        this.computationId = computationId;
        this.sClient = sClient;
        this.listeners = listeners;
        this.dmMonitor = dmMonitor;
        logger.debug("DMMonitorTask");
    }

    @Override
    public void run() {
        logger.debug("Requesting operation progress");
        ComputationStatus computationStatus = null;
        try {
            computationStatus = this.sClient.getComputationStatus(this.computationId);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
        }
        logger.debug("ComputationStatus: " + computationStatus);
        if (computationStatus == null) {
            logger.error("ComputationStatus is null");
            return;
        }
        ComputationStatus.Status status = computationStatus.getStatus();
        if (status == null) {
            logger.error("Status is null");
            return;
        }
        switch (status) {
            case ACCEPTED: {
                this.fireAccepted(computationStatus);
                break;
            }
            case CANCELLED: {
                this.dmMonitor.cancel();
                this.fireCancelled(computationStatus);
                break;
            }
            case COMPLETE: {
                this.dmMonitor.cancel();
                this.fireComplete(computationStatus);
                break;
            }
            case FAILED: {
                this.dmMonitor.cancel();
                this.fireFailed(computationStatus);
                break;
            }
            case RUNNING: {
                this.fireRunning(computationStatus);
                break;
            }
        }
    }

    private void fireAccepted(ComputationStatus computationStatus) {
        for (DMMonitorListener listener : this.listeners) {
            listener.accepted();
        }
    }

    private void fireCancelled(ComputationStatus computationStatus) {
        for (DMMonitorListener listener : this.listeners) {
            listener.cancelled();
        }
    }

    private void fireComplete(ComputationStatus computationStatus) {
        for (DMMonitorListener listener : this.listeners) {
            listener.complete(computationStatus.getPercentage());
        }
    }

    private void fireFailed(ComputationStatus computationStatus) {
        for (DMMonitorListener listener : this.listeners) {
            listener.failed(computationStatus.getMessage(), computationStatus.getError());
        }
    }

    private void fireRunning(ComputationStatus computationStatus) {
        for (DMMonitorListener listener : this.listeners) {
            listener.running(computationStatus.getPercentage());
        }
    }
}

