/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.dataminermanagercl.shared.process;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.dataminermanagercl.shared.StringUtil;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter;
import org.gcube.data.analysis.dataminermanagercl.shared.process.OperatorCategory;

public class Operator
implements Serializable,
Comparable<Operator> {
    private static final long serialVersionUID = -4084498655645951188L;
    private String id;
    private String name;
    private String briefDescription;
    private String description;
    private OperatorCategory category;
    private List<Parameter> operatorParameters = new ArrayList<Parameter>();
    private boolean hasImage = false;

    public Operator() {
    }

    public Operator(String id, String briefDescription, String description, OperatorCategory category) {
        this.id = id;
        if (id != null) {
            this.name = StringUtil.getCapitalWords(id);
        }
        this.briefDescription = briefDescription;
        this.description = description;
        this.category = category;
    }

    public Operator(String id, String briefDescription, String description, OperatorCategory category, boolean hasImage) {
        this.id = id;
        if (id != null) {
            this.name = StringUtil.getCapitalWords(id);
        }
        this.briefDescription = briefDescription;
        this.description = description;
        this.category = category;
        this.hasImage = hasImage;
    }

    public Operator(String id, String name, String briefDescription, String description, OperatorCategory category) {
        this.id = id;
        if (name != null) {
            this.name = StringUtil.getCapitalWords(name);
        }
        this.briefDescription = briefDescription;
        this.description = description;
        this.category = category;
    }

    public Operator(String id, String name, String briefDescription, String description, OperatorCategory category, List<Parameter> operatorParameters, boolean hasImage) {
        this.id = id;
        if (name != null) {
            this.name = StringUtil.getCapitalWords(name);
        }
        this.briefDescription = briefDescription;
        this.description = description;
        this.category = category;
        this.operatorParameters = operatorParameters;
        this.hasImage = hasImage;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBriefDescription() {
        return this.briefDescription;
    }

    public void setBriefDescription(String briefDescription) {
        this.briefDescription = briefDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OperatorCategory getCategory() {
        return this.category;
    }

    public void setCategory(OperatorCategory category) {
        this.category = category;
    }

    public List<Parameter> getOperatorParameters() {
        return this.operatorParameters;
    }

    public void setOperatorParameters(List<Parameter> operatorParameters) {
        this.operatorParameters = operatorParameters;
    }

    public void addOperatorParameter(Parameter operatorParameter) {
        this.operatorParameters.add(operatorParameter);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasImage() {
        return this.hasImage;
    }

    public void setHasImage(boolean hasImage) {
        this.hasImage = hasImage;
    }

    public Operator clone() {
        return new Operator(this.id, this.name, this.briefDescription, this.description, this.category, new ArrayList<Parameter>(this.operatorParameters), this.hasImage);
    }

    public String toString() {
        return "Operator [id=" + this.id + ", name=" + this.name + ", briefDescription=" + this.briefDescription + ", description=" + this.description + ", operatorParameters=" + this.operatorParameters + ", hasImage=" + this.hasImage + "]";
    }

    @Override
    public int compareTo(Operator o) {
        return this.id.compareTo(o.getId());
    }
}

