package org.gcube.data.analysis.dataminermanagercl.shared.data;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class TableItemSimple implements Serializable {

	private static final long serialVersionUID = -1204016958353092014L;
	private String id;
	private String name;
	private String description;
	private String type;
	private ArrayList<ColumnItem> columns;
	private boolean tabularResource;

	/**
	 * 
	 */
	public TableItemSimple() {
		super();
		columns = new ArrayList<ColumnItem>();
		tabularResource = false;
	}

	/**
	 * 
	 * @param id
	 *            id
	 * @param name
	 *            name
	 * @param description
	 *            description
	 * @param type
	 *            type
	 */
	public TableItemSimple(String id, String name, String description, String type) {
		super();
		columns = new ArrayList<ColumnItem>();
		this.id = id;
		this.name = name;
		this.description = description;
		this.type = type;
		tabularResource = false;
	}

	/**
	 * 
	 * @param id
	 *            id
	 * @param name
	 *            name
	 * @param description
	 *            description
	 */
	public TableItemSimple(String id, String name, String description) {
		super();
		columns = new ArrayList<ColumnItem>();
		this.id = id;
		this.name = name;
		this.description = description;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param type
	 *            the type to set
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	public ArrayList<ColumnItem> getColumns() {
		return columns;
	}

	public void setColumns(ArrayList<ColumnItem> columns) {
		this.columns = columns;
	}

	public boolean isTabularResource() {
		return tabularResource;
	}

	public void setTabularResource(boolean tabularResource) {
		this.tabularResource = tabularResource;
	}

	@Override
	public String toString() {
		return "TableItemSimple [id=" + id + ", name=" + name + ", description=" + description + ", type=" + type
				+ ", columns=" + columns + ", tabularResource=" + tabularResource + "]";
	}

}
