/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.experimentspace.computation;

import com.thoughtworks.xstream.XStream;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.data.analysis.statisticalmanager.SMOperationType;
import org.gcube.data.analysis.statisticalmanager.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.exception.HLManagementException;
import org.gcube.data.analysis.statisticalmanager.exception.HibernateManagementException;
import org.gcube.data.analysis.statisticalmanager.exception.ISException;
import org.gcube.data.analysis.statisticalmanager.exception.PersistenceManagementException;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.SMPersistenceManager;
import org.gcube.data.analysis.statisticalmanager.util.ScopeUtils;
import org.gcube.data.analysis.statisticalmanager.util.ServiceUtil;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMFile;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMObject;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuilderComputationOutput {
    private static Logger logger = LoggerFactory.getLogger(BuilderComputationOutput.class);
    private String portalLogin;
    private ScopeUtils.ScopeBean scopeBean;
    private SMComputation computation;

    public BuilderComputationOutput(String portalLogin, SMComputation computation) {
        this.portalLogin = portalLogin;
        this.scopeBean = ScopeUtils.getCurrentScopeBean();
        this.computation = computation;
    }

    private SMTable serializeTabular(OutputTable output) throws ISException, HibernateManagementException {
        String template = ((TableTemplates)output.getTemplateNames().get(0)).toString();
        SMTable table = new SMTable(template);
        table.setPortalLogin(this.portalLogin);
        table.setAlgorithm(this.computation.getAlgorithm());
        table.setResourceType(SMResourceType.TABULAR.ordinal());
        table.setResourceId(output.getTableName());
        table.setDescription(output.getDescription());
        table.setName(output.getName());
        table.setProvenance(SMOperationType.COMPUTED.ordinal());
        table.setCreationDate(Calendar.getInstance());
        table.setOperationId(this.computation.getOperationId());
        SMPersistenceManager.addCreatedResource((SMResource)table);
        return table;
    }

    private SMFile serializeFile(PrimitiveType output) throws HLManagementException, ISException, HibernateManagementException, PersistenceManagementException {
        try {
            logger.debug("---------- serialize File ");
            WorkspaceFolder appFolder = ServiceUtil.getWorkspaceSMFolder(ServiceUtil.getWorkspaceHome(this.portalLogin));
            logger.debug("---------- created application folder ");
            File outputFile = (File)output.getContent();
            String fileName = this.generateUniqueName(output.getName());
            logger.debug("---------- fileName : " + fileName);
            logger.debug("Going to store FILE " + outputFile.getAbsolutePath() + " size " + outputFile.length() + " as " + fileName + " with description " + output.getDescription());
            ExternalFile f = appFolder.createExternalFileItem(fileName, output.getDescription(), null, outputFile);
            String url = f.getPublicLink();
            SMFile file = new SMFile(f.getMimeType(), fileName, url);
            file.setPortalLogin(this.portalLogin);
            file.setAlgorithm(this.computation.getAlgorithm());
            file.setResourceType(SMResourceType.FILE.ordinal());
            file.setResourceId(UUID.randomUUID().toString());
            file.setDescription(output.getDescription());
            file.setName(outputFile.getName());
            file.setProvenance(SMOperationType.COMPUTED.ordinal());
            file.setCreationDate(Calendar.getInstance());
            file.setOperationId(this.computation.getOperationId());
            SMPersistenceManager.addCreatedResource((SMResource)file);
            return file;
        }
        catch (StatisticalManagerException e) {
            throw e;
        }
        catch (InternalErrorException e) {
            throw new PersistenceManagementException("Unable to get public link", e);
        }
        catch (Exception e) {
            throw new PersistenceManagementException("Unable to create external file", e);
        }
    }

    private SMObject serializePrimitiveObject(PrimitiveType primitiveObject) {
        switch (primitiveObject.getType()) {
            case STRING: {
                SMObject object = new SMObject((String)primitiveObject.getContent());
                object.setPortalLogin(this.portalLogin);
                object.setAlgorithm(this.computation.getAlgorithm());
                object.setName(PrimitiveTypes.STRING.toString());
                object.setResourceType(SMResourceType.OBJECT.ordinal());
                object.setDescription(primitiveObject.getDescription());
                object.setProvenance(SMOperationType.COMPUTED.ordinal());
                object.setCreationDate(Calendar.getInstance());
                object.setOperationId(this.computation.getOperationId());
                return object;
            }
        }
        return null;
    }

    private SMObject serializeImage(PrimitiveType primitiveObject) throws HLManagementException, PersistenceManagementException {
        try {
            logger.debug("---------- serialize Image ");
            WorkspaceFolder appFolder = ServiceUtil.getWorkspaceSMFolder(ServiceUtil.getWorkspaceHome(this.portalLogin));
            logger.debug("---------- create application folder ");
            Map map = (Map)primitiveObject.getContent();
            String folderName = this.generateUniqueName(primitiveObject.getName());
            logger.debug("---------- folder name " + folderName);
            WorkspaceFolder subFolder = appFolder.createFolder(folderName, "SM Image");
            for (Map.Entry entry : map.entrySet()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)ImageTools.toBufferedImage((Image)((Image)entry.getValue())), "PNG", os);
                if (logger.isDebugEnabled()) {
                    ByteArrayOutputStream osLog = new ByteArrayOutputStream();
                    boolean writeFlag = ImageIO.write((RenderedImage)ImageTools.toBufferedImage((Image)((Image)entry.getValue())), "PNG", osLog);
                    logger.debug("Going to store IMG " + (String)entry.getKey() + " writeFlag " + writeFlag + ", size=" + osLog.size() + " as " + (String)entry.getKey() + " with description " + primitiveObject.getDescription());
                }
                ExternalImage f = subFolder.createExternalImageItem((String)entry.getKey(), primitiveObject.getDescription(), null, (InputStream)new ByteArrayInputStream(os.toByteArray()));
                logger.debug("Uploaded IMG, obtained url " + f.getPublicLink());
            }
            SMObject resource = new SMObject(subFolder.getPath());
            resource.setPortalLogin(this.portalLogin);
            resource.setResourceType(SMResourceType.OBJECT.ordinal());
            resource.setResourceId(UUID.randomUUID().toString());
            resource.setName(PrimitiveTypes.IMAGES.toString());
            resource.setDescription(primitiveObject.getDescription());
            resource.setProvenance(SMOperationType.COMPUTED.ordinal());
            resource.setCreationDate(Calendar.getInstance());
            resource.setOperationId(this.computation.getOperationId());
            return resource;
        }
        catch (Exception e) {
            throw new PersistenceManagementException("Unable to serialize images", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SMObject serializeMap(PrimitiveType primitiveObject) throws PersistenceManagementException, HLManagementException {
        try {
            Map map = (Map)primitiveObject.getContent();
            LinkedHashMap outputs = new LinkedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                SMResource resource = this.serialize((StatisticalType)entry.getValue());
                outputs.put(entry.getKey(), resource);
            }
            File file = File.createTempFile("output", "sm");
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                XStream xstream = new XStream();
                xstream.toXML(outputs, (OutputStream)fos);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
            logger.debug("Create tmp file " + file.getAbsolutePath());
            WorkspaceFolder appFolder = ServiceUtil.getWorkspaceSMFolder(ServiceUtil.getWorkspaceHome(this.portalLogin));
            String fileName = this.generateUniqueName(primitiveObject.getName());
            logger.debug("---------- filename " + fileName);
            logger.debug("Going to store MAP " + file.getAbsolutePath() + " size " + file.length() + " as " + fileName + " with description " + primitiveObject.getDescription());
            ExternalFile f = appFolder.createExternalFileItem(fileName, primitiveObject.getDescription(), null, file);
            String url = f.getPublicLink();
            logger.debug("Obtained public link " + url);
            SMObject resource = new SMObject(url);
            resource.setPortalLogin(this.portalLogin);
            resource.setResourceType(SMResourceType.OBJECT.ordinal());
            resource.setResourceId(UUID.randomUUID().toString());
            resource.setName(PrimitiveTypes.MAP.toString());
            resource.setDescription(primitiveObject.getDescription());
            resource.setProvenance(SMOperationType.COMPUTED.ordinal());
            resource.setCreationDate(Calendar.getInstance());
            resource.setOperationId(this.computation.getOperationId());
            return resource;
        }
        catch (Exception e) {
            throw new PersistenceManagementException("Unable to serialize map", e);
        }
    }

    public SMResource serialize(StatisticalType object) throws PersistenceManagementException, ISException, HibernateManagementException, HLManagementException {
        logger.debug("Serializing computation output under scope " + this.scopeBean);
        ScopeUtils.setAuthorizationSettings(this.scopeBean);
        if (object instanceof OutputTable) {
            return this.serializeTabular((OutputTable)object);
        }
        if (object instanceof PrimitiveType) {
            PrimitiveType primitiveObject = (PrimitiveType)object;
            if (primitiveObject.getType() == PrimitiveTypes.MAP) {
                return this.serializeMap(primitiveObject);
            }
            if (primitiveObject.getType() == PrimitiveTypes.IMAGES) {
                return this.serializeImage(primitiveObject);
            }
            if (primitiveObject.getType() == PrimitiveTypes.FILE) {
                return this.serializeFile(primitiveObject);
            }
            return this.serializePrimitiveObject(primitiveObject);
        }
        logger.error("throw Exception into serialize resource");
        throw new PersistenceManagementException("Object type is not valid, " + object.toString());
    }

    private String generateUniqueName(String baseName) {
        return baseName + "_" + ServiceUtil.getDateTime() + "_CMP" + this.computation.getOperationId();
    }
}

